/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.containermenu;

import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.energy.networking.NodeStats;
import com.denfop.containermenu.ContainerMenuHandHeldInventory;
import com.denfop.datacomponent.ContainerItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EFReaderInventory;
import com.denfop.network.packet.PacketItemStackUpdate;
import com.denfop.utils.ModUtils;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerMenuEFReader
extends ContainerMenuHandHeldInventory<EFReaderInventory> {
    private final EnergyTile tile;
    private final int current;

    public ContainerMenuEFReader(EFReaderInventory efReaderInventory, ItemStack itemStack1, Player player) {
        super(efReaderInventory, null);
        this.player = player;
        this.inventory = player.getInventory();
        BlockPos pos = (BlockPos)itemStack1.getOrDefault(DataComponentsInit.TELEPORT, (Object)BlockPos.ZERO);
        this.current = player.getInventory().selected;
        this.tile = EnergyNetGlobal.instance.getTile(efReaderInventory.player.level(), pos);
    }

    @Override
    public void clicked(int slot, int button, ClickType type, Player player) {
        ItemStack held;
        if (slot >= 0 && slot < this.slots.size() && ((EFReaderInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem())) {
            return;
        }
        boolean closeGUI = false;
        block0 : switch (type) {
            case CLONE: 
            case PICKUP_ALL: 
            case QUICK_CRAFT: {
                break;
            }
            case PICKUP: 
            case THROW: {
                if (slot < 0 || slot >= this.slots.size()) break;
                closeGUI = ((EFReaderInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem());
                break;
            }
            case QUICK_MOVE: {
                if (slot < 0 || slot >= this.slots.size() || !((EFReaderInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem())) break;
                this.setCarried(ModUtils.emptyStack);
                break;
            }
            case SWAP: {
                if (button == this.current) {
                    this.setCarried(ItemStack.EMPTY);
                    return;
                }
                assert (this.getSlotFromInventory((Container)player.getInventory(), button) != null);
                boolean swapOut = ((EFReaderInventory)this.base).isThisContainer(this.getSlotFromInventory((Container)player.getInventory(), button).getItem());
                boolean swapTo = ((EFReaderInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem());
                if (!swapOut && !swapTo) break;
                for (int i = 0; i < 9; ++i) {
                    if ((!swapOut || slot != Objects.requireNonNull(this.getSlotFromInventory((Container)player.getInventory(), (int)i)).index) && (!swapTo || button != i)) continue;
                    if (!(player instanceof ServerPlayer)) break block0;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.send((Packet)new ClientboundSetCarriedItemPacket(i));
                    break block0;
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected ClickType: " + String.valueOf(type));
            }
        }
        ItemStack stack = this.slotClick1(slot, button, type, player);
        if (closeGUI && !player.level().isClientSide()) {
            ((EFReaderInventory)this.base).saveAsThrown(stack);
            player.closeContainer();
        } else if (type == ClickType.CLONE && ((EFReaderInventory)this.base).isThisContainer(held = player.getInventory().getSelected())) {
            ((ContainerItem)held.getOrDefault(DataComponentsInit.CONTAINER, (Object)ContainerItem.EMPTY)).updateUUID(held, 0);
        }
        this.setCarried(stack);
    }

    public ItemStack slotClick1(int slotId, int dragType, ClickType clickType, Player player) {
        super.clicked(slotId, dragType, clickType, player);
        return this.getCarried();
    }

    @Override
    public void broadcastChanges() {
        super.broadcastChanges();
        NodeStats nodeStats = EnergyNetGlobal.instance.getNodeStats(this.tile, this.player.level());
        if (this.player instanceof ServerPlayer) {
            new PacketItemStackUpdate("energySink", nodeStats.getEnergyIn(), (ServerPlayer)this.player);
            new PacketItemStackUpdate("energySource", nodeStats.getEnergyOut(), (ServerPlayer)this.player);
        }
    }
}

