/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.containermenu;

import com.denfop.IUCore;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.AbstractComponent;
import com.denfop.containermenu.SlotInvSlot;
import com.denfop.containermenu.SlotVirtual;
import com.denfop.inventory.Inventory;
import com.denfop.mixin.access.AbstractContainerMenuAccessor;
import com.denfop.network.packet.PacketUpdateFieldContainerTile;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ContainerMenuBase<T extends CustomWorldContainer>
extends AbstractContainerMenu {
    public final T base;
    public Player player;
    net.minecraft.world.entity.player.Inventory inventory;

    public ContainerMenuBase(T t, Player player) {
        super(t.getMenuType(), t.getContainerId());
        this.base = t;
        if (player != null) {
            this.player = player;
            this.inventory = player.getInventory();
        }
    }

    protected static final boolean isValidTargetSlot(Slot slot, ItemStack stack, boolean allowEmpty, boolean requireInputOnly) {
        if (!slot.mayPlace(stack)) {
            return false;
        }
        if (!allowEmpty && !slot.hasItem()) {
            return false;
        }
        if (!requireInputOnly) {
            return true;
        }
        return slot instanceof SlotInvSlot && ((SlotInvSlot)slot).inventory.canInput();
    }

    public Player getPlayer() {
        return this.player;
    }

    protected Slot addSlotToContainer(Slot p_38898_) {
        return this.addSlot(p_38898_);
    }

    protected void addPlayerInventorySlots(net.minecraft.world.entity.player.Inventory inventory, int height) {
        this.addPlayerInventorySlots(inventory, 178, height);
        this.inventory = inventory;
    }

    public net.minecraft.world.entity.player.Inventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public Slot getSlotFromInventory(Container inv, int slotIn) {
        for (Slot slot : this.slots) {
            if (slot.container != inv || slot.index != slotIn) continue;
            return slot;
        }
        return (Slot)this.slots.get(slotIn % this.slots.size());
    }

    protected void addPlayerInventorySlots(net.minecraft.world.entity.player.Inventory inventory, int width, int height) {
        int n3;
        int n4 = (width - 162) / 2;
        for (n3 = 0; n3 < 3; ++n3) {
            for (int i = 0; i < 9; ++i) {
                this.addSlot(new Slot((Container)inventory, i + n3 * 9 + 9, n4 + i * 18, height + -82 + n3 * 18));
            }
        }
        for (n3 = 0; n3 < 9; ++n3) {
            this.addSlot(new Slot((Container)inventory, n3, n4 + n3 * 18, height + -24));
        }
    }

    protected Slot addSlot(Slot p_38898_) {
        return super.addSlot(p_38898_);
    }

    public void clicked(int slotId, int dragType, ClickType clickType, Player player) {
        if (IUCore.network.getClient() != null && player.level().isClientSide && this.checkClick()) {
            return;
        }
        if (slotId < 0) {
            super.clicked(slotId, dragType, clickType, player);
            return;
        }
        Slot slot = (Slot)this.slots.get(slotId);
        if (!(slot instanceof SlotVirtual)) {
            if (slot instanceof SlotInvSlot) {
                SlotInvSlot slot1 = (SlotInvSlot)slot;
                if (!slot1.inventory.canShift() && clickType == ClickType.QUICK_MOVE) {
                    return;
                }
                ((SlotInvSlot)slot).setDragType(dragType);
            }
            super.clicked(slotId, dragType, clickType, player);
            this.base.setChanged();
        } else {
            ((SlotVirtual)slot).slotClick(slotId, dragType, clickType, player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private boolean checkClick() {
        return Minecraft.getInstance().getSingleplayerServer() != null;
    }

    public final ItemStack quickMoveStack(Player player, int sourceSlotIndex) {
        Slot sourceSlot = (Slot)this.slots.get(sourceSlotIndex);
        if (sourceSlot != null && sourceSlot.hasItem()) {
            ItemStack sourceItemStack = sourceSlot.getItem();
            int oldSourceItemStackSize = ModUtils.getSize(sourceItemStack);
            ItemStack resultStack = sourceSlot.container == player.getInventory() ? this.handlePlayerSlotShiftClick(player, sourceItemStack) : this.handleGUISlotShiftClick(player, sourceItemStack);
            if (ModUtils.isEmpty(resultStack) || ModUtils.getSize(resultStack) != oldSourceItemStackSize) {
                sourceSlot.set(resultStack);
                sourceSlot.onTake(player, sourceItemStack);
                if (!player.level().isClientSide) {
                    this.broadcastChanges();
                }
            }
        }
        return ModUtils.emptyStack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.moveItemStackTo(stack, (List<Slot>)this.slots, startIndex, endIndex, reverseDirection);
    }

    protected boolean moveItemStackTo(ItemStack stack, List<Slot> slots, int startIndex, int endIndex, boolean reverseDirection) {
        ItemStack itemstack;
        Slot slot;
        int i;
        boolean flag = false;
        int n = i = reverseDirection ? endIndex - 1 : startIndex;
        if (stack.isStackable()) {
            while (!stack.isEmpty() && !(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = slots.get(i);
                itemstack = slot.getItem();
                if (!itemstack.isEmpty() && slot.mayPlace(stack) && ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.getCount() + stack.getCount();
                    if (j <= (maxSize = Math.min(slot.getMaxStackSize(itemstack), stack.getMaxStackSize()))) {
                        stack.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        slot.setChanged();
                        flag = true;
                    } else if (itemstack.getCount() < maxSize) {
                        stack.shrink(maxSize - itemstack.getCount());
                        itemstack.setCount(maxSize);
                        slot.set(itemstack);
                        slot.setChanged();
                        flag = true;
                    }
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        if (!stack.isEmpty()) {
            int n2 = i = reverseDirection ? endIndex - 1 : startIndex;
            while (!(!reverseDirection ? i >= endIndex : i < startIndex)) {
                slot = slots.get(i);
                itemstack = slot.getItem();
                if (itemstack.isEmpty() && slot.mayPlace(stack)) {
                    slot.set(stack.split(Math.min(stack.getCount(), slot.getMaxStackSize(stack))));
                    slot.setChanged();
                    flag = true;
                    break;
                }
                i += reverseDirection ? -1 : 1;
            }
        }
        return flag;
    }

    protected ItemStack handlePlayerSlotShiftClick(Player player, ItemStack sourceItemStack) {
        for (int run = 0; run < 4 && !ModUtils.isEmpty(sourceItemStack); ++run) {
            Slot targetSlot;
            Iterator iterator = this.slots.iterator();
            while (iterator.hasNext() && ((targetSlot = (Slot)iterator.next()) instanceof SlotVirtual || targetSlot.container == player.getInventory() || !ContainerMenuBase.isValidTargetSlot(targetSlot, sourceItemStack, run % 2 == 1, run < 2) || !ModUtils.isEmpty(sourceItemStack = this.transfer(sourceItemStack, targetSlot)))) {
            }
        }
        return sourceItemStack;
    }

    protected ItemStack handleGUISlotShiftClick(Player player, ItemStack sourceItemStack) {
        for (int run = 0; run < 2 && !sourceItemStack.isEmpty(); ++run) {
            Slot targetSlot;
            ListIterator it = this.slots.listIterator(this.slots.size());
            while (it.hasPrevious() && ((targetSlot = (Slot)it.previous()) instanceof SlotVirtual || targetSlot.container != player.getInventory() || !ContainerMenuBase.isValidTargetSlot(targetSlot, sourceItemStack, run == 1, false) || !(sourceItemStack = this.transfer(sourceItemStack, targetSlot)).isEmpty())) {
            }
        }
        return sourceItemStack;
    }

    public boolean stillValid(Player player) {
        return this.base.stillValid(player);
    }

    public void broadcastChanges() {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (((Slot)this.slots.get((int)i)).container != this.player.getInventory() && this.slots.get(i) instanceof SlotInvSlot) continue;
            ItemStack itemstack = ((Slot)this.slots.get(i)).getItem();
            Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).copy());
            ((AbstractContainerMenuAccessor)((Object)this)).invokeTriggerSlotListeners(i, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
            ((AbstractContainerMenuAccessor)((Object)this)).invokeSynchronizeSlotToRemote(i, itemstack, (java.util.function.Supplier<ItemStack>)supplier);
        }
        ((AbstractContainerMenuAccessor)((Object)this)).invokeSynchronizeCarriedToRemote();
        if (this.base instanceof BlockEntity) {
            if (this.player instanceof ServerPlayer) {
                new PacketUpdateFieldContainerTile((BlockEntityBase)((Object)this.base), (ServerPlayer)this.player);
            }
            if (this.base instanceof BlockEntityInventory && this.player instanceof ServerPlayer) {
                for (AbstractComponent component : ((BlockEntityInventory)this.base).getComponentList()) {
                    component.onContainerUpdate((ServerPlayer)this.player);
                }
            }
        }
    }

    protected final ItemStack transfer(ItemStack stack, Slot dst) {
        int amount = this.getTransferAmount(stack, dst);
        if (amount > 0) {
            ItemStack dstStack = dst.getItem();
            if (ModUtils.isEmpty(dstStack)) {
                dst.set(ModUtils.setSize(stack, amount));
            } else {
                dst.set(ModUtils.incSize(dstStack, amount));
            }
            stack = ModUtils.decSize(stack, amount);
        }
        return stack;
    }

    private int getTransferAmount(ItemStack stack, Slot dst) {
        int amount = Math.min(dst.container.getMaxStackSize(), dst.getMaxStackSize());
        amount = Math.min(amount, stack.isStackable() ? stack.getMaxStackSize() : 1);
        ItemStack dstStack = dst.getItem();
        if (!ModUtils.isEmpty(dstStack)) {
            if (!ModUtils.checkItemEqualityStrict(stack, dstStack)) {
                return 0;
            }
            amount -= ModUtils.getSize(dstStack);
        }
        amount = Math.min(amount, ModUtils.getSize(stack));
        return amount;
    }

    public SlotInvSlot findClassSlot(Class<? extends Inventory> invSlotClass) {
        for (Slot slot : this.slots) {
            if (!(slot instanceof SlotInvSlot) || !((SlotInvSlot)slot).inventory.getClass().equals(invSlotClass)) continue;
            return (SlotInvSlot)slot;
        }
        return null;
    }

    public List<SlotInvSlot> findClassSlots(Class<? extends Inventory> invSlotClass) {
        ArrayList<SlotInvSlot> list = new ArrayList<SlotInvSlot>();
        for (Slot slot : this.slots) {
            if (!(slot instanceof SlotInvSlot) || !((SlotInvSlot)slot).inventory.getClass().equals(invSlotClass)) continue;
            list.add((SlotInvSlot)slot);
        }
        return list;
    }

    public List<SlotInvSlot> getSlots() {
        ArrayList<SlotInvSlot> list = new ArrayList<SlotInvSlot>();
        for (Slot slot : this.slots) {
            if (!(slot instanceof SlotInvSlot)) continue;
            list.add((SlotInvSlot)slot);
        }
        return list;
    }
}

