/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.config;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    public static final Common COMMON;
    public static final ModConfigSpec COMMON_SPEC;

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue newsystem;
        public final ModConfigSpec.BooleanValue enableEasyMode;
        public final ModConfigSpec.BooleanValue cableEasyMode;
        public final ModConfigSpec.BooleanValue enableExplosion;
        public final ModConfigSpec.BooleanValue enableLosing;
        public final ModConfigSpec.IntValue maxVein;
        public final ModConfigSpec.IntValue gasMaxVein;
        public final ModConfigSpec.IntValue gasChance;
        public final ModConfigSpec.BooleanValue airPollution;
        public final ModConfigSpec.BooleanValue soilPollution;
        public final ModConfigSpec.BooleanValue pressureWork;
        public final ModConfigSpec.BooleanValue damageRadiation;
        public final ModConfigSpec.BooleanValue informationText;
        public final ModConfigSpec.BooleanValue radiationChunksEnabled;
        public final ModConfigSpec.BooleanValue radiationDamageEnabled;
        public final ModConfigSpec.BooleanValue radiationAccumulationEnabled;
        public final ModConfigSpec.IntValue desertChance;
        public final ModConfigSpec.IntValue desertMin;
        public final ModConfigSpec.IntValue desertMax;
        public final ModConfigSpec.IntValue oceanChance;
        public final ModConfigSpec.IntValue oceanMin;
        public final ModConfigSpec.IntValue oceanMax;
        public final ModConfigSpec.IntValue deepOceanChance;
        public final ModConfigSpec.IntValue deepOceanMin;
        public final ModConfigSpec.IntValue deepOceanMax;
        public final ModConfigSpec.IntValue riverChance;
        public final ModConfigSpec.IntValue riverMin;
        public final ModConfigSpec.IntValue riverMax;
        public final ModConfigSpec.IntValue savannaChance;
        public final ModConfigSpec.IntValue savannaMin;
        public final ModConfigSpec.IntValue savannaMax;
        public final ModConfigSpec.IntValue defaultChance;
        public final ModConfigSpec.IntValue defaultMin;
        public final ModConfigSpec.IntValue defaultMax;
        public final ModConfigSpec.BooleanValue enableAllProfessions;
        public final ModConfigSpec.BooleanValue enableEngineer;
        public final ModConfigSpec.BooleanValue enableMechanic;
        public final ModConfigSpec.BooleanValue enableNuclear;
        public final ModConfigSpec.BooleanValue enableMetallurg;
        public final ModConfigSpec.BooleanValue enableChemist;
        public final ModConfigSpec.BooleanValue enableBotanist;
        public final ModConfigSpec.BooleanValue cooldownEnabled;
        public final ModConfigSpec.BooleanValue defaultSpawnEnabled;

        public Common(ModConfigSpec.Builder builder) {
            builder.push("Generation ores");
            this.defaultSpawnEnabled = builder.comment("Enable approximately default ore generation (false = vein system)").define("defaultSpawnEnabled", false);
            builder.pop();
            builder.push("Mechanisms");
            this.cooldownEnabled = builder.comment("Enable cooldown for mechanisms (false = no cooldown)").define("cooldownEnabled", true);
            builder.pop();
            builder.push("General");
            this.maxVein = builder.comment("Maximum amount of ore in a vein").defineInRange("maxVein", 30000, 1, Integer.MAX_VALUE);
            this.gasMaxVein = builder.comment("Maximum amount of mb in a gas vein (not natural gas)").defineInRange("gasMaxVein", 200000, 1, Integer.MAX_VALUE);
            this.gasChance = builder.comment("Chance to get a gas vein (not natural gas)").defineInRange("gasChance", 25, 1, 100);
            builder.pop();
            builder.push("Information Text");
            this.informationText = builder.comment("Informational text when logging the game").define("enable", true);
            builder.pop();
            builder.push("Oil Vein");
            this.desertChance = builder.comment("Chance % for oil vein in desert").defineInRange("desertChance", 65, 0, 100);
            this.desertMin = builder.defineInRange("desertMin", 250000, 0, Integer.MAX_VALUE);
            this.desertMax = builder.defineInRange("desertMax", 1000000, 0, Integer.MAX_VALUE);
            this.oceanChance = builder.defineInRange("oceanChance", 60, 0, 100);
            this.oceanMin = builder.defineInRange("oceanMin", 250000, 0, Integer.MAX_VALUE);
            this.oceanMax = builder.defineInRange("oceanMax", 750000, 0, Integer.MAX_VALUE);
            this.deepOceanChance = builder.defineInRange("deepOceanChance", 65, 0, 100);
            this.deepOceanMin = builder.defineInRange("deepOceanMin", 150000, 0, Integer.MAX_VALUE);
            this.deepOceanMax = builder.defineInRange("deepOceanMax", 500000, 0, Integer.MAX_VALUE);
            this.riverChance = builder.defineInRange("riverChance", 50, 0, 100);
            this.riverMin = builder.defineInRange("riverMin", 100000, 0, Integer.MAX_VALUE);
            this.riverMax = builder.defineInRange("riverMax", 250000, 0, Integer.MAX_VALUE);
            this.savannaChance = builder.defineInRange("savannaChance", 50, 0, 100);
            this.savannaMin = builder.defineInRange("savannaMin", 150000, 0, Integer.MAX_VALUE);
            this.savannaMax = builder.defineInRange("savannaMax", 500000, 0, Integer.MAX_VALUE);
            this.defaultChance = builder.defineInRange("defaultChance", 11, 0, 100);
            this.defaultMin = builder.defineInRange("defaultMin", 0, 0, Integer.MAX_VALUE);
            this.defaultMax = builder.defineInRange("defaultMax", 300000, 0, Integer.MAX_VALUE);
            builder.pop();
            builder.push("VillagerProfessions");
            this.enableAllProfessions = builder.comment("Enable registration of ALL custom villager professions").define("enableAllProfessions", true);
            this.enableEngineer = builder.define("enableEngineer", true);
            this.enableMechanic = builder.define("enableMechanic", true);
            this.enableNuclear = builder.define("enableNuclear", true);
            this.enableMetallurg = builder.define("enableMetallurg", true);
            this.enableChemist = builder.define("enableChemist", true);
            this.enableBotanist = builder.define("enableBotanist", true);
            builder.pop();
            builder.push("TransformerMode");
            this.newsystem = builder.comment("Transformer mode enabled").define("TransformerMode", true);
            this.enableEasyMode = builder.comment("Unchecking the tier").define("enableUnchecking", false);
            this.cableEasyMode = builder.comment("Unlimiting the conduction of energy in the cable").define("cableUnlimiting", false);
            this.enableExplosion = builder.comment("Enable explosion from mechanisms if transformer mode is on").define("enableExplosion", true);
            this.enableLosing = builder.comment("Enable lose energy in cables if transformer mode is on").define("enableLosing", true);
            builder.pop();
            builder.push("pollution");
            this.airPollution = builder.comment("Air pollution").define("airPollution", true);
            this.soilPollution = builder.comment("Soil pollution").define("soilPollution", true);
            builder.pop();
            builder.push("Pressure Network");
            this.pressureWork = builder.comment("Remove the pressure level restriction in the pressure system (allows machines to work at any pressure level)").define("pressureRestriction", true);
            builder.pop();
            builder.push("Radiation");
            this.damageRadiation = builder.comment("Enable damage from radiation").define("radiationDamageEnabled", true);
            this.radiationChunksEnabled = builder.comment("Enable radiation chunks generation").define("radiationChunksEnabled", true);
            this.radiationDamageEnabled = builder.comment("Enable damage from radiation chunk").define("radiationDamageEnabled", true);
            this.radiationAccumulationEnabled = builder.comment("Enable radiation accumulation on the player").define("radiationAccumulationEnabled", true);
            builder.pop();
        }
    }
}

