/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets.pressure;

import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.api.otherenergies.pressure.IPressureAcceptor;
import com.denfop.api.otherenergies.pressure.IPressureEmitter;
import com.denfop.api.otherenergies.pressure.IPressureTile;
import com.denfop.componets.BufferEnergy;
import com.denfop.componets.PressureComponent;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class EnergyNetDelegate
implements IPressureTile {
    public final BufferEnergy buffer;
    public final BlockPos worldPosition;
    private final boolean clientSide;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public double tick;
    public Map<Direction, IPressureTile> energyConductorMap = new HashMap<Direction, IPressureTile>();
    protected double pastEnergy;
    protected double perenergy;
    List<InfoTile<IPressureTile>> validReceivers = new LinkedList<InfoTile<IPressureTile>>();
    private long id;
    private int hashCodeSource;

    public EnergyNetDelegate(PressureComponent block) {
        this.worldPosition = block.getParent().pos;
        this.clientSide = block.getParent().getLevel().isClientSide;
        this.sinkDirections = block.sinkDirections;
        this.sourceDirections = block.sourceDirections;
        this.buffer = block.buffer;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    public boolean acceptsPressureFrom(IPressureEmitter emitter, Direction dir) {
        return this.sinkDirections.contains(dir);
    }

    public boolean emitsPressureTo(IPressureAcceptor receiver, Direction dir) {
        return this.sourceDirections.contains(dir);
    }

    @Override
    @NotNull
    public BlockPos getPos() {
        return this.worldPosition;
    }

    @Override
    public BlockEntity getTile() {
        return null;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Map<Direction, IPressureTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public void RemoveTile(IPressureTile tile, Direction facing1) {
        if (!this.clientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IPressureTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IPressureTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public List<InfoTile<IPressureTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void AddTile(IPressureTile tile, Direction facing1) {
        if (!this.clientSide) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IPressureTile>(tile, facing1.getOpposite()));
        }
    }

    public Set<Direction> getSourceDirs() {
        return Collections.unmodifiableSet(this.sourceDirections);
    }

    public Set<Direction> getSinkDirs() {
        return Collections.unmodifiableSet(this.sinkDirections);
    }
}

