/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets.cold;

import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.api.otherenergies.cool.ICoolAcceptor;
import com.denfop.api.otherenergies.cool.ICoolEmitter;
import com.denfop.api.otherenergies.cool.ICoolTile;
import com.denfop.componets.BufferEnergy;
import com.denfop.componets.CoolComponent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnergyNetDelegate
implements ICoolTile {
    public final BufferEnergy buffer;
    public final BlockPos worldPosition;
    private final boolean clientSide;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public double tick;
    public Map<Direction, ICoolTile> energyConductorMap = new HashMap<Direction, ICoolTile>();
    public int hashCodeSource;
    protected double pastEnergy;
    protected double perenergy;
    List<InfoTile<ICoolTile>> validReceivers = new LinkedList<InfoTile<ICoolTile>>();
    private long id;

    public EnergyNetDelegate(CoolComponent block) {
        this.worldPosition = block.getParent().pos;
        this.clientSide = block.getParent().getLevel().isClientSide;
        this.sinkDirections = block.sinkDirections;
        this.sourceDirections = block.sourceDirections;
        this.buffer = block.buffer;
    }

    public double getSourceEnergy() {
        return this.buffer.storage;
    }

    @Override
    public BlockPos getPos() {
        return this.worldPosition;
    }

    @Override
    public BlockEntity getTile() {
        return null;
    }

    public boolean acceptsCoolFrom(ICoolEmitter var1, Direction var2) {
        for (Direction facing1 : this.sinkDirections) {
            if (facing1.ordinal() != var2.ordinal()) continue;
            return true;
        }
        return false;
    }

    public boolean emitsCoolTo(ICoolAcceptor receiver, Direction dir) {
        return this.sourceDirections.contains(dir);
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void AddCoolTile(ICoolTile tile, Direction facing1) {
        if (!this.clientSide && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<ICoolTile>(tile, facing1.getOpposite()));
        }
    }

    @Override
    public void RemoveCoolTile(ICoolTile tile, Direction facing1) {
        if (!this.clientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<ICoolTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ICoolTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public Map<Direction, ICoolTile> getCoolTiles() {
        return this.energyConductorMap;
    }

    public void setSinkDirections(Set<Direction> sinkDirections) {
        this.sinkDirections = sinkDirections;
    }

    public void setSourceDirections(Set<Direction> sourceDirections) {
        this.sourceDirections = sourceDirections;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public List<InfoTile<ICoolTile>> getCoolValidReceivers() {
        return this.validReceivers;
    }
}

