/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets.client;

import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.componets.AbstractComponent;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

public class ComponentVisibleArea
extends AbstractComponent {
    public AABB aabb;
    private boolean visible;

    public ComponentVisibleArea(BlockEntityBase parent) {
        super(parent);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("component.visible_area.info"));
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tag = super.writeToNbt();
        tag.putBoolean("visible", this.visible);
        return tag;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.visible = nbt.getBoolean("visible");
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        super.onNetworkUpdate(is);
        this.visible = is.readBoolean();
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(player.registryAccess());
        buffer.writeBoolean(this.visible);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packetBuffer = super.updateComponent();
        packetBuffer.writeBoolean(this.visible);
        return packetBuffer;
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand) {
        this.visible = !this.visible;
        return super.onSneakingActivated(player, hand);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.parent.getWorld().isClientSide) {
            GlobalRenderManager.addRender(this.parent.getWorld(), this.parent.getPos(), this.createFunction(this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private Function<RenderLevelStageEvent, Void> createFunction(ComponentVisibleArea componentVisibleArea) {
        Function<RenderLevelStageEvent, Void> function = event -> {
            PoseStack poseStack = event.getPoseStack();
            if (!this.visible) {
                return null;
            }
            poseStack.pushPose();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VertexConsumer buffer = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(com.denfop.render.base.RenderType.QUAD_TRANSPARENT_OVER_WATER);
            Matrix4f matrix = poseStack.last().pose();
            float x1 = (float)this.aabb.minX;
            float y1 = (float)this.aabb.minY;
            float z1 = (float)this.aabb.minZ;
            float x2 = (float)this.aabb.maxX;
            float y2 = (float)this.aabb.maxY;
            float z2 = (float)this.aabb.maxZ;
            float red = 0.0f;
            float green = 0.4862745f;
            float blue = 0.6666667f;
            float alpha = 0.5f;
            int f = (int)this.aabb.minX;
            int f1 = (int)this.aabb.minY;
            int f2 = (int)this.aabb.minZ;
            int f3 = (int)this.aabb.maxX;
            int f4 = (int)this.aabb.maxY;
            int f5 = (int)this.aabb.maxZ;
            buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y1, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y1, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y2, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x1, y2, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y1, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y2, z1).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y2, z2).setColor(red, green, blue, alpha);
            buffer.addVertex(matrix, x2, y1, z2).setColor(red, green, blue, alpha);
            poseStack.popPose();
            poseStack.pushPose();
            PoseStack.Pose matrix3f = poseStack.last();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            VertexConsumer p_109623_ = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.lines());
            red = 0.0f;
            green = 0.4862745f;
            blue = 1.0f;
            alpha = 1.0f;
            Matrix4f matrix4f = poseStack.last().pose();
            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, -1.0f, 0.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, -1.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, -1.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f1, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 0.0f, -1.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 0.0f, -1.0f);
            p_109623_.addVertex(matrix4f, (float)f, (float)f4, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 1.0f, 0.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f1, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 1.0f, 0.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f2).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
            p_109623_.addVertex(matrix4f, (float)f3, (float)f4, (float)f5).setColor(red, green, blue, alpha).setNormal(matrix3f, 0.0f, 0.0f, 1.0f);
            poseStack.popPose();
            return null;
        };
        return function;
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.parent.getWorld().isClientSide) {
            GlobalRenderManager.removeRender(this.parent.getWorld(), this.parent.getPos());
        }
    }
}

