/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.energy.interfaces.Dual;
import com.denfop.api.energy.interfaces.EnergySink;
import com.denfop.api.energy.interfaces.EnergySource;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.Connect;
import com.denfop.network.packet.CustomPacketBuffer;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;

public class WirelessComponent
extends AbstractComponent {
    boolean hasUpdate = false;
    List<Connect> connectList = new LinkedList<Connect>();
    EnergySource energySource;
    private boolean isDual;

    public WirelessComponent(BlockEntityBase parent) {
        super(parent);
    }

    public void setUpdate(boolean hasUpdate) {
        this.hasUpdate = hasUpdate;
    }

    public boolean isHasUpdate() {
        return this.hasUpdate;
    }

    public void setEnergySource(EnergySource energySource) {
        this.energySource = energySource;
        this.isDual = this.energySource instanceof Dual;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        super.onNetworkUpdate(is);
        this.hasUpdate = is.readBoolean();
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16, player.registryAccess());
        buffer.writeBoolean(this.hasUpdate);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packetBuffer = super.updateComponent();
        packetBuffer.writeBoolean(this.hasUpdate);
        return packetBuffer;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.hasUpdate && this.energySource != null && this.energySource.isSource()) {
            if (this.energySource.canExtractEnergy() == 0.0) {
                return;
            }
            for (Connect connect : this.connectList) {
                if (this.energySource.canExtractEnergy() == 0.0) break;
                if (connect.getTile() == null) {
                    connect.setTile(EnergyNetGlobal.instance.getTile(this.getParent().getLevel(), connect.getPos()));
                }
                if (this.isDual && connect.isDual() || connect.getTile() == null || !(connect.getTile() instanceof EnergySink)) continue;
                EnergySink sink = (EnergySink)connect.getTile();
                double demanded = sink.getDemandedEnergy();
                demanded = Math.min(demanded, this.energySource.canExtractEnergy());
                sink.receiveEnergy(demanded);
                this.energySource.extractEnergy(demanded);
            }
        }
    }

    public void addConnect(BlockPos pos) {
        this.connectList.add(new Connect(pos, this.getParent().getLevel()));
    }

    public void removeConnect(BlockPos pos) {
        this.connectList.removeIf(connect -> connect.getPos().equals((Object)pos));
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag nbtTagCompound = super.writeToNbt();
        ListTag nbtTagList = new ListTag();
        for (Connect connect : this.connectList) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("x", connect.getPos().getX());
            nbt.putInt("y", connect.getPos().getY());
            nbt.putInt("z", connect.getPos().getZ());
            nbtTagList.add((Object)nbt);
        }
        nbtTagCompound.put("connect", (Tag)nbtTagList);
        return nbtTagCompound;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        ListTag contentList = nbt.getList("Items", 10);
        for (int i = 0; i < contentList.size(); ++i) {
            CompoundTag connectNbt = contentList.getCompound(i);
            Connect connect = new Connect(new BlockPos(connectNbt.getInt("x"), connectNbt.getInt("y"), connectNbt.getInt("z")));
            this.connectList.add(connect);
        }
        if (!this.connectList.isEmpty()) {
            this.setUpdate(true);
        }
    }

    public void removeAll() {
        this.connectList.clear();
    }
}

