/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.item.MultiBlockItem;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.material.MapColor;

public final class TileBlockCreator {
    public static TileBlockCreator instance;
    public int index = 0;
    private List<InfoAboutTile<?>> dataInfo = new LinkedList();

    public TileBlockCreator() {
        instance = this;
    }

    public <E extends Enum<E>> BlockTileEntity<E> create(E enumClass, ResourceLocation location) {
        InfoAboutTile<E> instance = new InfoAboutTile<E>(enumClass, this.index);
        BlockTileEntity<E> block = BlockTileEntity.create(enumClass, location, instance);
        instance.setBlock(block);
        this.dataInfo.add(instance);
        ++this.index;
        return block;
    }

    public void buildBlocks() {
        for (InfoAboutTile<?> tile : this.dataInfo) {
            for (MultiBlockEntity multiTileBlock : tile.teBlocks) {
                multiTileBlock.buildDummies();
            }
        }
        this.dataInfo = new ArrayList(this.dataInfo);
    }

    public BlockTileEntity get(int index) {
        return this.dataInfo.get(index).getBlock();
    }

    public List<MultiBlockEntity> getAllTiles() {
        ArrayList<MultiBlockEntity> tileBlocks = new ArrayList<MultiBlockEntity>();
        for (InfoAboutTile<?> tile : this.dataInfo) {
            tileBlocks.addAll(tile.teBlocks);
        }
        return tileBlocks;
    }

    public static class InfoAboutTile<E extends Enum<E>> {
        private final boolean specialModels;
        private final int index;
        private final CreativeModeTab tab;
        private final MapColor defaultMaterial;
        private final List<? extends MultiBlockEntity> listBlock;
        private List<MultiBlockEntity> teBlocks;
        private List<MultiBlockEntity> idMap = new LinkedList<MultiBlockEntity>();
        private BlockTileEntity<E> block;

        InfoAboutTile(E universe, int index) {
            this.index = index;
            this.teBlocks = new LinkedList<MultiBlockEntity>();
            this.specialModels = MultiBlockItem.class.isAssignableFrom(universe.getClass());
            this.register(universe);
            this.idMap = new ArrayList<MultiBlockEntity>(this.idMap);
            this.teBlocks = new ArrayList<MultiBlockEntity>(this.teBlocks);
            this.defaultMaterial = this.teBlocks.get(0).getMaterial();
            this.tab = this.teBlocks.get(0).getCreativeTab();
            this.listBlock = this.teBlocks;
            this.listBlock.sort((o1, o2) -> {
                if (o1.getId() < o2.getId()) {
                    return -1;
                }
                if (o1.getId() - o2.getId() == 0) {
                    return 0;
                }
                return 1;
            });
        }

        public List<? extends MultiBlockEntity> getListBlock() {
            return this.listBlock;
        }

        public CreativeModeTab getTab() {
            return this.tab;
        }

        public Class<? extends BlockEntityBase> getClassFromName(String name) {
            for (MultiBlockEntity multiBlockEntity : this.listBlock) {
                if (!multiBlockEntity.getName().equals(name)) continue;
                return multiBlockEntity.getTeClass();
            }
            return null;
        }

        void register(E block) {
            this.teBlocks.add((MultiBlockEntity)block);
            ((MultiBlockEntity)block).setIdBlock(this.index);
            if (((ISubEnum)block).getId() > -1) {
                int ID = ((ISubEnum)block).getId();
                while (this.idMap.size() < ID) {
                    this.idMap.add(null);
                }
                if (this.idMap.size() == ID) {
                    this.idMap.add((MultiBlockEntity)block);
                } else {
                    this.idMap.set(ID, (MultiBlockEntity)block);
                }
            }
        }

        public List<MultiBlockEntity> getTeBlocks() {
            return this.teBlocks;
        }

        public BlockTileEntity<E> getBlock() {
            return this.block;
        }

        void setBlock(BlockTileEntity<E> block) {
            this.block = block;
        }

        public MapColor getDefaultMaterial() {
            return this.defaultMaterial;
        }

        public boolean hasSpecialModels() {
            return this.specialModels;
        }

        public List<MultiBlockEntity> getIdMap() {
            return this.idMap;
        }
    }
}

