/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.api.item.armor.HazmatLike;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import com.denfop.dataregistry.DataBlock;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import com.denfop.potion.IUPotion;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.AABB;
import oshi.util.tuples.Pair;

public class BlocksRadiationOre<T extends Enum<T>>
extends BlockCore<T>
implements IBlockTag {
    public static final BooleanProperty BOOL_PROPERTY = BooleanProperty.create((String)"hasdamage");

    public BlocksRadiationOre(T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).destroyTime(1.0f).randomTicks().explosionResistance(5.0f).sound(SoundType.STONE).requiresCorrectToolForDrops(), elements, element, dataBlock);
        BlockTagsProvider.list.add(this);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BOOL_PROPERTY, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    int getMetaFromState(BlockState state) {
        return ((ISubEnum)this.getElement()).getId();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
        p_49915_.add(new Property[]{BOOL_PROPERTY});
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        return (BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BOOL_PROPERTY, (Comparable)Boolean.valueOf(false));
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (world.isClientSide) {
            return;
        }
        boolean damage = (Boolean)state.getValue((Property)BOOL_PROPERTY);
        if (!damage) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        PacketUpdateRadiationValue packet = new PacketUpdateRadiationValue(chunkPos, 1.0, world);
        AABB axisAlignedBB = new AABB((double)(pos.getX() - 2), (double)(pos.getY() - 2), (double)(pos.getZ() - 2), (double)(pos.getX() + 3), (double)(pos.getY() + 3), (double)(pos.getZ() + 3));
        List players = world.getEntitiesOfClass(Player.class, axisAlignedBB);
        for (Player player : players) {
            boolean canAffect = !HazmatLike.hasCompleteHazmat((LivingEntity)player);
            if (!canAffect) continue;
            player.addEffect(new MobEffectInstance(IUPotion.rad, 400, 0));
            player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 400, 0));
        }
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)this.stateDefinition.any()).getBlock()));
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)"pickaxe", (Object)1);
    }

    public static enum Type implements ISubEnum
    {
        americium_ore(0),
        neptunium_ore(1),
        curium_ore(2);

        private final int metadata;
        private final String name;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Override
        public int getId() {
            return this.metadata;
        }

        @Override
        public String getOtherPart() {
            return "type=";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "blockradiationore";
        }

        public int getLight() {
            return 0;
        }
    }
}

