/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUItem;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import com.denfop.dataregistry.DataBlock;
import com.denfop.world.WorldBaseGen;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;
import oshi.util.tuples.Pair;

public class BlockOres2<T extends Enum<T>>
extends BlockCore<T>
implements IBlockTag {
    public BlockOres2(T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).destroyTime(1.0f).explosionResistance(5.0f).sound(SoundType.STONE).requiresCorrectToolForDrops(), elements, element, dataBlock);
        BlockTagsProvider.list.add(this);
    }

    @Override
    int getMetaFromState(BlockState state) {
        return ((ISubEnum)this.getElement()).getId();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        return (BlockState)this.stateDefinition.any();
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)this.stateDefinition.any()).getBlock()));
    }

    @Override
    public List<ItemStack> getDrops(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, int fortune) {
        Random rand = WorldBaseGen.random;
        int meta = this.getMetaFromState(state);
        if (meta >= 3 && meta <= 5) {
            return Collections.singletonList(new ItemStack((ItemLike)IUItem.rawMetals.getStack(this.getMetaFromState(state) - 3 + 22), 1 + this.getDrop(fortune)));
        }
        return super.getDrops(world, pos, state, fortune);
    }

    private int getDrop(int fortune) {
        switch (fortune) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 3;
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        int meta = this.getMetaFromState(state);
        if (meta == 0) {
            return SoundType.SAND;
        }
        if (meta > 2) {
            return SoundType.STONE;
        }
        return super.getSoundType(state, level, pos, entity);
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        if (((ISubEnum)this.getElement()).getId() >= 3 && ((ISubEnum)this.getElement()).getId() < 6) {
            return new Pair((Object)"pickaxe", (Object)1);
        }
        return new Pair((Object)"shovel", (Object)1);
    }

    public static enum Type implements ISubEnum
    {
        lithium(0),
        beryllium(1),
        bor(2),
        osmium(3),
        tantalum(4),
        cadmium(5),
        saltpeter(6),
        calcium(7);

        private final int metadata;
        private final String name;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Override
        public int getId() {
            return this.metadata;
        }

        @Override
        public String getOtherPart() {
            return "type=";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "baseore1";
        }

        public int getLight() {
            return 0;
        }
    }
}

