/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.IUItem;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.dataregistry.DataBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockFoam<T extends Enum<T>>
extends BlockCore<T> {
    public BlockFoam(T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOL).destroyTime(0.01f).noOcclusion().noCollission().explosionResistance(10.0f).sound(SoundType.WOOL).randomTicks(), elements, element, dataBlock);
    }

    public static float getHardenChance(Level world, BlockPos pos, BlockState state, FoamType type) {
        int light = world.getMaxLocalRawBrightness(pos);
        if (!state.supportsExternalFaceHiding() && state.getBlock().getLightEmission(state, (BlockGetter)world, pos) == 0) {
            Direction[] var5;
            for (Direction side : var5 = Direction.values()) {
                light = Math.max(light, world.getMaxLocalRawBrightness(pos.offset(side.getNormal())));
            }
        }
        int avgTime = type.hardenTime * (16 - light);
        return 1.0f / (float)(avgTime * 20);
    }

    public void randomTick(BlockState p_222954_, ServerLevel p_222955_, BlockPos p_222956_, RandomSource p_222957_) {
        int tickSpeed = p_222955_.getGameRules().getInt(GameRules.RULE_RANDOMTICKING);
        if (tickSpeed <= 0) {
            throw new IllegalStateException("Foam was randomly ticked when world " + String.valueOf(p_222955_) + " isn't ticking?");
        }
        FoamType type = (FoamType)this.getElement();
        float chance = BlockFoam.getHardenChance((Level)p_222955_, p_222956_, p_222954_, type) * 4096.0f / (float)tickSpeed;
        if (p_222957_.nextFloat() < chance) {
            p_222955_.setBlock(p_222956_, FoamType.values()[this.getMetaFromState(p_222954_)].getResult(), 3);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack p_316304_, BlockState p_316362_, Level p_316459_, BlockPos p_316366_, Player p_316132_, InteractionHand p_316595_, BlockHitResult p_316140_) {
        ItemStack handItem = p_316132_.getItemInHand(p_316595_);
        if (!handItem.isEmpty() && handItem.is(new ItemStack((ItemLike)Blocks.SAND).getItem())) {
            p_316459_.setBlock(p_316366_, FoamType.values()[this.getMetaFromState(p_316362_)].getResult(), 3);
            handItem.shrink(1);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        return (BlockState)this.stateDefinition.any();
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)this.stateDefinition.any()).getBlock()));
    }

    public static enum FoamType implements ISubEnum
    {
        reinforced(600);

        public final int hardenTime;

        private FoamType(int hardenTime) {
            this.hardenTime = hardenTime;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public boolean registerOnlyBlock() {
            return true;
        }

        @Override
        public String getMainPath() {
            return "foam";
        }

        @Override
        public int getId() {
            return this.ordinal();
        }

        public BlockState getResult() {
            return IUItem.blockResource.getBlock(7).defaultBlockState();
        }
    }
}

