/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IBaseRecipe;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.blocks.BlockCore;
import com.denfop.blocks.IDeposits;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.ItemBlockCore;
import com.denfop.datagen.blocktags.BlockTagsProvider;
import com.denfop.datagen.blocktags.IBlockTag;
import com.denfop.dataregistry.DataBlock;
import com.denfop.items.energy.ItemHammer;
import com.denfop.utils.Localization;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.VeinType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class BlockDeposits1<T extends Enum<T>>
extends BlockCore<T>
implements IBlockTag,
SimpleWaterloggedBlock,
IDeposits {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final VoxelShape Deposits = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.2, (double)1.0);
    Map<Integer, List<String>> mapInf = new HashMap<Integer, List<String>>();

    public BlockDeposits1(T[] elements, T element, DataBlock<T, ? extends BlockCore<T>, ? extends ItemBlockCore<T>> dataBlock) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).destroyTime(3.0f).noOcclusion().explosionResistance(5.0f).sound(SoundType.STONE).requiresCorrectToolForDrops(), elements, element, dataBlock);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        BlockTagsProvider.list.add(this);
    }

    public static boolean isFree(BlockState p_53242_) {
        return p_53242_.isAir() || p_53242_.is(BlockTags.FIRE) || p_53242_.liquid() || p_53242_.canBeReplaced();
    }

    @Override
    public List<String> getInformationFromMeta() {
        int meta = ((ISubEnum)this.getElement()).getId();
        List<String> inf = this.mapInf.get(meta);
        if (inf == null) {
            VeinType vein = WorldBaseGen.veinTypes.get(16 + meta);
            ArrayList<String> stringList = new ArrayList<String>();
            String s = Localization.translate("deposists.jei1") + (vein.getHeavyOre() != null ? new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1).getDisplayName().getString() : new ItemStack((ItemLike)vein.getOres().get(0).getBlock().getBlock(), 1).getDisplayName().getString());
            stringList.add(s);
            if (vein.getHeavyOre() != null) {
                String s1 = new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1).getDisplayName().getString() + " 50%";
                stringList.add(s1);
                for (int i = 0; i < vein.getOres().size(); ++i) {
                    ChanceOre chanceOre = vein.getOres().get(i);
                    String s2 = new ItemStack((ItemLike)chanceOre.getBlock().getBlock(), 1).getDisplayName().getString() + " " + chanceOre.getChance() + "%";
                    stringList.add(s2);
                }
            } else {
                for (int i = 0; i < vein.getOres().size(); ++i) {
                    ChanceOre chanceOre = vein.getOres().get(i);
                    String s2 = new ItemStack((ItemLike)chanceOre.getBlock().getBlock(), 1).getDisplayName().getString() + " " + chanceOre.getChance() + "%";
                    stringList.add(s2);
                }
            }
            this.mapInf.put(meta, stringList);
            return stringList;
        }
        return inf;
    }

    @Override
    int getMetaFromState(BlockState state) {
        return ((ISubEnum)this.getElement()).getId();
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        int levelEnchant = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)player.getMainHandItem());
        return levelEnchant == 0;
    }

    @Override
    public List<ItemStack> getDrops(BlockState p_60537_, LootParams.Builder p_60538_) {
        ItemStack tool = (ItemStack)p_60538_.getParameter(LootContextParams.TOOL);
        BlockPos pos = new BlockPos((int)((Vec3)p_60538_.getParameter((LootContextParam)LootContextParams.ORIGIN)).x, (int)((Vec3)p_60538_.getParameter((LootContextParam)LootContextParams.ORIGIN)).y, (int)((Vec3)p_60538_.getParameter((LootContextParam)LootContextParams.ORIGIN)).z);
        Object drops = NonNullList.create();
        drops = this.getDrops((Level)p_60538_.getLevel(), pos, p_60537_, EnchantmentHelper.getItemEnchantmentLevel((Holder)p_60538_.getLevel().registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), (ItemStack)tool), tool);
        return drops;
    }

    public List<ItemStack> getDrops(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, int fortune, ItemStack tool) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (tool.getItem() instanceof ItemHammer) {
            int meta = this.getMetaFromState(state);
            VeinType vein = WorldBaseGen.veinTypes.get(16 + meta);
            if (vein.getHeavyOre() == null) {
                ChanceOre block = vein.getOres().get(0);
                drops.add(new ItemStack((ItemLike)block.getBlock().getBlock(), 1));
            } else {
                List<BaseMachineRecipe> recipe_list;
                IBaseRecipe recipe = Recipes.recipes.getRecipe("handlerho");
                MachineRecipe output = Recipes.recipes.getRecipeMachineRecipeOutput(recipe, recipe_list = Recipes.recipes.getRecipeList("handlerho"), false, Collections.singletonList(new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1)));
                if (output != null) {
                    int[] col = new int[output.getRecipe().output.items.size()];
                    for (int i = 0; i < col.length; ++i) {
                        col[i] = output.getRecipe().output.metadata.getInt("input" + i);
                        col[i] = Math.min(col[i], 95);
                    }
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (int i = 0; i < col.length; ++i) {
                        RandomSource rand = world.random;
                        if (rand.nextInt(100) >= col[i]) continue;
                        stacks.add(output.getRecipe().output.items.get(i));
                    }
                    for (ItemStack stack : stacks) {
                        BaseMachineRecipe rec1 = Recipes.recipes.getRecipeOutput("macerator", false, stack);
                        if (rec1 != null) {
                            ItemStack stack1 = rec1.output.items.get(0).copy();
                            stack1.setCount(1);
                            drops.add(stack1);
                            continue;
                        }
                        drops.add(stack.copy());
                    }
                }
            }
        } else {
            int meta = this.getMetaFromState(state);
            VeinType vein = WorldBaseGen.veinTypes.get(16 + meta);
            if (vein.getHeavyOre() == null) {
                ChanceOre block = vein.getOres().get(0);
                drops.add(new ItemStack((ItemLike)block.getBlock().getBlock(), 1));
            } else {
                drops.add(new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1));
            }
        }
        return drops;
    }

    public ItemStack getCloneItemStack(LevelReader p_304395_, BlockPos p_49824_, BlockState pState) {
        int meta = this.getMetaFromState(pState);
        VeinType vein = WorldBaseGen.veinTypes.get(16 + meta);
        if (vein.getHeavyOre() == null) {
            ChanceOre block = vein.getOres().get(0);
            return new ItemStack((ItemLike)block.getBlock().getBlock(), 1);
        }
        return new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1);
    }

    @Override
    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        int meta = this.getMetaFromState(state);
        VeinType vein = WorldBaseGen.veinTypes.get(16 + meta);
        if (vein.getHeavyOre() == null) {
            ChanceOre block = vein.getOres().get(0);
            return new ItemStack((ItemLike)block.getBlock().getBlock(), 1);
        }
        return new ItemStack((ItemLike)vein.getHeavyOre().getBlock(), 1);
    }

    public BlockState updateShape(BlockState p_154530_, Direction p_154531_, BlockState p_154532_, LevelAccessor p_154533_, BlockPos p_154534_, BlockPos p_154535_) {
        BlockState blockstate = super.updateShape(p_154530_, p_154531_, p_154532_, p_154533_, p_154534_, p_154535_);
        p_154533_.scheduleTick(p_154534_, (Block)this, this.getDelayAfterPlace());
        FluidState fluidState = p_154533_.getFluidState(p_154534_);
        if (!blockstate.isAir() && fluidState.getType() == Fluids.WATER) {
            p_154533_.scheduleTick(p_154534_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_154533_));
        }
        return blockstate;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        FluidState fluidState = ctx.getLevel().getFluidState(ctx.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        if (Boolean.TRUE.equals(state.getValue((Property)WATERLOGGED))) {
            return Fluids.WATER.getSource(false);
        }
        return Fluids.EMPTY.defaultFluidState();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }

    public boolean canPlaceLiquid(BlockGetter p_154505_, BlockPos p_154506_, BlockState p_154507_, Fluid p_154508_) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor p_154520_, BlockPos p_154521_, BlockState p_154522_, FluidState p_154523_) {
        return false;
    }

    public float getShadeBrightness(BlockState p_48731_, BlockGetter p_48732_, BlockPos p_48733_) {
        return 1.0f;
    }

    public boolean isCollisionShapeFullBlock(BlockState p_181242_, BlockGetter p_181243_, BlockPos p_181244_) {
        return false;
    }

    public boolean propagatesSkylightDown(BlockState p_48740_, BlockGetter p_48741_, BlockPos p_48742_) {
        return true;
    }

    public boolean skipRendering(BlockState p_53972_, BlockState p_53973_, Direction p_53974_) {
        return true;
    }

    public boolean canBeReplaced(BlockState p_53035_, Fluid p_53036_) {
        return false;
    }

    @Override
    public <T extends Enum<T>> BlockState getStateForPlacement(T element, BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public void onPlace(BlockState p_53233_, Level p_53234_, BlockPos p_53235_, BlockState p_53236_, boolean p_53237_) {
        p_53234_.scheduleTick(p_53235_, (Block)this, this.getDelayAfterPlace());
    }

    public void tick(BlockState p_221124_, ServerLevel p_221125_, BlockPos p_221126_, RandomSource p_221127_) {
        if (BlockDeposits1.isFree(p_221125_.getBlockState(p_221126_.below())) && p_221126_.getY() >= p_221125_.getMinBuildHeight()) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)p_221125_, (BlockPos)p_221126_, (BlockState)p_221124_);
            this.falling(fallingblockentity);
        }
    }

    public void animateTick(BlockState p_221129_, Level p_221130_, BlockPos p_221131_, RandomSource p_221132_) {
        BlockPos blockpos;
        if (p_221132_.nextInt(16) == 0 && BlockDeposits1.isFree(p_221130_.getBlockState(blockpos = p_221131_.below()))) {
            double d0 = (double)p_221131_.getX() + p_221132_.nextDouble();
            double d1 = (double)p_221131_.getY() - 0.05;
            double d2 = (double)p_221131_.getZ() + p_221132_.nextDouble();
            p_221130_.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.FALLING_DUST, p_221129_), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void falling(FallingBlockEntity p_53206_) {
    }

    protected int getDelayAfterPlace() {
        return 2;
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        worldIn.scheduleTick(pos, (Block)this, 3);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Deposits;
    }

    public VoxelShape getCollisionShape(BlockState p_60572_, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return Deposits;
    }

    public VoxelShape getVisualShape(BlockState p_60479_, BlockGetter p_60480_, BlockPos p_60481_, CollisionContext p_60482_) {
        return Deposits;
    }

    public VoxelShape getInteractionShape(BlockState p_60547_, BlockGetter p_60548_, BlockPos p_60549_) {
        return super.getInteractionShape(p_60547_, p_60548_, p_60549_);
    }

    @Override
    public <T extends Enum<T>> void fillItemCategory(CreativeModeTab p40569, NonNullList<ItemStack> p40570, T element) {
        p40570.add((Object)new ItemStack((ItemLike)((BlockState)this.stateDefinition.any()).getBlock()));
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public Pair<String, Integer> getHarvestLevel() {
        return new Pair((Object)"pickaxe", (Object)0);
    }

    public static enum Type implements ISubEnum
    {
        deposits_iridium(0),
        deposits_germanium(1),
        deposits_vanadium(2),
        deposits_osmium(3),
        deposits_tantalum(4),
        deposits_cadmium(5),
        deposits_copper(6),
        deposits_tin(7),
        deposits_arsenopyrite(8),
        deposits_braggite(9),
        deposits_wolframite(10),
        deposits_xenotime(11),
        deposits_tetrahedrite(12),
        deposits_crocoite(13),
        deposits_zircon(14),
        deposits_celestine(15);

        private final int metadata;
        private final String name;

        private Type(int metadata) {
            this.metadata = metadata;
            this.name = this.name().toLowerCase(Locale.US);
        }

        public static Type getFromID(int ID) {
            return Type.values()[ID % Type.values().length];
        }

        public int getMetadata() {
            return this.metadata;
        }

        @Override
        public int getId() {
            return this.metadata;
        }

        @Override
        public String getOtherPart() {
            return "type=";
        }

        @Override
        @Nonnull
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "deposits1";
        }

        @Override
        public boolean canAddToTab() {
            return false;
        }

        public int getLight() {
            return 0;
        }
    }
}

