/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.transport.types;

import com.denfop.blockentity.transport.types.ICableItem;
import com.denfop.blocks.ISubEnum;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public enum HeatType implements ISubEnum,
ICableItem
{
    pipes(0, 0, 0.25f, 0.02, 1000.0),
    pipes1(0, 0, 0.25f, 0.02, 2000.0),
    pipes2(0, 0, 0.25f, 0.2, 4000.0),
    pipes3(0, 0, 0.25f, 0.2, 8000.0),
    pipes4(0, 0, 0.25f, 0.2, 16000.0);

    public static final HeatType[] values;
    private static final Map<String, HeatType> nameMap;
    public final int maxInsulation;
    public final int minColoredInsulation;
    public final float thickness;
    public final double loss;
    public final double capacity;
    private final ResourceLocation texture;

    private HeatType(int maxInsulation, int minColoredInsulation, float thickness, double loss, double capacity) {
        this.maxInsulation = maxInsulation;
        this.minColoredInsulation = minColoredInsulation;
        this.thickness = thickness;
        this.loss = loss;
        this.capacity = capacity;
        this.texture = ResourceLocation.tryBuild((String)"industrialupgrade", (String)("blocks/wiring/" + this.getMainPath() + "/" + this.getNameCable()));
    }

    public static HeatType get(String name) {
        return nameMap.get(name);
    }

    @Override
    public String getName() {
        return this.name() + "_pipes";
    }

    @Override
    public int getId() {
        return this.ordinal();
    }

    @Override
    public float getThickness() {
        return this.thickness;
    }

    @Override
    public String getNameCable() {
        return this.name() + "_pipes";
    }

    @Override
    public String getMainPath() {
        return "pipes";
    }

    @Override
    public ResourceLocation getRecourse() {
        return this.texture;
    }

    static {
        values = HeatType.values();
        nameMap = new HashMap<String, HeatType>();
        for (HeatType type : values) {
            nameMap.put(type.getName(), type);
        }
    }
}

