/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.transport.types;

import com.denfop.blockentity.transport.types.ICableItem;
import com.denfop.blocks.ISubEnum;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public enum BioType implements ISubEnum,
ICableItem
{
    bpipe(0, 0, 0.375f, 0.02, 2.147483647E9);

    public static final BioType[] values;
    private static final Map<String, BioType> nameMap;
    public final int maxInsulation;
    public final int minColoredInsulation;
    public final float thickness;
    public final double loss;
    public final double capacity;
    private final ResourceLocation texture;

    private BioType(int maxInsulation, int minColoredInsulation, float thickness, double loss, double capacity) {
        this.maxInsulation = maxInsulation;
        this.minColoredInsulation = minColoredInsulation;
        this.thickness = thickness;
        this.loss = loss;
        this.capacity = capacity;
        this.texture = ResourceLocation.tryBuild((String)"industrialupgrade", (String)("blocks/wiring/" + this.getMainPath() + "/" + this.getNameCable()));
    }

    public static BioType get(String name) {
        return nameMap.get(name);
    }

    @Override
    public String getName() {
        return this.name() + "_bpipe";
    }

    @Override
    public int getId() {
        return this.ordinal();
    }

    @Override
    public String getNameCable() {
        return this.name() + "_bpipe";
    }

    @Override
    public String getMainPath() {
        return "bpipe";
    }

    @Override
    public float getThickness() {
        return this.thickness;
    }

    @Override
    public ResourceLocation getRecourse() {
        return this.texture;
    }

    static {
        values = BioType.values();
        nameMap = new HashMap<String, BioType>();
        for (BioType type : values) {
            nameMap.put(type.getName(), type);
        }
    }
}

