/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.transport.tiles;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.api.otherenergies.transport.FluidHandler;
import com.denfop.api.otherenergies.transport.ITransportAcceptor;
import com.denfop.api.otherenergies.transport.ITransportConductor;
import com.denfop.api.otherenergies.transport.ITransportEmitter;
import com.denfop.api.otherenergies.transport.ITransportTile;
import com.denfop.api.otherenergies.transport.InfoCable;
import com.denfop.api.otherenergies.transport.TransportFluidItemSinkSource;
import com.denfop.api.otherenergies.transport.event.TransportTileLoadEvent;
import com.denfop.api.otherenergies.transport.event.TransportTileUnLoadEvent;
import com.denfop.blockentity.transport.tiles.BlockEntityMultiCable;
import com.denfop.blockentity.transport.types.ICableItem;
import com.denfop.blockentity.transport.types.ItemType;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuCable;
import com.denfop.containermenu.SlotInfo;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenCable1;
import com.denfop.screen.ScreenIndustrialUpgrade;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BlockEntityItemPipes
extends BlockEntityMultiCable
implements ITransportConductor {
    private final Redstone redstone;
    public SlotInfo list;
    public boolean addedToEnergyNet = false;
    public ItemType cableType;
    public boolean redstoneSignal = false;
    Map<Direction, ITransportTile> energyConductorMap = new HashMap<Direction, ITransportTile>();
    boolean hasHashCode = false;
    int hashCodeSource;
    List<InfoTile<ITransportTile>> validReceivers = new LinkedList<InfoTile<ITransportTile>>();
    InfoCable cable;
    List<FluidStack> blackList = new ArrayList<FluidStack>();
    List<FluidStack> whiteList = new ArrayList<FluidStack>();
    private SlotInfo listDown;
    private SlotInfo listUp;
    private SlotInfo listWest;
    private SlotInfo listEast;
    private SlotInfo listNorth;
    private SlotInfo listSouth;
    private boolean needUpdate;
    private long id;
    private boolean update;
    private boolean work = false;
    private Direction facingSide;
    private byte tick;
    private int max;
    private int hashCode;

    public BlockEntityItemPipes(ItemType cableType, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(cableType, block, pos, state);
        this.cableType = cableType;
        this.listDown = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listUp = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listWest = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listEast = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listNorth = new SlotInfo(this, 18, !this.cableType.isItem());
        this.listSouth = new SlotInfo(this, 18, !this.cableType.isItem());
        this.redstone = this.addComponent(new Redstone(this));
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                BlockEntityItemPipes.this.work = input != 0;
            }
        });
    }

    @Override
    public void addInformation(ItemStack stack, List<String> info) {
        ItemType type = this.cableType;
        info.add("Maximum: " + type.getMax() + (type.isItem() ? " item/t" : " mb/t"));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.redstoneSignal = customPacketBuffer.readBoolean();
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.redstoneSignal);
        return customPacketBuffer;
    }

    public boolean isWork() {
        return this.work;
    }

    @Override
    public ICableItem getCableItem() {
        return this.cableType;
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.cableType = ItemType.values[nbt.getByte("cableType") & 0xFF];
        this.redstoneSignal = nbt.getBoolean("redstoneSignal");
        if (!this.cableType.isOutput && !this.cableType.isInput()) {
            this.listDown = null;
            this.listUp = null;
            this.listWest = null;
            this.listEast = null;
            this.listNorth = null;
            this.listSouth = null;
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.putByte("cableType", (byte)this.cableType.ordinal());
        nbt.putBoolean("redstoneSignal", this.redstoneSignal);
        return nbt;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void RemoveTile(ITransportTile tile, Direction facing1) {
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<ITransportTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<ITransportTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
            this.update = true;
        }
    }

    @Override
    public int hashCode() {
        if (!this.hasHashCode) {
            this.hasHashCode = true;
            this.hashCode = super.hashCode();
            return this.hashCode;
        }
        return this.hashCode;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public Map<Direction, ITransportTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public List<InfoTile<ITransportTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void AddTile(ITransportTile tile, Direction facing1) {
        if (!this.getWorld().isClientSide && !this.energyConductorMap.containsKey(facing1) && (this.isOutput() || this.isInput() || !this.isOutput() && !this.isInput() && tile instanceof ITransportConductor)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<ITransportTile>(tile, facing1.getOpposite()));
            this.update = true;
        }
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        BlockEntity tile = this.getWorld().getBlockEntity(neighborPos);
        if (tile != null && !(tile instanceof ITransportConductor) && !tile.isRemoved()) {
            for (Direction enumFacing : Direction.values()) {
                if (tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, neighborPos, (Object)enumFacing) != null && tile.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, neighborPos, (Object)enumFacing) != null) {
                    TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(tile, neighborPos);
                    NeoForge.EVENT_BUS.post(new TransportTileLoadEvent(this.getWorld(), transport));
                    break;
                }
                if (tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, neighborPos, (Object)enumFacing) != null) {
                    TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(tile, neighborPos);
                    NeoForge.EVENT_BUS.post(new TransportTileLoadEvent(this.getWorld(), transport));
                    break;
                }
                if (tile.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, neighborPos, (Object)enumFacing) == null) continue;
                TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(tile, neighborPos);
                NeoForge.EVENT_BUS.post(new TransportTileLoadEvent(this.getWorld(), transport));
                break;
            }
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<?>> getGui(Player var1, ContainerMenuBase<?> var2) {
        if (var1.getItemInHand(InteractionHand.MAIN_HAND).getItem() == IUItem.connect_item.getItem()) {
            return super.getGui(var1, var2);
        }
        return new ScreenCable1(this.getGuiContainer(var1));
    }

    @Override
    public ContainerMenuCable getGuiContainer(Player var1) {
        return new ContainerMenuCable(var1, this, this.facingSide.getOpposite());
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide && !this.addedToEnergyNet) {
            if (this.cableType.isItem()) {
                NeoForge.EVENT_BUS.post(new TransportTileLoadEvent(this.getWorld(), this));
            } else {
                NeoForge.EVENT_BUS.post(new TransportTileLoadEvent(this.getWorld(), this));
            }
            this.addedToEnergyNet = true;
            this.updateConnectivity();
            block0: for (Direction facing1 : Direction.values()) {
                BlockPos neighborPos = this.pos.offset(facing1.getNormal());
                BlockEntity tile = this.getWorld().getBlockEntity(neighborPos);
                if (tile == null || tile instanceof ITransportConductor || tile.isRemoved()) continue;
                for (Direction enumFacing : Direction.values()) {
                    TransportFluidItemSinkSource transport;
                    if (tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, neighborPos, (Object)enumFacing) != null && tile.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, neighborPos, (Object)enumFacing) != null) {
                        transport = new TransportFluidItemSinkSource(tile, neighborPos);
                        NeoForge.EVENT_BUS.post(new TransportTileLoadEvent(this.getWorld(), transport));
                        continue block0;
                    }
                    if (tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, neighborPos, (Object)enumFacing) != null) {
                        transport = new TransportFluidItemSinkSource(tile, neighborPos);
                        NeoForge.EVENT_BUS.post(new TransportTileLoadEvent(this.getWorld(), transport));
                        continue block0;
                    }
                    if (tile.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, neighborPos, (Object)enumFacing) == null) continue;
                    transport = new TransportFluidItemSinkSource(tile, neighborPos);
                    NeoForge.EVENT_BUS.post(new TransportTileLoadEvent(this.getWorld(), transport));
                    continue block0;
                }
            }
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 < (double)Direction.values().length) {
            super.updateTileServer(var1, var2);
            if (this.cableType.isItem()) {
                NeoForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.getWorld(), this));
            } else {
                NeoForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.getWorld(), this));
            }
            this.needUpdate = true;
        } else if (var2 == 10.0) {
            this.redstoneSignal = !this.redstoneSignal;
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.needUpdate) {
            if (this.cableType.isItem()) {
                NeoForge.EVENT_BUS.post(new TransportTileLoadEvent(this.getWorld(), this));
            } else {
                NeoForge.EVENT_BUS.post(new TransportTileLoadEvent(this.getWorld(), this));
            }
            this.updateConnectivity();
            this.needUpdate = false;
        }
        if (this.update) {
            this.update = false;
            this.updateConnectivity();
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.getLevel().isClientSide && this.addedToEnergyNet) {
            if (this.cableType.isItem()) {
                NeoForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.getWorld(), this));
            } else {
                NeoForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.getWorld(), this));
            }
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        this.facingSide = side;
        return super.onActivated(player, hand, side, vec3);
    }

    public SlotInfo getInfoSlotFromFacing(Direction facing) {
        if (facing == null) {
            return this.listUp;
        }
        switch (facing) {
            case UP: {
                return this.listUp;
            }
            case DOWN: {
                return this.listDown;
            }
            case NORTH: {
                return this.listNorth;
            }
            case SOUTH: {
                return this.listSouth;
            }
            case WEST: {
                return this.listWest;
            }
            case EAST: {
                return this.listEast;
            }
        }
        return this.listUp;
    }

    @Override
    public void updateConnectivity() {
        Direction[] var4;
        byte newConnectivity = 0;
        for (Direction dir : var4 = Direction.values()) {
            newConnectivity = (byte)(newConnectivity << 1);
            ITransportTile tile = this.getTiles().get(dir);
            if (this.getBlackList().contains(dir) || (!(tile instanceof ITransportAcceptor) || !((ITransportAcceptor)tile).acceptsFrom(this, dir.getOpposite())) && (!(tile instanceof ITransportEmitter) || !((ITransportEmitter)tile).emitsTo(this, dir.getOpposite()))) continue;
            newConnectivity = (byte)(newConnectivity + 1);
        }
        this.setConnectivity(newConnectivity);
        this.cableItem = this.cableType;
    }

    @Override
    public boolean wrenchCanRemove(Player player) {
        return false;
    }

    @Override
    public boolean isOutput() {
        return this.cableType.isOutput;
    }

    @Override
    public boolean isInput() {
        return this.cableType.isInput();
    }

    @Override
    public InfoCable getCable() {
        return this.cable;
    }

    @Override
    public void setCable(InfoCable cable) {
        this.cable = cable;
    }

    @Override
    public boolean isItem() {
        return this.cableType.isItem();
    }

    @Override
    public List<ItemStack> getBlackListItems(Direction facing) {
        this.list = this.getInfoSlotFromFacing(facing.getOpposite());
        return this.list.getListBlack();
    }

    @Override
    public List<ItemStack> getWhiteListItems(Direction facing) {
        this.list = this.getInfoSlotFromFacing(facing.getOpposite());
        return this.list.getListWhite();
    }

    @Override
    public List<FluidStack> getBlackListFluids(Direction facing) {
        this.list = this.getInfoSlotFromFacing(facing);
        if (this.getWorld().getGameTime() % 20L == 0L) {
            this.blackList = this.list.getFluidStackList().subList(0, 9).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.blackList;
    }

    @Override
    public List<FluidStack> getWhiteListFluids(Direction facing) {
        this.list = this.getInfoSlotFromFacing(facing);
        if (this.getWorld().getGameTime() % 20L == 0L) {
            this.whiteList = this.list.getFluidStackList().subList(9, this.list.size()).stream().filter(Objects::nonNull).collect(Collectors.toList());
        }
        return this.whiteList;
    }

    @Override
    public boolean canWork() {
        return !this.redstoneSignal || this.work;
    }

    @Override
    public int getMax() {
        return this.cableType.getMax();
    }

    @Override
    public void setMax(int value) {
        this.max -= value;
    }

    @Override
    public int getMax(byte tick) {
        if (this.tick != tick) {
            this.tick = tick;
            this.max = this.getMax();
            return this.getMax();
        }
        return this.max;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cableType);
            EncoderHandler.encode(packet, this.connectivity);
            if (this.listUp != null) {
                EncoderHandler.encode(packet, this.listUp.isFluid());
                EncoderHandler.encode(packet, this.listDown.isFluid());
                EncoderHandler.encode(packet, this.listWest.isFluid());
                EncoderHandler.encode(packet, this.listEast.isFluid());
                EncoderHandler.encode(packet, this.listNorth.isFluid());
                EncoderHandler.encode(packet, this.listSouth.isFluid());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cableType = ItemType.values[(Integer)DecoderHandler.decode(customPacketBuffer)];
            if (!this.cableType.isOutput && !this.cableType.isInput()) {
                this.listDown = null;
                this.listUp = null;
                this.listWest = null;
                this.listEast = null;
                this.listNorth = null;
                this.listSouth = null;
            }
            this.connectivity = (Byte)DecoderHandler.decode(customPacketBuffer);
            if (this.listUp != null) {
                this.listUp.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
                this.listDown.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
                this.listWest.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
                this.listEast.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
                this.listNorth.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
                this.listSouth.setFluid((Boolean)DecoderHandler.decode(customPacketBuffer));
            }
            this.rerender();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean acceptsFrom(ITransportEmitter var1, Direction var2) {
        if (this.getBlackList().contains(var2)) {
            return false;
        }
        if (!this.cableType.isOutput && !this.cableType.isInput() && var1 instanceof ITransportConductor) {
            ITransportConductor conductor = (ITransportConductor)var1;
            return conductor.isItem() && this.isItem() || !conductor.isItem() && !this.isItem();
        }
        if (this.cableType.isItem()) {
            return var1.getHandler(var2.getOpposite()) instanceof IItemHandler;
        }
        return var1.getHandler(var2.getOpposite()) instanceof IFluidHandler;
    }

    @Override
    public boolean emitsTo(ITransportAcceptor var1, Direction var2) {
        if (this.getBlackList().contains(var2)) {
            return false;
        }
        if (!this.cableType.isOutput && !this.cableType.isInput()) {
            if (var1 instanceof ITransportConductor) {
                ITransportConductor conductor = (ITransportConductor)var1;
                return conductor.isItem() && this.isItem() || !conductor.isItem() && !this.isItem();
            }
            return false;
        }
        if (this.cableType.isItem()) {
            return var1.getHandler(var2.getOpposite()) instanceof IItemHandler;
        }
        return var1.getHandler(var2.getOpposite()) instanceof IFluidHandler;
    }

    @Override
    public Object getHandler(Direction facing) {
        if (this.cableType.isItem()) {
            return new ItemStackHandler();
        }
        return new FluidHandler();
    }
}

