/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.reactors.water.inputfluid;

import com.denfop.componets.Fluids;
import java.util.List;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;

public class FluidHandlerReactor
implements IFluidHandler {
    private final List<Fluids> list;
    private final FluidTank[] fluidTankProperties;

    public FluidHandlerReactor(List<Fluids> list) {
        this.list = list;
        this.fluidTankProperties = new FluidTank[this.list.size()];
        for (int i = 0; i < list.size(); ++i) {
            this.fluidTankProperties[i] = this.list.get(i).getAllTanks().iterator().next();
        }
    }

    public int getTanks() {
        return this.fluidTankProperties.length;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidTankProperties[tank].getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.fluidTankProperties[tank].getTankCapacity(0);
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return false;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        for (int i = 1; i < this.list.size(); ++i) {
            Fluids fluids = this.list.get(i);
            int f = fluids.getAllTanks().iterator().next().fill(resource, doFill);
            if (f == 0) continue;
            return f;
        }
        return !this.list.isEmpty() ? this.list.get(0).getAllTanks().iterator().next().fill(resource, doFill) : 0;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        for (int i = 1; i < this.list.size(); ++i) {
            Fluids fluids = this.list.get(i);
            FluidStack f = fluids.getAllTanks().iterator().next().drain(resource, doDrain);
            if (f == null) continue;
            return f;
        }
        return !this.list.isEmpty() ? this.list.get(0).getAllTanks().iterator().next().drain(resource, doDrain) : FluidStack.EMPTY;
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        for (int i = 1; i < this.list.size(); ++i) {
            Fluids fluids = this.list.get(i);
            FluidStack f = fluids.getAllTanks().iterator().next().drain(maxDrain, doDrain);
            if (f == null) continue;
            return f;
        }
        return !this.list.isEmpty() ? this.list.get(0).getAllTanks().iterator().next().drain(maxDrain, doDrain) : FluidStack.EMPTY;
    }
}

