/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.reactors.graphite.graphite_controller;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.reactors.IGraphiteReactor;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.reactors.graphite.IGraphiteController;
import com.denfop.blocks.ISubEnum;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuGraphiteController;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemCraftingElements;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenGraphiteGraphiteController;
import com.denfop.screen.ScreenIndustrialUpgrade;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityGraphiteController
extends BlockEntityMultiBlockElement
implements IGraphiteController,
IUpdatableTileEvent {
    public final Inventory slot;
    private final int levelBlock;
    public double fuel;
    public int levelGraphite = 1;
    private int index;

    public BlockEntityGraphiteController(int levelBlock, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(block, pos, state);
        this.levelBlock = levelBlock;
        this.slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                if (!(stack.getItem() instanceof ItemCraftingElements)) {
                    return false;
                }
                if (!((BlockEntityGraphiteController)BlockEntityGraphiteController.this).level.isClientSide) {
                    int itemDamage = ((ISubEnum)((ItemCraftingElements)stack.getItem()).getElement()).getId();
                    switch (itemDamage) {
                        case 357: {
                            return ((BlockEntityGraphiteController)this.base).getBlockLevel() >= 0;
                        }
                        case 410: {
                            return ((BlockEntityGraphiteController)this.base).getBlockLevel() >= 1;
                        }
                        case 310: {
                            return ((BlockEntityGraphiteController)this.base).getBlockLevel() >= 2;
                        }
                        case 368: {
                            return ((BlockEntityGraphiteController)this.base).getBlockLevel() >= 3;
                        }
                    }
                }
                return false;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (!((BlockEntityGraphiteController)BlockEntityGraphiteController.this).level.isClientSide && content.isEmpty()) {
                    ((BlockEntityGraphiteController)this.base).fuel = 0.0;
                }
                return content;
            }
        };
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int i) {
        this.index = i;
    }

    public double getFuel() {
        return this.fuel;
    }

    public Inventory getSlot() {
        return this.slot;
    }

    public ContainerMenuGraphiteController getGuiContainer(Player var1) {
        return new ContainerMenuGraphiteController(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenGraphiteGraphiteController((ContainerMenuGraphiteController)menu);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.index);
        customPacketBuffer.writeDouble(this.fuel);
        customPacketBuffer.writeInt(this.levelGraphite);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.index = customPacketBuffer.readInt();
        this.fuel = customPacketBuffer.readDouble();
        this.levelGraphite = customPacketBuffer.readInt();
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.fuel = nbtTagCompound.getDouble("fuel");
        this.levelGraphite = nbtTagCompound.getInt("levelGraphite");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.putDouble("fuel", this.fuel);
        nbtTagCompound.putInt("levelGraphite", this.levelGraphite);
        return nbtTagCompound;
    }

    @Override
    public int getBlockLevel() {
        return this.levelBlock;
    }

    @Override
    public ItemStack getGraphite() {
        return this.slot.get(0);
    }

    @Override
    public int getLevelGraphite() {
        return this.levelGraphite;
    }

    @Override
    public double getFuelGraphite() {
        return this.fuel;
    }

    @Override
    public void consumeFuelGraphite(double col) {
        this.fuel -= col;
    }

    @Override
    public void consumeGraphite() {
        if (!this.slot.get(0).isEmpty()) {
            int itemDamage = ((ISubEnum)((ItemCraftingElements)this.slot.get(0).getItem()).getElement()).getId();
            this.slot.get(0).shrink(1);
            switch (itemDamage) {
                case 357: {
                    this.fuel = 100.0;
                    break;
                }
                case 410: {
                    this.fuel = 500.0;
                    break;
                }
                case 310: {
                    this.fuel = 2500.0;
                    break;
                }
                case 368: {
                    this.fuel = 5000.0;
                }
            }
        } else {
            this.fuel = 0.0;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.levelGraphite = Math.max(1, this.levelGraphite);
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        this.levelGraphite = var2 == 0.0 ? Math.min(this.levelGraphite + 1, 5) : Math.max(1, this.levelGraphite - 1);
        if (this.getMain() != null) {
            IGraphiteReactor graphiteReactor = (IGraphiteReactor)this.getMain();
            graphiteReactor.updateDataReactor();
        }
    }
}

