/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.reactors.gas.cell;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blockentity.reactors.gas.ICell;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuGasTank;
import com.denfop.screen.ScreenGasMainTank;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BlockEntityMainTank
extends BlockEntityMultiBlockElement
implements ICell {
    public final Fluids fluids = this.addComponent(new Fluids(this));
    public final Fluids.InternalFluidTank tank;

    public BlockEntityMainTank(int col, MultiBlockEntity multiTileBlock, BlockPos pos, BlockState state) {
        super(multiTileBlock, pos, state);
        this.tank = this.fluids.addTank("fluidTank", col);
        this.tank.setCanAccept(false);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.tank.setCanAccept(this.getMain() != null && this.getMain().isFull());
    }

    @Override
    public boolean hasOwnInventory() {
        return true;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().isClientSide && FluidHandlerFix.getFluidHandler(player.getItemInHand(hand)) != null && this.getMain() != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(Capabilities.FluidHandler.BLOCK, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenGasMainTank((ContainerMenuGasTank)menu);
    }

    public ContainerMenuGasTank getGuiContainer(Player var1) {
        return new ContainerMenuGasTank(this, var1);
    }

    @Override
    public Fluids getFluids() {
        return this.fluids;
    }

    @Override
    public Fluids.InternalFluidTank getTank() {
        return this.tank;
    }

    @Override
    public void setFluid(Fluid fluid) {
        this.tank.setAcceptedFluids(Fluids.fluidPredicate(fluid));
    }
}

