/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.quarry_earth;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockBase;
import com.denfop.blockentity.quarry_earth.DataPos;
import com.denfop.blockentity.quarry_earth.IAnalyzer;
import com.denfop.blockentity.quarry_earth.IEarthChest;
import com.denfop.blockentity.quarry_earth.IEarthQuarry;
import com.denfop.blockentity.quarry_earth.IRigDrill;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockEarthQuarryEntity;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuEarthController;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.screen.ScreenEarthController;
import com.denfop.screen.ScreenIndustrialUpgrade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityEarthQuarryController
extends BlockEntityMultiBlockBase
implements IEarthQuarry,
IUpdatableTileEvent {
    public static List<ChunkPos> chunkPos = new LinkedList<ChunkPos>();
    public static Random random = new Random();
    public final Energy energy;
    public List<IEarthChest> earthChestList = new ArrayList<IEarthChest>();
    public IAnalyzer analyzer;
    public boolean work;
    public int indexChunk = 0;
    public Map<ChunkPos, List<DataPos>> map = new HashMap<ChunkPos, List<DataPos>>();
    public List<ChunkPos> chunkPosList = new LinkedList<ChunkPos>();
    public int max = 0;
    public int block_Col;
    List<DataPos> notAddedPos = new ArrayList<DataPos>();
    private List<DataPos> dataPos = new LinkedList<DataPos>();
    private IRigDrill quarry;

    public BlockEntityEarthQuarryController(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.EarthQuarryMultiBlock, BlockEarthQuarryEntity.earth_controller, pos, state);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 100000.0, 14));
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.work = nbttagcompound.getBoolean("work");
        this.indexChunk = nbttagcompound.getInt("indexChunk");
        this.max = nbttagcompound.getInt("max");
        this.block_Col = nbttagcompound.getInt("block_Col");
        this.dataPos = new LinkedList<DataPos>();
        ListTag dataPosList = nbttagcompound.getList("DataPosList", 10);
        for (Object t : dataPosList) {
            CompoundTag dpTag = (CompoundTag)t;
            this.dataPos.add(DataPos.load(dpTag));
        }
        ListTag nodAddedDataPosList = nbttagcompound.getList("nodAddedDataPosList", 10);
        for (Object t : nodAddedDataPosList) {
            CompoundTag dpTag = (CompoundTag)t;
            this.notAddedPos.add(DataPos.load(dpTag));
        }
        this.chunkPosList = new ArrayList<ChunkPos>();
        ListTag chunkList = nbttagcompound.getList("ChunkPosList", 10);
        for (Tag t : chunkList) {
            CompoundTag cpTag = (CompoundTag)t;
            int x = cpTag.getInt("x");
            int z = cpTag.getInt("z");
            this.chunkPosList.add(new ChunkPos(x, z));
        }
        this.map = new HashMap<ChunkPos, List<DataPos>>();
        ListTag mapList = nbttagcompound.getList("ChunkDataMap", 10);
        for (Tag t : mapList) {
            CompoundTag entryTag = (CompoundTag)t;
            int x = entryTag.getInt("x");
            int z = entryTag.getInt("z");
            ChunkPos chunkPos = new ChunkPos(x, z);
            ListTag dpList = entryTag.getList("data", 10);
            ArrayList<DataPos> list = new ArrayList<DataPos>();
            for (Tag dpTag : dpList) {
                list.add(DataPos.load((CompoundTag)dpTag));
            }
            this.map.put(chunkPos, list);
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        nbttagcompound.putBoolean("work", this.work);
        nbttagcompound.putInt("indexChunk", this.indexChunk);
        nbttagcompound.putInt("max", this.max);
        nbttagcompound.putInt("block_Col", this.block_Col);
        ListTag dataPosList = new ListTag();
        for (DataPos dataPos : this.dataPos) {
            dataPosList.add((Object)dataPos.save());
        }
        nbttagcompound.put("DataPosList", (Tag)dataPosList);
        ListTag nodAddedDataPosList = new ListTag();
        for (DataPos dataPos : this.notAddedPos) {
            nodAddedDataPosList.add((Object)dataPos.save());
        }
        nbttagcompound.put("nodAddedDataPosList", (Tag)nodAddedDataPosList);
        ListTag listTag = new ListTag();
        for (ChunkPos cp : this.chunkPosList) {
            CompoundTag cpTag = new CompoundTag();
            cpTag.putInt("x", cp.x);
            cpTag.putInt("z", cp.z);
            listTag.add((Object)cpTag);
        }
        nbttagcompound.put("ChunkPosList", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (Map.Entry<ChunkPos, List<DataPos>> entry : this.map.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.putInt("x", entry.getKey().x);
            entryTag.putInt("z", entry.getKey().z);
            ListTag dpList = new ListTag();
            for (DataPos dp : entry.getValue()) {
                dpList.add((Object)dp.save());
            }
            entryTag.put("data", (Tag)dpList);
            listTag2.add((Object)entryTag);
        }
        nbttagcompound.put("ChunkDataMap", (Tag)listTag2);
        return super.writeToNBT(nbttagcompound);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.earthQuarry.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockEarthQuarryEntity.earth_controller;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.max);
        customPacketBuffer.writeInt(this.indexChunk);
        customPacketBuffer.writeInt(this.block_Col);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.max = customPacketBuffer.readInt();
        this.indexChunk = customPacketBuffer.readInt();
        this.block_Col = customPacketBuffer.readInt();
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == 0.0 && !this.analyzer.getChunkPoses().isEmpty()) {
            this.work = !this.work;
            this.indexChunk = 0;
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work && this.full && this.getWorld().getGameTime() % 10L == 0L) {
            if (this.analyzer.fullAnalyzed() && !this.chunkPosList.isEmpty()) {
                List dataPos = this.map.getOrDefault(this.chunkPosList.get(this.indexChunk), Collections.emptyList());
                this.max = this.chunkPosList.size();
                for (DataPos dataPos1 : dataPos) {
                    if (this.energy.getEnergy() < 50.0) {
                        this.notAddedPos.add(dataPos1);
                        continue;
                    }
                    this.energy.useEnergy(50.0);
                    if (dataPos1.state.getBlock() == Blocks.DIRT) {
                        if (random.nextInt(100) < 90) continue;
                        this.level.setBlock(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(1), 3);
                        this.dataPos.add(dataPos1);
                        continue;
                    }
                    if (dataPos1.state.getBlock() == Blocks.GRAVEL) {
                        if (random.nextInt(100) < 94) continue;
                        this.level.setBlock(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(2), 3);
                        this.dataPos.add(dataPos1);
                        continue;
                    }
                    if (dataPos1.state.getBlock() != Blocks.SAND || random.nextInt(100) < 80) continue;
                    this.level.setBlock(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(0), 3);
                    this.dataPos.add(dataPos1);
                }
                this.block_Col = this.dataPos.size();
                chunkPos.add(this.chunkPosList.get(this.indexChunk));
                ++this.indexChunk;
                if (this.indexChunk == this.chunkPosList.size()) {
                    this.quarry.startOperation(this.dataPos);
                    this.chunkPosList.clear();
                    this.work = false;
                }
            } else if (!this.notAddedPos.isEmpty()) {
                Iterator<DataPos> iter = this.notAddedPos.iterator();
                while (iter.hasNext()) {
                    DataPos dataPos1 = iter.next();
                    if (this.energy.getEnergy() < 50.0) continue;
                    this.energy.useEnergy(50.0);
                    if (dataPos1.state.getBlock() == Blocks.DIRT) {
                        if (random.nextInt(100) >= 90) {
                            this.level.setBlock(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(1), 3);
                            this.dataPos.add(dataPos1);
                        }
                    } else if (dataPos1.state.getBlock() == Blocks.GRAVEL) {
                        if (random.nextInt(100) >= 94) {
                            this.level.setBlock(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(2), 3);
                            this.dataPos.add(dataPos1);
                        }
                    } else if (dataPos1.state.getBlock() == Blocks.SAND && random.nextInt(100) >= 80) {
                        this.level.setBlock(dataPos1.getPos(), IUItem.ore2.getStateFromMeta(0), 3);
                        this.dataPos.add(dataPos1);
                    }
                    iter.remove();
                }
                this.block_Col = this.dataPos.size();
                this.work = false;
                this.indexChunk = this.max;
            } else {
                this.work = false;
                this.indexChunk = this.max;
            }
        }
    }

    public ContainerMenuEarthController getGuiContainer(Player entityPlayer) {
        return new ContainerMenuEarthController(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenEarthController((ContainerMenuEarthController)menu);
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.earthChestList.clear();
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IAnalyzer.class);
        this.analyzer = (IAnalyzer)this.getWorld().getBlockEntity(pos1.get(0));
        List<BlockPos> pos2 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IEarthChest.class);
        for (BlockPos pos3 : pos2) {
            this.earthChestList.add((IEarthChest)this.getWorld().getBlockEntity(pos3));
        }
        this.map = this.analyzer.getChunkPoses();
        this.chunkPosList = new ArrayList<ChunkPos>(this.map.keySet());
        List<BlockPos> pos3 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IRigDrill.class);
        this.quarry = (IRigDrill)this.getWorld().getBlockEntity(pos3.get(0));
    }

    @Override
    public void usingBeforeGUI() {
    }

    public Energy getEnergy() {
        return this.energy;
    }
}

