/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSteamTank;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSteamTank;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BlockEntitySteamStorage
extends BlockEntityInventory {
    public final Fluids fluids;
    protected final ComponentSteamEnergy steam = this.addComponent(new ComponentSteamEnergy(EnergyType.STEAM, (BlockEntityInventory)this, 64000.0, Arrays.stream(Direction.values()).filter(f -> f != this.getFacing()).collect(Collectors.toList()), Collections.singletonList(this.getFacing()), EnergyNetGlobal.instance.getTierFromPower(14.0), EnergyNetGlobal.instance.getTierFromPower(14.0), false));
    public FluidTank fluidTank;
    public int prev = -10;
    public int amount;

    public BlockEntitySteamStorage(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.steam_storage, pos, state);
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("fluidTank", 64000, Inventory.TypeItemSlot.NONE, Fluids.fluidPredicate((Fluid)FluidName.fluidsteam.getInstance().get()));
        this.steam.setFluidTank(this.fluidTank);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(BlockBaseMachine3Entity.steam_storage);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.steam_storage;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.fluidTank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.steam_storage.info"));
        if (stack.has(DataComponentsInit.DATA) && ((CompoundTag)stack.get(DataComponentsInit.DATA)).contains("fluid")) {
            FluidStack fluidStack = FluidStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)((CompoundTag)((CompoundTag)stack.get(DataComponentsInit.DATA)).get("fluid")));
            tooltip.add(Localization.translate("iu.fluid.info") + fluidStack.getHoverName().getString());
            tooltip.add(Localization.translate("iu.fluid.info1") + fluidStack.getAmount() / 1000 + " B");
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        if (stack.has(DataComponentsInit.DATA) && ((CompoundTag)stack.get(DataComponentsInit.DATA)).contains("fluid")) {
            FluidStack fluidStack = FluidStack.parseOptional((HolderLookup.Provider)placer.registryAccess(), (CompoundTag)((CompoundTag)((CompoundTag)stack.get(DataComponentsInit.DATA)).get("fluid")));
            if (fluidStack != null) {
                this.fluidTank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
        }
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> itemStackList = super.getWrenchDrops(player, fortune);
        if (this.fluidTank.getFluidAmount() > 0) {
            CompoundTag nbt = ModUtils.nbt(itemStackList.get(0));
            nbt.put("fluid", this.fluidTank.getFluid().save((HolderLookup.Provider)player.registryAccess(), (Tag)new CompoundTag()));
        }
        return itemStackList;
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if ((drop = super.adjustDrop(drop, wrench)).is(this.getPickBlock(null, null).getItem()) && (wrench || this.teBlock.getDefaultDrop() == DefaultDrop.Self) && this.fluidTank.getFluidAmount() > 0) {
            CompoundTag nbt = ModUtils.nbt(drop);
            nbt.put("fluid", this.fluidTank.getFluid().save((HolderLookup.Provider)this.level.registryAccess(), (Tag)new CompoundTag()));
        }
        return drop;
    }

    public double gaugeLiquidScaled(double i) {
        return this.getFluidTank().getFluidAmount() <= 0 ? 0.0 : (double)this.getFluidTank().getFluidAmount() * i / (double)this.getFluidTank().getCapacity();
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.fluidTank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.amount != this.fluidTank.getFluidAmount()) {
            this.amount = this.fluidTank.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidTank", this.fluidTank);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("fluidTank")) {
            try {
                this.fluidTank.setFluid(((FluidTank)DecoderHandler.decode(is)).getFluid());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    public boolean canFill() {
        return true;
    }

    public boolean canDrain() {
        return true;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ContainerMenuSteamTank getGuiContainer(Player entityPlayer) {
        return new ContainerMenuSteamTank(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSteamTank((ContainerMenuSteamTank)menu);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide) {
            this.setUpgradestat();
            this.steam.setDirections(new HashSet<Direction>(Arrays.stream(Direction.values()).filter(facing1 -> facing1 != this.getFacing()).collect(Collectors.toList())), new HashSet<Direction>(Collections.singletonList(this.getFacing())));
        }
    }

    public void setUpgradestat() {
    }

    @Override
    public void setChanged() {
        super.setChanged();
        if (!this.level.isClientSide) {
            this.setUpgradestat();
        }
    }
}

