/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.Fluids;
import com.denfop.componets.PressureComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSteamPressureConverter;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSteamPressureConverter;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BlockEntitySteamPressureConverter
extends BlockEntityElectricMachine
implements IUpdatableTileEvent {
    public final PressureComponent pressure;
    public FluidTank fluidTank;
    public Fluids fluids = this.addComponent(new Fluids(this));
    public boolean work = true;
    public short maxpressure = 0;

    public BlockEntitySteamPressureConverter(BlockPos pos, BlockState state) {
        super(0.0, 0, 1, BlockBaseMachine3Entity.steampressureconverter, pos, state);
        this.fluidTank = this.fluids.addTank("fluidTank", 4000, Inventory.TypeItemSlot.INPUT, Fluids.fluidPredicate((Fluid)FluidName.fluidsuperheated_steam.getInstance().get()));
        this.pressure = this.addComponent(PressureComponent.asBasicSource(this, 4.0));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.steam_info"));
        tooltip.add(Localization.translate("iu.steam_info1"));
        tooltip.add(Localization.translate("iu.steam_pressure_converter.info"));
        tooltip.add(Localization.translate("iu.pressure_steam.info"));
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().isClientSide && FluidHandlerFix.hasFluidHandler(player.getItemInHand(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(Capabilities.FluidHandler.BLOCK, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        FluidState blockState = this.level.getFluidState(this.pos.below());
        this.work = !blockState.isEmpty() ? blockState.getType().isSame(Fluids.LAVA) : false;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank.readFromNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), fluidTank1.writeToNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            }
            this.maxpressure = (Short)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.steampressureconverter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
            EncoderHandler.encode(packet, this.maxpressure);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            FluidState blockState = this.level.getFluidState(this.pos.below());
            this.work = blockState.getType() != net.minecraft.world.level.material.Fluids.EMPTY ? blockState.getType().isSame(Fluids.LAVA) : false;
        }
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (i == 0.0) {
            this.maxpressure = (short)(this.maxpressure + 1);
            if (this.maxpressure > 4) {
                this.maxpressure = (short)4;
            }
            this.pressure.setCapacity(this.maxpressure);
        }
        if (i == 1.0) {
            this.maxpressure = (short)(this.maxpressure - 1);
            if (this.maxpressure < 0) {
                this.maxpressure = 0;
            }
            this.pressure.setCapacity(this.maxpressure);
        }
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.maxpressure = nbttagcompound.getShort("maxpressure");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putShort("maxpressure", this.maxpressure);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.pressure.buffer.storage > (double)this.maxpressure) {
            this.pressure.buffer.storage = this.maxpressure;
        }
        if (this.work) {
            if (this.getWorld().getGameTime() % 40L == 0L && this.maxpressure > 0) {
                if (!this.fluidTank.getFluid().isEmpty() && this.fluidTank.getFluid().getAmount() >= this.maxpressure && this.pressure.getEnergy() + 1.0 <= this.pressure.getCapacity()) {
                    this.pressure.addEnergy(1.0);
                    if (this.pressure.buffer.storage > (double)this.maxpressure) {
                        this.pressure.buffer.storage = this.maxpressure;
                    }
                    this.fluidTank.drain((int)this.maxpressure, IFluidHandler.FluidAction.EXECUTE);
                    this.setActive(true);
                } else {
                    this.setActive(false);
                }
            }
        } else {
            this.setActive(false);
        }
        if (this.getWorld().getGameTime() % 400L == 0L) {
            if (!this.fluidTank.getFluid().isEmpty() && this.fluidTank.getFluid().getAmount() >= this.maxpressure) {
                this.fluidTank.drain((int)this.maxpressure, IFluidHandler.FluidAction.EXECUTE);
            } else {
                this.pressure.useEnergy(1.0);
            }
        }
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ContainerMenuSteamPressureConverter getGuiContainer(Player entityPlayer) {
        return new ContainerMenuSteamPressureConverter(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSteamPressureConverter((ContainerMenuSteamPressureConverter)menu);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

