/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.steam;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.ComponentSteamEnergy;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSteamBoiler;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSteamBoiler;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BlockEntitySteamBoiler
extends BlockEntityElectricMachine
implements IUpdatableTileEvent {
    public final Fluids.InternalFluidTank fluidTank1;
    private final ComponentSteamEnergy steam;
    public FluidTank fluidTank;
    public Fluids fluids = this.addComponent(new Fluids(this));
    public boolean work = true;

    public BlockEntitySteamBoiler(BlockPos pos, BlockState state) {
        super(0.0, 0, 1, BlockBaseMachine3Entity.steamboiler, pos, state);
        this.fluidTank = this.fluids.addTank("fluidTank", 4000, Inventory.TypeItemSlot.INPUT, Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.WATER}));
        this.fluidTank1 = this.fluids.addTank("fluidTank1", 4000, Inventory.TypeItemSlot.NONE, Fluids.fluidPredicate((Fluid)FluidName.fluidsteam.getInstance().get()));
        this.steam = this.addComponent(ComponentSteamEnergy.asBasicSource(this, 4000.0));
        this.steam.setFluidTank(this.fluidTank1);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.steam_info"));
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.getWorld().isClientSide && FluidHandlerFix.hasFluidHandler(player.getItemInHand(hand))) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.fluids.getCapability(Capabilities.FluidHandler.BLOCK, side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void onNeighborChange(BlockState neighbor, BlockPos neighborPos) {
        super.onNeighborChange(neighbor, neighborPos);
        FluidState blockState = this.level.getFluidState(this.pos.below());
        this.work = !blockState.isEmpty() ? blockState.getType().isSame(Fluids.LAVA) : false;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            FluidTank fluidTank2;
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank.readFromNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), fluidTank1.writeToNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            }
            if ((fluidTank2 = (FluidTank)DecoderHandler.decode(customPacketBuffer)) != null) {
                this.fluidTank1.readFromNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), fluidTank2.writeToNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.steamboiler;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.fluidTank);
            EncoderHandler.encode(packet, (Object)this.fluidTank1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            FluidState blockState = this.level.getFluidState(this.pos.below());
            this.work = blockState.getType() != net.minecraft.world.level.material.Fluids.EMPTY ? blockState.getType().isSame(Fluids.LAVA) : false;
        }
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        return nbttagcompound;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work) {
            for (int i = 0; i < ComponentSteamEnergy.speedGeneration; ++i) {
                if (this.getWorld().getGameTime() % 1L != 0L) continue;
                if (!this.fluidTank.getFluid().isEmpty() && this.fluidTank.getFluid().getAmount() >= 1 && this.steam.getEnergy() + 1.0 <= this.steam.getCapacity()) {
                    this.steam.addEnergy(1.0);
                    this.fluidTank.drain(1, IFluidHandler.FluidAction.EXECUTE);
                    this.setActive(true);
                    continue;
                }
                this.setActive(false);
            }
        } else {
            this.setActive(false);
        }
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public ContainerMenuSteamBoiler getGuiContainer(Player entityPlayer) {
        return new ContainerMenuSteamBoiler(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSteamBoiler((ContainerMenuSteamBoiler)menu);
    }

    @Override
    public SoundEvent getSound() {
        return null;
    }
}

