/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.multimechanism.triple;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.base.BlockEntityMultiMachine;
import com.denfop.blockentity.base.EnumMultiMachine;
import com.denfop.blockentity.mechanism.multimechanism.IFarmer;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockMoreMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.Localization;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityTripleFermer
extends BlockEntityMultiMachine
implements IFarmer {
    private final Inventory fertilizerSlot = new Inventory(this, this, Inventory.TypeItemSlot.INPUT, 1){

        @Override
        public boolean canPlaceItem(int index, ItemStack stack) {
            return stack.getItem() == IUItem.fertilizer.getItem();
        }

        @Override
        public EnumTypeSlot getTypeSlot() {
            return EnumTypeSlot.FERTILIZER;
        }
    };
    private final SoilPollutionComponent pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
    private final AirPollutionComponent pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.075));
    int col = 0;

    public BlockEntityTripleFermer(BlockPos pos, BlockState state) {
        super(EnumMultiMachine.TRIPLE_Fermer.usagePerTick, EnumMultiMachine.TRIPLE_Fermer.lenghtOperation, BlockMoreMachine3Entity.triple_farmer, pos, state);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.col = customPacketBuffer.readInt();
    }

    @Override
    public int getFertilizer() {
        return this.col;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packetBuffer = super.writeContainerPacket();
        packetBuffer.writeInt(this.col);
        return packetBuffer;
    }

    @Override
    public Inventory getFertilizerSlot() {
        return this.fertilizerSlot;
    }

    @Override
    public int getSize(int size) {
        size = Math.min(super.getSize(size), this.fertilizerSlot.get(0).getCount() * 8 + this.col);
        return size;
    }

    @Override
    public boolean canoperate(int size) {
        return !this.fertilizerSlot.isEmpty() && this.fertilizerSlot.get(0).getCount() * 8 + this.col >= size;
    }

    @Override
    public void consume(int size) {
        int size1 = size;
        while (size1 > 0) {
            if (this.col == 0) {
                this.col += 16;
                this.fertilizerSlot.get(0).shrink(1);
            }
            if (size1 <= this.col) {
                this.col -= size1;
                size1 = 0;
                continue;
            }
            size1 -= this.col;
            this.col = 0;
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockMoreMachine3Entity.triple_farmer;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.machines_base3.getBlock(this.getTeBlock().getId());
    }

    @Override
    public EnumMultiMachine getMachine() {
        return EnumMultiMachine.TRIPLE_Fermer;
    }

    public String getInventoryName() {
        return Localization.translate("iu.blockFermer2.name");
    }

    public String getStartSoundFile() {
        return "Machines/Fermer.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }
}

