/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.multiblocks.base;

import com.denfop.IUCore;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.api.multiblock.MultiBlockStructure;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.mixin.access.LevelRendererAccessor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.utils.Localization;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

public abstract class BlockEntityMultiBlockBase
extends BlockEntityInventory
implements IMainMultiBlock,
IUpdatableTileEvent {
    public boolean full;
    public boolean activate;
    public List<Player> entityPlayerList;
    private MultiBlockStructure multiBlockStructure;
    @OnlyIn(value=Dist.CLIENT)
    private Function render;
    private boolean visible = true;

    public BlockEntityMultiBlockBase(MultiBlockStructure multiBlockStructure, MultiBlockEntity multiTileBlock, BlockPos pos, BlockState state) {
        super(multiTileBlock, pos, state);
        this.multiBlockStructure = multiBlockStructure;
        this.full = false;
        this.entityPlayerList = new ArrayList<Player>();
        this.activate = false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Function<RenderLevelStageEvent, Void> createFunction(BlockEntityMultiBlockBase te) {
        Function<RenderLevelStageEvent, Void> function = o -> {
            PoseStack poseStack = o.getPoseStack();
            poseStack.pushPose();
            poseStack.translate((float)te.getBlockPos().getX() + 0.5f, (float)te.getBlockPos().getY(), (float)te.getBlockPos().getZ() + 0.5f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            te.render(te, (RenderLevelStageEvent)o);
            poseStack.popPose();
            return null;
        };
        return function;
    }

    @Override
    public boolean onSneakingActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.level.isClientSide) {
            return true;
        }
        this.getCooldownTracker().setTick(20);
        this.visible = !this.visible;
        new PacketUpdateFieldTile(this, "visible", this.visible);
        return super.onSneakingActivated(player, hand, side, vec3);
    }

    @Override
    public int getBlockLevel() {
        return 0;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        if (!this.isFull()) {
            this.updateFull();
            this.full = true;
            this.activate = true;
        }
    }

    @Override
    public boolean isMain() {
        return true;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        block7: {
            super.addInformation(stack, tooltip);
            tooltip.add(Localization.translate("iu.multiblock.info_visible_structure"));
            if (this.level != null) break block7;
            tooltip.add(Localization.translate("multiblock.jei1"));
            if (this.getMultiBlockStucture() != null) {
                for (ItemStack stack1 : this.getMultiBlockStucture().itemStackList) {
                    if (stack1.isEmpty()) continue;
                    tooltip.add(String.valueOf(ChatFormatting.GREEN) + stack1.getCount() + "x" + String.valueOf(ChatFormatting.GRAY) + stack1.getDisplayName().getString());
                }
            } else {
                try {
                    this.multiBlockStructure = ((BlockEntityMultiBlockBase)this.getTeBlock().getTeClass().getConstructors()[0].newInstance((Object[])new Object[]{BlockPos.ZERO, this.getBlockState()})).multiBlockStructure;
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private Direction rotateFacing(Direction original, Direction baseRotation) {
        if (original == Direction.UP || original == Direction.DOWN) {
            return original;
        }
        switch (baseRotation) {
            case EAST: {
                return this.rotate90(original);
            }
            case WEST: {
                return this.rotate90(this.rotate90(this.rotate90(original)));
            }
            case SOUTH: {
                return this.rotate90(this.rotate90(original));
            }
        }
        return original;
    }

    private Direction rotate90(Direction facing) {
        switch (facing) {
            case NORTH: {
                return Direction.EAST;
            }
            case EAST: {
                return Direction.SOUTH;
            }
            case SOUTH: {
                return Direction.WEST;
            }
            case WEST: {
                return Direction.NORTH;
            }
        }
        return facing;
    }

    public MultiBlockStructure getMultiBlockStructure() {
        return this.multiBlockStructure;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.full);
            EncoderHandler.encode(packet, this.activate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public boolean onRemovedByPlayer(Player player, boolean willHarvest) {
        return true;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.full = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.activate = (Boolean)DecoderHandler.decode(customPacketBuffer);
            if (this.full && this.activate) {
                this.updateFull();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void updateAfterAssembly();

    public abstract void usingBeforeGUI();

    @OnlyIn(value=Dist.CLIENT)
    public void render(BlockEntityMultiBlockBase tileEntityMultiBlockBase, RenderLevelStageEvent event) {
        if (!this.isFull()) {
            this.renderBlock(tileEntityMultiBlockBase, event);
        } else if (this.getMultiBlockStucture().hasUniqueModels) {
            this.renderUniqueMultiBlock(event);
        }
    }

    private void rotateBlocks() {
        for (Map.Entry<BlockPos, Direction> entry : this.multiBlockStructure.RotationMap.entrySet()) {
            BlockEntityMultiBlockElement multiBlockElement;
            Direction rotation = entry.getValue();
            BlockPos pos1 = switch (this.getFacing()) {
                case Direction.NORTH -> entry.getKey();
                case Direction.EAST -> new BlockPos(-entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX());
                case Direction.WEST -> new BlockPos(entry.getKey().getZ(), entry.getKey().getY(), -entry.getKey().getX());
                case Direction.SOUTH -> new BlockPos(-entry.getKey().getX(), entry.getKey().getY(), -entry.getKey().getZ());
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(this.getFacing()));
            };
            Direction facing = this.getFacing();
            if ((pos1 = this.pos.offset((Vec3i)pos1)).equals((Object)this.pos)) continue;
            if (facing == Direction.NORTH) {
                if (rotation == Direction.EAST || rotation == Direction.WEST) {
                    rotation = rotation.getOpposite();
                }
            } else if (facing == Direction.SOUTH) {
                if (rotation == Direction.SOUTH || rotation == Direction.NORTH) {
                    rotation = rotation.getOpposite();
                }
            } else if (facing == Direction.EAST) {
                rotation = rotation == Direction.EAST || rotation == Direction.WEST ? (rotation == Direction.EAST ? Direction.NORTH : Direction.SOUTH) : (rotation == Direction.SOUTH ? Direction.WEST : Direction.EAST);
            } else if (facing == Direction.WEST) {
                rotation = rotation == Direction.EAST || rotation == Direction.WEST ? (rotation == Direction.WEST ? Direction.NORTH : Direction.SOUTH) : (rotation == Direction.SOUTH ? Direction.EAST : Direction.WEST);
            }
            if ((multiBlockElement = (BlockEntityMultiBlockElement)this.getWorld().getBlockEntity(pos1)) == null) continue;
            multiBlockElement.setFacing(rotation);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderBlock(BlockEntityMultiBlockBase tile, RenderLevelStageEvent event) {
        if (this.facing == 0 || this.facing == 1 || !this.visible) {
            return;
        }
        for (Map.Entry<BlockPos, ItemStack> entry : this.multiBlockStructure.ItemStackMap.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            Direction rotation = this.multiBlockStructure.RotationMap.get(entry.getKey());
            BlockPos pos1 = switch (this.getFacing()) {
                case Direction.NORTH -> new BlockPos(entry.getKey().getX(), entry.getKey().getY(), entry.getKey().getZ());
                case Direction.EAST -> new BlockPos(entry.getKey().getZ() * -1, entry.getKey().getY(), entry.getKey().getX());
                case Direction.WEST -> new BlockPos(entry.getKey().getZ(), entry.getKey().getY(), entry.getKey().getX() * -1);
                case Direction.SOUTH -> new BlockPos(entry.getKey().getX() * -1, entry.getKey().getY(), entry.getKey().getZ() * -1);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(this.getFacing()));
            };
            ItemStack item = entry.getValue();
            if (item.isEmpty()) continue;
            PoseStack poseStack = event.getPoseStack();
            poseStack.pushPose();
            poseStack.translate((double)pos1.getX(), 0.25 + (double)pos1.getY(), (double)pos1.getZ());
            if (rotation != null) {
                block6 : switch (this.getFacing()) {
                    case NORTH: {
                        switch (rotation) {
                            case SOUTH: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                                break;
                            }
                            case NORTH: {
                                break;
                            }
                            case WEST: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                                break;
                            }
                            case EAST: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                            }
                        }
                        break;
                    }
                    case SOUTH: {
                        switch (rotation) {
                            case SOUTH: {
                                break;
                            }
                            case NORTH: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                                break;
                            }
                            case WEST: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                                break;
                            }
                            case EAST: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                            }
                        }
                        break;
                    }
                    case WEST: {
                        switch (rotation) {
                            case SOUTH: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                                break;
                            }
                            case NORTH: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                                break;
                            }
                            case WEST: {
                                break;
                            }
                            case EAST: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                            }
                        }
                        break;
                    }
                    case EAST: {
                        switch (rotation) {
                            case SOUTH: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                                break block6;
                            }
                            case NORTH: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                                break block6;
                            }
                            case WEST: {
                                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                                break block6;
                            }
                        }
                    }
                }
            }
            poseStack.scale(1.0f, 1.0f, 1.0f);
            ItemRenderer renderItem = Minecraft.getInstance().getItemRenderer();
            BakedModel itemModel = this.multiBlockStructure.bakedModelMap.get(entry.getKey());
            if (itemModel == null) {
                itemModel = renderItem.getModel(item, tile.getWorld(), null, 0);
                this.multiBlockStructure.bakedModelMap.put(entry.getKey(), itemModel);
            }
            int i = this.level != null ? LevelRenderer.getLightColor((BlockAndTintGetter)this.level, (BlockPos)this.getBlockPos()) : 0xF000F0;
            renderItem.render(item, ItemDisplayContext.FIXED, false, poseStack, (MultiBufferSource)((LevelRendererAccessor)event.getLevelRenderer()).getRenderBuffers().bufferSource(), i, OverlayTexture.NO_OVERLAY, itemModel);
            poseStack.popPose();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderUniqueMultiBlock(RenderLevelStageEvent event) {
    }

    @Override
    public boolean isFull() {
        return this.full;
    }

    @Override
    public void setFull(boolean full) {
        if (!full && !this.entityPlayerList.isEmpty()) {
            this.entityPlayerList.forEach(Player::closeContainer);
        }
        this.full = full;
        if (full) {
            this.rotateBlocks();
        }
        if (!this.getWorld().isClientSide) {
            new PacketUpdateFieldTile(this, "full", full);
        }
    }

    @Override
    public MultiBlockStructure getMultiBlockStucture() {
        return this.multiBlockStructure;
    }

    @Override
    public boolean wasActivated() {
        return this.activate;
    }

    @Override
    public void setActivated(boolean active) {
        this.activate = active;
        new PacketUpdateFieldTile(this, "activate", this.activate);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("full")) {
            try {
                this.full = (Boolean)DecoderHandler.decode(is);
                if (this.full) {
                    this.updateAfterAssembly();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("visible")) {
            try {
                this.visible = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("activate")) {
            try {
                this.activate = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.full && !this.activate) {
            this.setFull(false);
        }
    }

    @Override
    public void updateFull() {
        this.setFull(this.getMultiBlockStucture().getFull(this.getFacing(), this.getBlockPos(), this.getLevel()));
        if (this.isFull()) {
            this.setActivated(true);
        }
    }

    @Override
    public void loadBeforeFirstClientUpdate() {
        super.loadBeforeFirstClientUpdate();
        if (this.activate) {
            this.updateFull();
            if (this.full) {
                this.updateAfterAssembly();
            } else {
                this.activate = false;
            }
        }
    }

    @Override
    public void loadBeforeFirstUpdate() {
        super.loadBeforeFirstUpdate();
        if (this.activate) {
            this.updateFull();
            if (this.full) {
                this.updateAfterAssembly();
            } else {
                this.activate = false;
            }
        }
    }

    @Override
    public void updateFull(Player player) {
        this.setFull(this.getMultiBlockStucture().getFull(this.getFacing(), this.getBlockPos(), this.getLevel(), player));
        if (this.isFull()) {
            this.setActivated(true);
        }
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (!this.full || !this.activate) {
            this.getCooldownTracker().setTick(1);
            if (!this.getMultiBlockStucture().isHasActivatedItem()) {
                this.updateFull(player);
                if (this.full) {
                    this.updateAfterAssembly();
                }
                return true;
            }
            if (this.getMultiBlockStucture().isActivateItem(player.getItemInHand(hand))) {
                this.updateFull(player);
                if (!this.full) {
                    return false;
                }
                this.updateAfterAssembly();
            } else if (!this.getWorld().isClientSide) {
                IUCore.proxy.messagePlayer(player, Localization.translate("iu.activate_multiblock") + " " + this.getMultiBlockStucture().getActivateItem().getDisplayName().getString());
            }
            return false;
        }
        this.usingBeforeGUI();
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.getLevel().isClientSide) {
            this.render = BlockEntityMultiBlockBase.createFunction(this);
            GlobalRenderManager.addRender(this.getWorld(), this.pos, this.render);
        }
    }

    @Override
    public void onUnloaded() {
        if (this.getLevel().isClientSide) {
            GlobalRenderManager.removeRender(this.getWorld(), this.pos);
        }
        if (this.isFull() && this.multiBlockStructure != null) {
            List<BlockPos> blockPosList = this.multiBlockStructure.getPoses(this.getFacing(), this.getBlockPos());
            for (BlockPos pos1 : blockPosList) {
                BlockEntity tileentity = this.getLevel().getBlockEntity(pos1);
                if (!(tileentity instanceof BlockEntityMultiBlockElement)) continue;
                BlockEntityMultiBlockElement te = (BlockEntityMultiBlockElement)tileentity;
                te.setMainMultiElement(null);
            }
        }
        super.onUnloaded();
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.activate = nbttagcompound.getBoolean("activate");
        this.visible = nbttagcompound.getBoolean("visible");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putBoolean("activate", this.activate);
        nbttagcompound.putBoolean("visible", this.visible);
        return nbttagcompound;
    }

    @Override
    public IMainMultiBlock getMain() {
        return this;
    }

    @Override
    public void setMainMultiElement(IMainMultiBlock main) {
    }
}

