/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.generator.things.fluid;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine2Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuLavaGenerator;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenLavaGenerator;
import com.denfop.sound.EnumSound;
import com.denfop.utils.ParticleUtils;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BlockEntityLavaGenerator
extends BlockEntityElectricMachine
implements IUpgradableBlock {
    public final InventoryUpgrade upgradeSlot;
    public final InventoryOutput outputSlot = new InventoryOutput(this, 1);
    public final InventoryFluid containerslot = new InventoryFluidByList((BlockEntityInventory)this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.OUTPUT, new Fluid[]{net.minecraft.world.level.material.Fluids.LAVA});
    public final FluidTank fluidTank;
    protected final Fluids fluids = this.addComponent(new Fluids(this));
    private final float energycost;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private double lastEnergy;

    public BlockEntityLavaGenerator(BlockPos pos, BlockState state) {
        super(20000.0, 1, 1, BlockBaseMachine2Entity.lava_gen, pos, state);
        this.energycost = 80.0f;
        this.fluidTank = this.fluids.addTank("fluidTank", 20000, Inventory.TypeItemSlot.OUTPUT, Fluids.fluidPredicate(new Fluid[]{net.minecraft.world.level.material.Fluids.LAVA}));
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.15));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.3));
    }

    private static int applyModifier(int extra) {
        double ret = Math.round(14.0 + (double)extra);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine2Entity.lava_gen;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void readFromNBT(CompoundTag nbt) {
        super.readFromNBT(nbt);
        this.lastEnergy = nbt.getDouble("lastEnergy");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        super.writeToNBT(nbt);
        nbt.putDouble("lastEnergy", this.lastEnergy);
        return nbt;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.setUpgradestat();
        }
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.gen_lava.getSoundEvent();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() && this.getLevel().getGameTime() % 5L == 0L) {
            ParticleUtils.spawnLavaGeneratorParticles(this.getLevel(), this.pos, this.getLevel().random);
        }
        boolean needsInvUpdate = false;
        if (!(this.energy.getEnergy() <= 0.0) && this.fluidTank.getFluidAmount() < this.fluidTank.getCapacity()) {
            if (this.energy.getEnergy() >= (double)this.energycost) {
                needsInvUpdate = this.attemptGeneration();
                this.setActive(true);
                if (this.getLevel().getGameTime() % 40L == 0L) {
                    this.initiate(0);
                }
            } else if (this.getLevel().getGameTime() % 40L == 0L) {
                this.initiate(2);
            }
            this.lastEnergy = this.energy.getEnergy();
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (!this.containerslot.isEmpty() && this.fluidTank.getFluidAmount() > 0) {
            this.containerslot.processFromTank((IFluidTank)this.fluidTank, this.outputSlot);
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public boolean attemptGeneration() {
        int k = (int)(this.energy.getEnergy() / (double)this.energycost);
        if (this.fluidTank.getFluidAmount() + 1 > this.fluidTank.getCapacity()) {
            return false;
        }
        int m = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        this.fluidTank.fill(new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.LAVA, Math.min(m, k)), IFluidHandler.FluidAction.EXECUTE);
        this.energy.useEnergy(this.energycost * (float)Math.min(m, k));
        return true;
    }

    public String getProgressAsString() {
        int p = Math.min((int)(this.energy.getEnergy() * 100.0 / (double)this.energycost), 100);
        return p + "%";
    }

    public ContainerMenuLavaGenerator getGuiContainer(Player entityPlayer) {
        return new ContainerMenuLavaGenerator(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenLavaGenerator((ContainerMenuLavaGenerator)isAdmin);
    }

    public void setUpgradestat() {
        this.energy.setSinkTier(BlockEntityLavaGenerator.applyModifier(this.upgradeSlot.extraTier));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.FluidExtract);
    }
}

