/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.exp;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.sound.AudioFixer;
import com.denfop.api.sound.EnumTypeAudio;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockResource;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine2Entity;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuStorageExp;
import com.denfop.inventory.InventoryExpStorage;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenStorageExp;
import com.denfop.sound.EnumSound;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityStorageExp
extends BlockEntityInventory
implements IUpdatableTileEvent,
AudioFixer {
    public final InventoryExpStorage inputSlot;
    public final ComponentBaseEnergy energy;
    public int expirencelevel;
    public int expirencelevel1;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private double energy1;
    private boolean sound = true;

    public BlockEntityStorageExp(BlockPos pos, BlockState state) {
        super(BlockBaseMachine2Entity.expierence_block, pos, state);
        this.inputSlot = new InventoryExpStorage(this);
        this.energy = this.addComponent(new ComponentBaseEnergy(EnergyType.EXPERIENCE, this, 4.0E9, ModUtils.allFacings, ModUtils.allFacings, 14));
        this.energy.setDirections(ModUtils.allFacings, ModUtils.allFacings);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sound = nbttagcompound.getBoolean("sound");
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.expirencelevel = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.expirencelevel1 = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.expirencelevel);
            EncoderHandler.encode(packet, this.expirencelevel1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putBoolean("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine2Entity.expierence_block;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine1.getBlock(this.getTeBlock().getId());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addInformation(ItemStack stack, List<String> tooltip) {
        CompoundTag nbt = ModUtils.nbt(stack);
        double energy1 = nbt.getDouble("energy");
        if (energy1 != 0.0) {
            tooltip.add(Localization.translate("iu.item.tooltip.Store") + " " + ModUtils.getString(energy1) + "/" + ModUtils.getString(this.energy.getCapacity()) + " EXP");
        }
    }

    @Override
    public ItemStack adjustDrop(ItemStack drop, boolean wrench) {
        if (!wrench) {
            switch (this.teBlock.getDefaultDrop()) {
                default: {
                    ComponentBaseEnergy component2 = this.energy;
                    if (component2 != null && component2.getEnergy() != 0.0) {
                        CompoundTag nbt = ModUtils.nbt(drop);
                        nbt.putDouble("energy", component2.getEnergy());
                    }
                    return drop;
                }
                case None: {
                    return null;
                }
                case Generator: {
                    return new ItemStack(IUItem.basemachine2.getItem(78), 1);
                }
                case Machine: {
                    return IUItem.blockResource.getItemStack(BlockResource.Type.machine);
                }
                case AdvMachine: 
            }
            return IUItem.blockResource.getItemStack(BlockResource.Type.advanced_machine);
        }
        ComponentBaseEnergy component2 = this.energy;
        if (component2 != null && component2.getEnergy() != 0.0) {
            CompoundTag nbt = ModUtils.nbt(drop);
            nbt.putDouble("energy", component2.getEnergy());
        }
        return drop;
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
        CompoundTag nbt = ModUtils.nbt(stack);
        double energy1 = nbt.getDouble("energy");
        if (energy1 != 0.0) {
            this.energy.addEnergy(energy1);
        }
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenStorageExp((ContainerMenuStorageExp)isAdmin);
    }

    public ContainerMenuStorageExp getGuiContainer(Player entityPlayer) {
        return new ContainerMenuStorageExp(entityPlayer, this);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.energy1 != this.energy.getEnergy()) {
            this.expirencelevel = ExperienceUtils.getLevelForExperience((int)Math.min(this.energy.getEnergy(), 2.0E9));
            this.expirencelevel1 = ExperienceUtils.getLevelForExperience((int)Math.min(Math.min(this.energy.getEnergy() - 2.0E9, 0.0), 2.0E9));
            this.energy1 = this.energy.getEnergy();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.getWorld().playSound(null, this.pos, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.getWorld(), this.pos);
            this.getWorld().playSound(null, this.pos, EnumSound.zab.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.getWorld(), this.pos);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.expirencelevel = ExperienceUtils.getLevelForExperience((int)Math.min(this.energy.getEnergy(), 2.0E9));
        this.expirencelevel1 = ExperienceUtils.getLevelForExperience((int)Math.min(Math.min(this.energy.getEnergy() - 2.0E9, 0.0), 2.0E9));
        this.energy1 = this.energy.getEnergy();
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.zap.getSoundEvent();
    }

    @Override
    public void updateTileServer(Player player, double event) {
        if (event == 1.0 && this.energy.getEnergy() < this.energy.getCapacity()) {
            this.energy.buffer.storage = ExperienceUtils.removePlayerXP(player, this.energy.getCapacity(), this.energy.getEnergy());
            this.initiate(1);
        }
        if (event == 0.0 && this.energy.getEnergy() > 0.0) {
            int temp = 0;
            if (this.energy.getEnergy() > 2.0E9) {
                temp = (int)(this.energy.getEnergy() - 2.0E9);
            }
            this.energy.buffer.storage = ExperienceUtils.addPlayerXP1(player, (int)Math.min(this.energy.getEnergy(), 2.0E9));
            this.energy.addEnergy(temp);
            this.initiate(0);
        }
        this.expirencelevel = ExperienceUtils.getLevelForExperience((int)Math.min(this.energy.getEnergy(), 2.0E9));
        this.expirencelevel1 = ExperienceUtils.getLevelForExperience((int)Math.min(Math.max(this.energy.getEnergy() - 2.0E9, 0.0), 2.0E9));
        this.energy1 = this.energy.getEnergy();
    }
}

