/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.energy;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.energy.event.load.EventLoadController;
import com.denfop.api.energy.event.unload.EventUnloadController;
import com.denfop.api.energy.interfaces.EnergyConductor;
import com.denfop.api.energy.interfaces.EnergyController;
import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.energy.networking.EnergyNetLocal;
import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.FakePlayerSpawner;
import com.denfop.blockentity.transport.tiles.BlockEntityCable;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.blockitem.ItemBlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSubstitute;
import com.denfop.inventory.CableItem;
import com.denfop.inventory.InventorySubstitute;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenEnergySubstitute;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class BlockEntityEnergySubstitute
extends BlockEntityInventory
implements IUpdatableTileEvent,
EnergyController {
    public final InventorySubstitute slot;
    public Set<EnergyConductor> conductorList = new HashSet<EnergyConductor>();
    public boolean work = false;
    public int size;
    public int max_value = 0;
    List<CableItem> cableItemList = new ArrayList<CableItem>();
    CableItem main_cableItem = null;
    FakePlayerSpawner fakePlayer;
    Map<Direction, EnergyTile> energyConductorMap = new HashMap<Direction, EnergyTile>();
    List<InfoTile<EnergyTile>> validReceivers = new LinkedList<InfoTile<EnergyTile>>();
    int hashCodeSource;
    private ChunkPos chunkPos;
    private long id;

    public BlockEntityEnergySubstitute(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.substitute, pos, state);
        this.slot = new InventorySubstitute(this);
        this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 0.0, 14));
    }

    @Override
    public void RemoveTile(EnergyTile tile, Direction facing1) {
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<EnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<EnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public List<InfoTile<EnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public void AddTile(EnergyTile tile, Direction facing1) {
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<EnergyTile>(tile, facing1.getOpposite()));
        }
    }

    @Override
    public Map<Direction, EnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.substitute;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.controller_cables.info"));
        tooltip.add(Localization.translate("iu.controller_cables.info1"));
    }

    public List<CableItem> getCableItemList() {
        return this.cableItemList;
    }

    public void setCableItemList(List<CableItem> cableItemList) {
        this.cableItemList = cableItemList;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            NeoForge.EVENT_BUS.post((Event)new EventLoadController(this, this.level));
            this.fakePlayer = new FakePlayerSpawner(this.getWorld());
            this.slot.setChanged();
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.size = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().isClientSide) {
            NeoForge.EVENT_BUS.post((Event)new EventUnloadController(this, this.level));
        }
        super.onUnloaded();
    }

    public ContainerMenuSubstitute getGuiContainer(Player entityPlayer) {
        return new ContainerMenuSubstitute(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenEnergySubstitute((ContainerMenuSubstitute)menu);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.putBoolean("work", this.work);
        return super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.work = nbtTagCompound.getBoolean("work");
    }

    public void discover() {
        this.conductorList.clear();
        this.size = 0;
        ArrayList<EnergyConductor> reachedTileEntities = new ArrayList<EnergyConductor>();
        ArrayList<EnergyTile> tileEntitiesToCheck = new ArrayList<EnergyTile>();
        tileEntitiesToCheck.add(this.getComp(Energy.class).delegate);
        EnergyNetLocal energyNetLocal = EnergyNetGlobal.getForWorld(this.getWorld());
        while (!tileEntitiesToCheck.isEmpty()) {
            EnergyTile currentTileEntity = (EnergyTile)tileEntitiesToCheck.remove(0);
            List<InfoTile<EnergyTile>> validReceivers = energyNetLocal.getValidReceiversSubstitute(currentTileEntity);
            for (InfoTile<EnergyTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == this || !(validReceiver.tileEntity instanceof EnergyConductor) || reachedTileEntities.contains((EnergyConductor)validReceiver.tileEntity)) continue;
                reachedTileEntities.add((EnergyConductor)validReceiver.tileEntity);
                tileEntitiesToCheck.add((EnergyTile)validReceiver.tileEntity);
            }
        }
        this.conductorList.addAll(reachedTileEntities);
        this.size = this.conductorList.size();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.work) {
            if (this.main_cableItem != null) {
                ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
                for (EnergyConductor conductor : this.conductorList) {
                    if (!(conductor.getConductorBreakdownEnergy() - 1.0 < this.main_cableItem.getProvider())) continue;
                    for (ItemStack stack : this.slot) {
                        if (!stack.is(this.main_cableItem.getStack().getItem()) || !(this.main_cableItem.getStack().getItem() instanceof ItemBlockTileEntity) || !ModUtils.nbt(this.main_cableItem.getStack()).equals((Object)ModUtils.nbt(stack))) continue;
                        BlockEntityBase tile = (BlockEntityBase)EnergyNetGlobal.instance.getBlockPosFromEnergyTile(conductor, this.level);
                        List<ItemStack> drops = tile.getBlock().getDrops(this.level, tile.getPos(), tile.getBlockState(), null);
                        if (!drops.isEmpty()) {
                            itemStackList.add(drops.get(0));
                        }
                        tile.onUnloaded();
                        conductor.removeConductor();
                        BlockPos pos = tile.getPos();
                        ItemBlockTileEntity itemBlockTileEntity = (ItemBlockTileEntity)this.main_cableItem.getStack().getItem();
                        if (!itemBlockTileEntity.placeTeBlock(this.main_cableItem.getStack(), this.fakePlayer, this.getWorld(), pos)) continue;
                        stack.shrink(1);
                        this.main_cableItem.shrink(1);
                        BlockEntityCable cable = (BlockEntityCable)this.getWorld().getBlockEntity(pos);
                        break;
                    }
                    if (this.main_cableItem.getCount() != 0) continue;
                    this.slot.setChanged();
                    if (this.main_cableItem != null) continue;
                    break;
                }
                for (ItemStack stack : itemStackList) {
                    this.slot.add(stack);
                }
            }
            this.size = 0;
            this.work = false;
            this.discover();
            this.main_cableItem = null;
            this.slot.setChanged();
        }
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (this.level.isClientSide) {
            return;
        }
        if (i == 0.0) {
            this.discover();
            this.main_cableItem = null;
            this.slot.setChanged();
        } else if (i == 1.0) {
            this.work = true;
        }
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void work() {
        if (this.getWork()) {
            this.discover();
        }
    }

    @Override
    public void unload() {
        this.conductorList.clear();
        this.size = 0;
    }

    public void setMaxValue(int max_value, double provider, CableItem cableItem) {
        if (provider > (double)max_value) {
            this.max_value = (int)provider;
            this.main_cableItem = cableItem;
        }
    }
}

