/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.energy;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.energy.event.load.EventLoadController;
import com.denfop.api.energy.event.unload.EventUnloadController;
import com.denfop.api.energy.interfaces.EnergyController;
import com.denfop.api.energy.interfaces.EnergyTile;
import com.denfop.api.energy.networking.EnergyNetGlobal;
import com.denfop.api.energy.networking.Path;
import com.denfop.api.otherenergies.common.InfoTile;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuController;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenEnergyController;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class BlockEntityEnergyController
extends BlockEntityInventory
implements IUpdatableTileEvent,
EnergyController {
    public List<Path> energyPathList = new ArrayList<Path>();
    public boolean work = false;
    public int size;
    Map<Direction, EnergyTile> energyConductorMap = new HashMap<Direction, EnergyTile>();
    List<InfoTile<EnergyTile>> validReceivers = new LinkedList<InfoTile<EnergyTile>>();
    int hashCodeSource;
    private ChunkPos chunkPos;
    private long id;

    public BlockEntityEnergyController(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.energy_controller, pos, state);
        this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 0.0, 14));
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.energy_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.controller.info"));
        tooltip.add(Localization.translate("iu.controller.info1"));
    }

    @Override
    public List<InfoTile<EnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void RemoveTile(EnergyTile tile, Direction facing1) {
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<EnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<EnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    @Override
    public int getHashCodeSource() {
        return this.hashCodeSource;
    }

    @Override
    public void setHashCodeSource(int hashCode) {
        this.hashCodeSource = hashCode;
    }

    @Override
    public void AddTile(EnergyTile tile, Direction facing1) {
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<EnergyTile>(tile, facing1.getOpposite()));
        }
    }

    @Override
    public Map<Direction, EnergyTile> getTiles() {
        return this.energyConductorMap;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.size = (Integer)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.size);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.energyConductorMap.clear();
            this.validReceivers.clear();
            NeoForge.EVENT_BUS.post((Event)new EventLoadController(this, this.level));
        }
    }

    @Override
    public void onUnloaded() {
        if (!this.getWorld().isClientSide) {
            NeoForge.EVENT_BUS.post((Event)new EventUnloadController(this, this.level));
        }
        super.onUnloaded();
    }

    public ContainerMenuController getGuiContainer(Player entityPlayer) {
        return new ContainerMenuController(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenEnergyController((ContainerMenuController)menu);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.putBoolean("work", this.work);
        return super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.work = nbtTagCompound.getBoolean("work");
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (this.level.isClientSide) {
            return;
        }
        if (i == 0.0) {
            this.energyPathList.clear();
            for (Direction facing : Direction.values()) {
                List<Path> energyPathList1 = EnergyNetGlobal.instance.getEnergyPaths(this.getWorld(), this.getBlockPos().offset(facing.getNormal()));
                for (Path path : energyPathList1) {
                    if (this.energyPathList.contains(path)) continue;
                    this.energyPathList.add(path);
                }
            }
            this.size = this.energyPathList.size();
        } else if (i == 1.0) {
            this.work = true;
            this.energyPathList.forEach(energyPath -> energyPath.setHasController(true));
        }
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void work() {
        if (this.getWork()) {
            this.energyPathList.clear();
            for (Direction facing : Direction.values()) {
                List<Path> energyPathList1 = EnergyNetGlobal.instance.getEnergyPaths(this.getWorld(), this.getBlockPos().offset(facing.getNormal()));
                for (Path path : energyPathList1) {
                    if (this.energyPathList.contains(path)) continue;
                    this.energyPathList.add(path);
                }
            }
            this.size = this.energyPathList.size();
            this.energyPathList.forEach(energyPath -> energyPath.setHasController(true));
        }
    }

    @Override
    public void unload() {
        this.energyPathList.forEach(energyPath -> energyPath.setHasController(false));
    }
}

