/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.dual.heat;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.base.BlockEntityDoubleElectricMachine;
import com.denfop.blockentity.base.EnumDoubleElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachineEntity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuDoubleElectricMachine;
import com.denfop.inventory.Inventory;
import com.denfop.recipe.IInputHandler;
import com.denfop.recipe.IInputItemStack;
import com.denfop.screen.ScreenAlloySmelter;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.sound.EnumSound;
import com.denfop.utils.ModUtils;
import com.denfop.utils.ParticleUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityAlloySmelter
extends BlockEntityDoubleElectricMachine
implements IHasRecipe {
    public final Inventory input_slot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;

    public BlockEntityAlloySmelter(BlockPos pos, BlockState state) {
        super(1, 300, 1, EnumDoubleElectricMachine.ALLOY_SMELTER, BlockBaseMachineEntity.alloy_smelter, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.input_slot = new Inventory(this, this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (this.get(0).isEmpty()) {
                    ((BlockEntityAlloySmelter)this.base).inputSlotA.changeAccepts(ItemStack.EMPTY);
                } else {
                    ((BlockEntityAlloySmelter)this.base).inputSlotA.changeAccepts(this.get(0));
                }
                return content;
            }

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                return stack.getItem() == IUItem.recipe_schedule.getItem();
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }
        };
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.2));
    }

    public static void addAlloysmelter(IInputItemStack container, IInputItemStack fill, ItemStack output, int temperature) {
        CompoundTag nbt = ModUtils.nbt();
        nbt.putShort("temperature", (short)temperature);
        Recipes.recipes.addRecipe("alloysmelter", new BaseMachineRecipe(new Input(container, fill), new RecipeOutput(nbt, output)));
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getActive() && this.level.getGameTime() % 5L == 0L) {
            ParticleUtils.spawnAlloySmelterParticles(this.level, this.pos, this.level.random);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            if (this.input_slot.isEmpty()) {
                this.inputSlotA.changeAccepts(ItemStack.EMPTY);
            } else {
                this.inputSlotA.changeAccepts(this.input_slot.get(0));
            }
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachineEntity.alloy_smelter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.machines.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)Items.IRON_INGOT), 1), input.getInput(new ItemStack((ItemLike)Items.COAL), 2), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(502), 1), 4000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:gems/bor", 1), input.getInput(new ItemStack((ItemLike)Items.NETHER_STAR), 1), new ItemStack((ItemLike)IUItem.nether_star_ingot.getItem()), 2000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/tungsten", 2), input.getInput("c:ingots/nickel", 1), new ItemStack((ItemLike)IUItem.wolframite.getItem()), 3000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(13), 1)), input.getInput(new ItemStack((ItemLike)IUItem.iuingot.getItemFromMeta(3), 2)), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(480), 2), 4000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(64), 1)), input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(28), 1)), new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(73), 1), 1000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/steel", 2), input.getInput("c:ingots/titanium", 3), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(503), 1), 3000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.iuingot.getItemFromMeta(28), 2)), input.getInput(new ItemStack((ItemLike)IUItem.iuingot.getItemFromMeta(32), 1)), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(31), 1), 4000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(1), 2)), input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(31), 3)), new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(59), 1), 4000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)Items.GOLD_INGOT), 1), input.getInput("c:ingots/silver", 1), new ItemStack((ItemLike)IUItem.iuingot.getItemFromMeta(13), 2), 3500);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(481), 1)), input.getInput("c:dusts/coal", 2), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(482), 1), 1000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/nickel", 1), input.getInput(new ItemStack((ItemLike)Items.IRON_INGOT), 2), input.getInput("c:ingots/Invar", 3).getInputs().get(0), 5000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(37), 1)), input.getInput("c:dusts/iron", 2), new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(38), 1), 2000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(71), 1)), input.getInput(new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(60), 1)), new ItemStack((ItemLike)IUItem.iudust.getItemFromMeta(33), 1), 2000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)Items.COAL), 1), input.getInput(new ItemStack((ItemLike)Items.QUARTZ), 4), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(319), 1), 2000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:storage_blocks/silver", 1), input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(484), 1), 1), new ItemStack((ItemLike)IUItem.crafting_elements.getItemFromMeta(434), 1), 2000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/copper", 1), input.getInput("c:ingots/zinc", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(2), 1), 3000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/nickel", 1), input.getInput("c:ingots/chromium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(4), 1), 4000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/nickel", 1), input.getInput("c:ingots/titanium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(15), 1), 4000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/tin", 1), input.getInput("c:ingots/copper", 3), ModUtils.setSize(IUItem.bronzeIngot, 4), 1000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/aluminium", 1), input.getInput("c:ingots/magnesium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(8), 1), 2000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/aluminium", 1), input.getInput("c:ingots/titanium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(1), 1), 5000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/aluminium", 1), input.getInput("c:ingots/lithium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(22), 1), 2000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/chromium", 1), input.getInput("c:ingots/cobalt", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(23), 1), 2000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/niobium", 2), input.getInput("c:ingots/titanium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(26), 1), 3000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput("c:ingots/osmium", 2), input.getInput("c:ingots/iridium", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(27), 1), 3000);
        BlockEntityAlloySmelter.addAlloysmelter(input.getInput(new ItemStack((ItemLike)Items.IRON_INGOT), 1), input.getInput("c:ingots/manganese", 1), new ItemStack((ItemLike)IUItem.alloysingot.getItemFromMeta(9), 1), 4500);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenAlloySmelter((ContainerMenuDoubleElectricMachine)menu);
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.alloysmelter.getSoundEvent();
    }
}

