/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism.cooling;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.CoolComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentClientEffectRender;
import com.denfop.componets.client.EffectType;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuCoolMachine;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenCoolMachine;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityCooling
extends BlockEntityElectricMachine
implements IUpdatableTileEvent {
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public CoolComponent cold;
    public int max;
    public boolean work;
    private int coef;

    public BlockEntityCooling(BlockPos pos, BlockState state) {
        super(10000.0, 14, 1, BlockBaseMachine3Entity.cooling, pos, state);
        this.cold = this.addComponent(CoolComponent.asBasicSource(this, 4.0, this.tier));
        this.max = 4;
        this.componentClientEffectRender = new ComponentClientEffectRender(this, EffectType.REFRIGERATOR);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.05));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.05));
    }

    @Override
    public boolean needUpdate() {
        return true;
    }

    @Override
    public CustomPacketBuffer writeUpdatePacket() {
        CustomPacketBuffer packet = super.writeUpdatePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readUpdatePacket(CustomPacketBuffer customPacketBuffer) {
        super.readUpdatePacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.max = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.work = (Boolean)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.max);
            EncoderHandler.encode(packet, this.work);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer packet = super.writePacket();
        try {
            EncoderHandler.encode(packet, this.cold, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.cold.onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.cooling;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.max = nbttagcompound.getInt("max");
        this.work = nbttagcompound.getBoolean("work");
        this.cold.setCapacity(this.max);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putInt("max", this.max);
        nbttagcompound.putBoolean("work", this.work);
        return nbttagcompound;
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (i == 0.0) {
            this.cold.setCapacity(this.max + 4);
            if (this.cold.getCapacity() > 64.0) {
                this.cold.setCapacity(64.0);
            }
            this.max = (int)this.cold.getCapacity();
        }
        if (i == 1.0) {
            this.cold.setCapacity(this.max - 4);
            if (this.cold.getCapacity() < 4.0) {
                this.cold.setCapacity(4.0);
            }
            this.max = (int)this.cold.getCapacity();
        }
        if (i == 2.0) {
            boolean bl = this.work = !this.work;
        }
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "30" + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.coef = (int)Math.max(Math.ceil(this.cold.buffer.storage / 16.0), 1.0);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.cold.buffer.allow || this.work) {
            if (this.energy.getEnergy() >= (double)(30 * this.coef) && this.cold.getEnergy() < this.cold.getCapacity()) {
                this.cold.addEnergy(1.0);
                this.energy.useEnergy(30 * this.coef);
                this.initiate(0);
                this.setActive(true);
            }
            if (this.level.getGameTime() % 400L == 0L) {
                this.initiate(2);
            }
            if (this.energy.getEnergy() < (double)(30 * this.coef)) {
                this.initiate(2);
                this.setActive(false);
            } else {
                this.initiate(0);
            }
        } else {
            this.initiate(2);
            this.setActive(false);
        }
        if (this.level.getGameTime() % 20L == 0L && this.cold.getEnergy() >= 1.0) {
            this.cold.addEnergy(-1.0);
        }
    }

    public ContainerMenuCoolMachine getGuiContainer(Player entityPlayer) {
        return new ContainerMenuCoolMachine(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenCoolMachine((ContainerMenuCoolMachine)menu);
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.cooling.getSoundEvent();
    }
}

