/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.vein.common.Type;
import com.denfop.api.vein.common.VeinBase;
import com.denfop.api.vein.common.VeinSystem;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.base.IManufacturerBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.Energy;
import com.denfop.componets.Fluids;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuWirelessGasPump;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.VeinInfo;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemVeinSensor;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenWirelessGasPump;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BlockEntityWirelessGasPump
extends BlockEntityInventory
implements IManufacturerBlock {
    public final Fluids fluids;
    public final Fluids.InternalFluidTank fluidTank;
    public final Energy energy;
    public final Inventory invslot;
    public List<VeinBase> veinList = new LinkedList<VeinBase>();
    public int levelBlock;

    public BlockEntityWirelessGasPump(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.wireless_gas_pump, pos, state);
        this.fluids = this.addComponent(new Fluids(this));
        this.fluidTank = this.fluids.addTank("tank", 256000, Fluids.fluidPredicate((Fluid)FluidName.fluidgas.getInstance().get()));
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 50000.0, 14));
        this.invslot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 4){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                BlockEntityWirelessGasPump.this.updateList();
                return content;
            }

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                if (!(stack.getItem() instanceof ItemVeinSensor)) {
                    return false;
                }
                if (stack.has(DataComponentsInit.VEIN_INFO)) {
                    return ((VeinInfo)stack.get(DataComponentsInit.VEIN_INFO)).type().equals("gas");
                }
                return false;
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenWirelessGasPump((ContainerMenuWirelessGasPump)menu);
    }

    public ContainerMenuWirelessGasPump getGuiContainer(Player var1) {
        return new ContainerMenuWirelessGasPump(this, var1);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.wireless_gas_pump;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.levelBlock = nbtTagCompound.getInt("level");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.putInt("level", this.levelBlock);
        return nbtTagCompound;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.levelBlock < 10) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.getItem().equals(IUItem.upgrade_speed_creation.getItem())) {
                return super.onActivated(player, hand, side, vec3);
            }
            stack.shrink(1);
            ++this.levelBlock;
            return true;
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        boolean active = false;
        for (VeinBase vein : this.veinList) {
            if (!(this.energy.getEnergy() >= 10.0) || !vein.isFind() || vein.getCol() < 1) continue;
            int size = Math.min(this.levelBlock * 15 + 5, vein.getCol());
            size = Math.min(size, this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount());
            if (this.fluidTank.getFluidAmount() + size > this.fluidTank.getCapacity()) continue;
            this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidgas.getInstance().get(), size), IFluidHandler.FluidAction.EXECUTE);
            vein.removeCol(size);
            active = true;
            this.energy.useEnergy(10.0);
        }
        this.setActive(active);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.levelBlock != 0) {
            ret.add(new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), this.levelBlock));
            this.levelBlock = 0;
        }
        return ret;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + "10" + Localization.translate("iu.machines_work_energy_type_eu"));
        }
        if (stack.has(DataComponentsInit.DATA) && ((CompoundTag)stack.get(DataComponentsInit.DATA)).contains("fluid")) {
            FluidStack fluidStack = FluidStack.parseOptional((HolderLookup.Provider)this.level.registryAccess(), (CompoundTag)((CompoundTag)((CompoundTag)stack.get(DataComponentsInit.DATA)).get("fluid")));
            tooltip.add(Localization.translate("iu.fluid.info") + fluidStack.getFluid().getFluidType().getDescription().getString());
            tooltip.add(Localization.translate("iu.fluid.info1") + fluidStack.getAmount() / 1000 + " B");
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.veinList.clear();
        int col = customPacketBuffer.readInt();
        for (int i = 0; i < col; ++i) {
            try {
                this.veinList.add((VeinBase)DecoderHandler.decode(customPacketBuffer));
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeInt(this.veinList.size());
        for (VeinBase vein : this.veinList) {
            try {
                EncoderHandler.encode(customPacketBuffer, vein);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return customPacketBuffer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.updateList();
        }
    }

    public void updateList() {
        this.veinList.clear();
        for (ItemStack stack : this.invslot) {
            int z;
            VeinInfo veinInfo;
            int x;
            ChunkPos chunkPos;
            VeinBase vein;
            if (stack.isEmpty() || !(vein = VeinSystem.system.getVein(chunkPos = new ChunkPos((x = (veinInfo = (VeinInfo)stack.get(DataComponentsInit.VEIN_INFO)).x()) >> 4, (z = veinInfo.z()) >> 4))).isFind() || vein.getType() != Type.GAS) continue;
            this.veinList.add(vein);
        }
    }

    @Override
    public int getLevelMechanism() {
        return this.levelBlock;
    }

    @Override
    public void setLevelMech(int level) {
        this.levelBlock = level;
    }

    @Override
    public void removeLevel(int level) {
        this.levelBlock -= level;
    }
}

