/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockBase;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuWirelessControllerReactors;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datacomponent.ReactorData;
import com.denfop.inventory.Inventory;
import com.denfop.items.ItemReactorData;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenWirelessControllerReactors;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class BlockEntityWirelessControllerReactors
extends BlockEntityInventory
implements IUpdatableTileEvent {
    public final Inventory invslot;
    public List<ItemStack> itemStacks = new LinkedList<ItemStack>();
    public List<BlockEntityMultiBlockBase> tileMultiBlockBaseList = new LinkedList<BlockEntityMultiBlockBase>();

    public BlockEntityWirelessControllerReactors(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.wireless_controller_reactors, pos, state);
        this.invslot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 12){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                BlockEntityWirelessControllerReactors.this.updateList();
                return content;
            }

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                if (!(stack.getItem() instanceof ItemReactorData)) {
                    return false;
                }
                return stack.has(DataComponentsInit.REACTOR_DATA);
            }
        };
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public ContainerMenuWirelessControllerReactors getGuiContainer(Player var1) {
        return new ContainerMenuWirelessControllerReactors(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenWirelessControllerReactors((ContainerMenuWirelessControllerReactors)menu);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.wireless_controller_reactors;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            // empty if block
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.tileMultiBlockBaseList.clear();
        this.itemStacks.clear();
        for (int i = 0; i < 12; ++i) {
            if (this.invslot.get(i).isEmpty()) {
                this.tileMultiBlockBaseList.add(null);
                this.itemStacks.add(ItemStack.EMPTY);
                continue;
            }
            @Nullable ReactorData reactorData = (ReactorData)this.invslot.get(i).get(DataComponentsInit.REACTOR_DATA);
            BlockPos pos = reactorData.pos();
            BlockEntity tileEntity = this.getWorld().getBlockEntity(pos);
            if (tileEntity instanceof BlockEntityMultiBlockBase && tileEntity instanceof IAdvReactor) {
                this.tileMultiBlockBaseList.add((BlockEntityMultiBlockBase)tileEntity);
                this.itemStacks.add(((BlockEntityMultiBlockBase)tileEntity).getPickBlock(null, null));
                continue;
            }
            this.tileMultiBlockBaseList.add(null);
            this.itemStacks.add(ItemStack.EMPTY);
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.updateList();
        }
    }

    public void updateList() {
        this.itemStacks.clear();
        this.tileMultiBlockBaseList.clear();
        for (int i = 0; i < 12; ++i) {
            if (this.invslot.get(i).isEmpty()) {
                this.tileMultiBlockBaseList.add(null);
                this.itemStacks.add(ItemStack.EMPTY);
                continue;
            }
            @Nullable ReactorData reactorData = (ReactorData)this.invslot.get(i).get(DataComponentsInit.REACTOR_DATA);
            BlockPos pos = reactorData.pos();
            BlockEntity tileEntity = this.getWorld().getBlockEntity(pos);
            if (tileEntity instanceof BlockEntityMultiBlockBase && tileEntity instanceof IAdvReactor) {
                this.tileMultiBlockBaseList.add((BlockEntityMultiBlockBase)tileEntity);
                this.itemStacks.add(((BlockEntityMultiBlockBase)tileEntity).getPickBlock(null, null));
                continue;
            }
            this.tileMultiBlockBaseList.add(null);
            this.itemStacks.add(ItemStack.EMPTY);
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        BlockEntityMultiBlockBase tileMultiBlockBase;
        if (!this.itemStacks.get((int)var2).isEmpty() && (tileMultiBlockBase = this.tileMultiBlockBaseList.get((int)var2)) != null && tileMultiBlockBase.isFull() && !tileMultiBlockBase.isRemoved()) {
            tileMultiBlockBase.onActivated(var1, var1.getUsedItemHand(), Direction.NORTH, new Vec3(0.0, 0.0, 0.0));
        }
    }
}

