/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuTreeBreaker;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenTreeBreaker;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityTreeBreaker
extends BlockEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 4;
    public final InventoryOutput slot;
    public final Energy energy;
    public final InventoryUpgrade upgradeSlot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade;
    AABB searchArea;
    private ComponentVisibleArea visible;

    public BlockEntityTreeBreaker(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.tree_breaker, pos, state);
        this.searchArea = new AABB(ModUtils.getVecFromVec3i((Vec3i)this.pos.offset(-4, -4, -4)), ModUtils.getVecFromVec3i((Vec3i)this.pos.offset(5, 5, 5)));
        this.slot = new InventoryOutput(this, 18);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 4000.0, 5));
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.tree_breaker;
    }

    public ContainerMenuTreeBreaker getGuiContainer(Player var1) {
        return new ContainerMenuTreeBreaker(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenTreeBreaker((ContainerMenuTreeBreaker)menu);
    }

    private void breakTreesInRadius() {
        for (int x = -4; x <= 4; ++x) {
            for (int z = -4; z <= 4; ++z) {
                BlockPos targetPos = this.pos.offset(x, 0, z);
                BlockState state = this.level.getBlockState(targetPos);
                Block block = state.getBlock();
                if (!(block instanceof RotatedPillarBlock) || !(this.energy.getEnergy() >= 100.0)) continue;
                this.breakTree(targetPos);
                this.energy.useEnergy(100.0);
                return;
            }
        }
    }

    private void breakTree(BlockPos startPos) {
        ArrayList<BlockPos> blocksToBreak = new ArrayList<BlockPos>();
        this.findConnectedTreeBlocks(startPos, blocksToBreak);
        for (BlockPos blockPos : blocksToBreak) {
            BlockState state = this.level.getBlockState(blockPos);
            Block block = state.getBlock();
            List drops = Block.getDrops((BlockState)state, (ServerLevel)((ServerLevel)this.level), (BlockPos)blockPos, null);
            for (ItemStack drop : drops) {
                this.slot.add(drop);
            }
            this.level.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 3);
        }
    }

    private void findConnectedTreeBlocks(BlockPos startPos, List<BlockPos> blocksToBreak) {
        if (blocksToBreak.contains(startPos)) {
            return;
        }
        BlockState state = this.level.getBlockState(startPos);
        Block block = state.getBlock();
        if (block instanceof RotatedPillarBlock || block instanceof LeavesBlock) {
            blocksToBreak.add(startPos);
            for (BlockPos offset : BlockPos.betweenClosed((BlockPos)startPos.offset(-1, -1, -1), (BlockPos)startPos.offset(1, 1, 1))) {
                this.findConnectedTreeBlocks(offset.immutable(), blocksToBreak);
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.sapling_gardener.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().getGameTime() % 40L == 0L) {
            this.breakTreesInRadius();
        }
    }
}

