/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuShield;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.inventory.Inventory;
import com.denfop.items.modules.ItemEntityModule;
import com.denfop.network.DecoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.base.RenderType;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenShield;
import com.denfop.utils.CapturedMobUtils;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class BlockEntityShield
extends BlockEntityInventory
implements IUpdatableTileEvent {
    final int latitudeSegments = 16;
    final int longitudeSegments = 16;
    private final Inventory slot;
    public boolean visibleShield = false;
    public boolean visibleLaser = false;
    Energy energy;
    List<Integer> integerList = new LinkedList<Integer>();
    AABB shieldBox;
    AABB shieldDefaultBox = new AABB(-8.0, -8.0, -8.0, 8.0, 8.0, 8.0);
    Vec3i center;
    LinkedList<LevelChunk> chunks = new LinkedList();
    List<UUID> uuidList = new LinkedList<UUID>();
    double[] sinLat = new double[17];
    double[] cosLat = new double[17];
    double[] sinLng = new double[17];
    double[] cosLng = new double[17];
    boolean write = false;
    double[][] x1 = new double[16][16];
    double[][] x2 = new double[16][16];
    double[][] x3 = new double[16][16];
    double[][] x4 = new double[16][16];
    double[][] y1 = new double[16][16];
    double[][] y2 = new double[16][16];
    double[][] y3 = new double[16][16];
    double[][] y4 = new double[16][16];
    double[][] z1 = new double[16][16];
    double[][] z2 = new double[16][16];
    double[][] z3 = new double[16][16];
    double[][] z4 = new double[16][16];
    @OnlyIn(value=Dist.CLIENT)
    private Function<RenderLevelStageEvent, Void> render;
    private double laserProgress;
    private byte mode = 0;
    private long lastShotTime = 0L;
    private boolean isShooting = false;

    public BlockEntityShield(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.shield, pos, state);
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 10000.0, 14));
        this.slot = new Inventory(this, Inventory.TypeItemSlot.INPUT, 9){

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                if (!(stack.getItem() instanceof ItemEntityModule)) {
                    return false;
                }
                if (((ISubEnum)((ItemEntityModule)stack.getItem()).getElement()).getId() == 0) {
                    return false;
                }
                return CapturedMobUtils.containsSoul(stack);
            }

            @Override
            public void update() {
                super.update();
                BlockEntityShield.this.integerList.clear();
                for (int i = 0; i < this.size(); ++i) {
                    if (this.get(i).isEmpty()) continue;
                    CapturedMobUtils captured = CapturedMobUtils.create(this.get(i), BlockEntityShield.this.level.registryAccess());
                    assert (captured != null);
                    LivingEntity entityLiving = (LivingEntity)captured.getEntity(((BlockEntityShield)this.base).getWorld(), true);
                    BlockEntityShield.this.integerList.add(entityLiving.getId());
                }
            }
        };
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag compound) {
        super.writeToNBT(compound);
        compound.putBoolean("VisibleShield", this.visibleShield);
        compound.putBoolean("VisibleLaser", this.visibleLaser);
        compound.putByte("Mode", this.mode);
        return compound;
    }

    @Override
    public void readFromNBT(CompoundTag compound) {
        super.readFromNBT(compound);
        this.visibleShield = compound.getBoolean("VisibleShield");
        this.visibleLaser = compound.getBoolean("VisibleLaser");
        this.mode = compound.getByte("Mode");
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.slot.update();
        this.shieldBox = new AABB(Vec3.atCenterOf((Vec3i)this.getPos().offset(-8, -8, -8)), Vec3.atCenterOf((Vec3i)this.getPos().offset(8, 8, 8)));
        this.center = this.getPos().offset(new Vec3i(0, 0, 0));
        int j2 = Mth.floor((double)((this.shieldBox.minX - 2.0) / 16.0));
        int k2 = Mth.ceil((double)((this.shieldBox.maxX + 2.0) / 16.0));
        int l2 = Mth.floor((double)((this.shieldBox.minZ - 2.0) / 16.0));
        int i3 = Mth.ceil((double)((this.shieldBox.maxZ + 2.0) / 16.0));
        for (int j3 = j2; j3 < k2; ++j3) {
            for (int k3 = l2; k3 < i3; ++k3) {
                LevelChunk chunk = this.level.getChunk(j3, k3);
                if (this.chunks.contains(chunk)) continue;
                this.chunks.add(chunk);
            }
        }
        if (this.getWorld().isClientSide) {
            this.render = this.createFunction();
            GlobalRenderManager.addRender(this.getWorld(), this.pos, this.render);
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.getWorld().isClientSide) {
            GlobalRenderManager.removeRender(this.level, this.pos);
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("uuid")) {
            try {
                UUID uuid = (UUID)DecoderHandler.decode(is);
                this.uuidList.add(uuid);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("visibleShield")) {
            try {
                this.visibleShield = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("visibleLaser")) {
            try {
                this.visibleLaser = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("mode")) {
            try {
                this.mode = (Byte)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Function<RenderLevelStageEvent, Void> createFunction() {
        Function<RenderLevelStageEvent, Void> function = o -> {
            int shieldColor;
            List mobs;
            if (this.shieldBox == null) {
                this.shieldBox = new AABB(Vec3.atCenterOf((Vec3i)this.getPos().offset(-8, -8, -8)), Vec3.atCenterOf((Vec3i)this.getPos().offset(8, 8, 8)));
                this.center = this.getPos().offset(new Vec3i(0, 0, 0));
                int j2 = Mth.floor((double)((this.shieldBox.minX - 2.0) / 16.0));
                int k2 = Mth.ceil((double)((this.shieldBox.maxX + 2.0) / 16.0));
                int l2 = Mth.floor((double)((this.shieldBox.minZ - 2.0) / 16.0));
                int i3 = Mth.ceil((double)((this.shieldBox.maxZ + 2.0) / 16.0));
                for (int j3 = j2; j3 < k2; ++j3) {
                    for (int k3 = l2; k3 < i3; ++k3) {
                        LevelChunk chunk = this.level.getChunk(j3, k3);
                        if (this.chunks.contains(chunk)) continue;
                        this.chunks.add(chunk);
                    }
                }
            }
            boolean mobNearby = !(mobs = this.level.getEntitiesOfClass(Entity.class, this.shieldBox, e -> {
                boolean hasmob = e instanceof Mob;
                if (this.mode == 0) {
                    return hasmob && !this.integerList.contains(e.getId());
                }
                return hasmob && this.integerList.contains(e.getId());
            })).isEmpty();
            int n = shieldColor = mobNearby ? ModUtils.convertRGBcolorToInt(168, 0, 0) : 65535;
            if (this.visibleShield) {
                this.renderShield((RenderLevelStageEvent)o, this.shieldBox, shieldColor);
            }
            this.uuidList.clear();
            return null;
        };
        return function;
    }

    public Inventory getSlot() {
        return this.slot;
    }

    public byte getMode() {
        return this.mode;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.energy.getEnergy() >= 25.0) {
            boolean mobNearby;
            List mobs = this.level.getEntitiesOfClass(Entity.class, this.shieldBox, e -> {
                boolean hasmob = e instanceof Mob;
                if (this.mode == 0) {
                    return hasmob && !this.integerList.contains(e.getId());
                }
                return hasmob && this.integerList.contains(e.getId());
            });
            boolean bl = mobNearby = !mobs.isEmpty();
            if (mobNearby) {
                for (Entity entity : mobs) {
                    if (!(this.energy.getEnergy() >= 25.0)) break;
                    new PacketUpdateFieldTile(this, "uuid", entity.getUUID());
                    entity.hurt(entity.damageSources().magic(), 4.0f);
                    this.energy.useEnergy(25.0);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderShield(RenderLevelStageEvent event, AABB box, int color) {
        double camX = event.getCamera().getPosition().x();
        double camY = event.getCamera().getPosition().y();
        double camZ = event.getCamera().getPosition().z();
        PoseStack poseStack = event.getPoseStack();
        poseStack.pushPose();
        VertexConsumer bufferSource = Minecraft.getInstance().renderBuffers().bufferSource().getBuffer(RenderType.LEASH_TRANSPARENT);
        Color color1 = new Color(color);
        if (!this.write) {
            this.writeData();
        }
        this.drawCircle(poseStack, bufferSource, this.pos, (float)color1.getRed() / 255.0f, (float)color1.getGreen() / 255.0f, (float)color1.getBlue() / 255.0f, 0.5f);
        poseStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void writeData() {
        int i;
        this.write = true;
        for (i = 0; i <= 16; ++i) {
            double lat = Math.PI * (-0.5 + (double)i / 16.0);
            this.sinLat[i] = Math.sin(lat);
            this.cosLat[i] = Math.cos(lat);
        }
        for (int j = 0; j <= 16; ++j) {
            double lng = Math.PI * 2 * (double)j / 16.0;
            this.sinLng[j] = Math.sin(lng);
            this.cosLng[j] = Math.cos(lng);
        }
        for (i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.x1[i][j] = this.cosLng[j] * this.cosLat[i];
                this.y1[i][j] = this.sinLat[i];
                this.z1[i][j] = this.sinLng[j] * this.cosLat[i];
                this.x2[i][j] = this.cosLng[j] * this.cosLat[i + 1];
                this.y2[i][j] = this.sinLat[i + 1];
                this.z2[i][j] = this.sinLng[j] * this.cosLat[i + 1];
                this.x3[i][j] = this.cosLng[j + 1] * this.cosLat[i + 1];
                this.y3[i][j] = this.sinLat[i + 1];
                this.z3[i][j] = this.sinLng[j + 1] * this.cosLat[i + 1];
                this.x4[i][j] = this.cosLng[j + 1] * this.cosLat[i];
                this.y4[i][j] = this.sinLat[i];
                this.z4[i][j] = this.sinLng[j + 1] * this.cosLat[i];
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void drawCircle(PoseStack poseStack, VertexConsumer bufferSource, BlockPos pos, float r, float g, float b, float alpha) {
        float x = (float)pos.getX() + 0.5f;
        float y = (float)pos.getY() + 0.5f;
        float z = (float)pos.getZ() + 0.5f;
        float radius = 8.0f;
        Matrix4f matrix = poseStack.last().pose();
        Matrix3f matrix3f = poseStack.last().normal();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                double x1 = this.x1[i][j];
                double y1 = this.y1[i][j];
                double z1 = this.z1[i][j];
                double x2 = this.x2[i][j];
                double y2 = this.y2[i][j];
                double z2 = this.z2[i][j];
                double x3 = this.x3[i][j];
                double y3 = this.y3[i][j];
                double z3 = this.z3[i][j];
                double x4 = this.x4[i][j];
                double y4 = this.y4[i][j];
                double z4 = this.z4[i][j];
                bufferSource.addVertex(matrix, (float)((double)x + x1 * (double)radius), (float)((double)y + y1 * (double)radius), (float)((double)z + z1 * (double)radius)).setColor(r, g, b, 0.5f);
                bufferSource.addVertex(matrix, (float)((double)x + x2 * (double)radius), (float)((double)y + y2 * (double)radius), (float)((double)z + z2 * (double)radius)).setColor(r, g, b, 0.5f);
                bufferSource.addVertex(matrix, (float)((double)x + x3 * (double)radius), (float)((double)y + y3 * (double)radius), (float)((double)z + z3 * (double)radius)).setColor(r, g, b, 0.5f);
                bufferSource.addVertex(matrix, (float)((double)x + x3 * (double)radius), (float)((double)y + y3 * (double)radius), (float)((double)z + z3 * (double)radius)).setColor(r, g, b, 0.5f);
                bufferSource.addVertex(matrix, (float)((double)x + x4 * (double)radius), (float)((double)y + y4 * (double)radius), (float)((double)z + z4 * (double)radius)).setColor(r, g, b, 0.5f);
                bufferSource.addVertex(matrix, (float)((double)x + x1 * (double)radius), (float)((double)y + y1 * (double)radius), (float)((double)z + z1 * (double)radius)).setColor(r, g, b, 0.5f);
            }
        }
    }

    public ContainerMenuShield getGuiContainer(Player var1) {
        return new ContainerMenuShield(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenShield((ContainerMenuShield)menu);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.shield;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == 0.0) {
            this.visibleLaser = true;
            new PacketUpdateFieldTile(this, "visibleLaser", this.visibleLaser);
        }
        if (var2 == 1.0) {
            this.visibleShield = true;
            new PacketUpdateFieldTile(this, "visibleShield", this.visibleShield);
        }
        if (var2 == -1.0) {
            this.visibleLaser = false;
            new PacketUpdateFieldTile(this, "visibleLaser", this.visibleLaser);
        }
        if (var2 == -2.0) {
            this.visibleShield = false;
            new PacketUpdateFieldTile(this, "visibleShield", this.visibleShield);
        }
        if (var2 == 2.0) {
            this.mode = 0;
            new PacketUpdateFieldTile(this, "mode", this.mode);
        }
        if (var2 == 3.0) {
            this.mode = 1;
            new PacketUpdateFieldTile(this, "mode", this.mode);
        }
    }
}

