/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuSaplingGardener;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenSaplingGardener;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntitySaplingGardener
extends BlockEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 4;
    public final Inventory slot;
    public final Energy energy;
    public final InventoryUpgrade upgradeSlot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    private final ComponentUpgradeSlots componentUpgrade;
    AABB searchArea;
    private ComponentVisibleArea visible;

    public BlockEntitySaplingGardener(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.sapling_gardener, pos, state);
        this.searchArea = new AABB(ModUtils.getVecFromVec3i((Vec3i)this.pos.offset(-4, -4, -4)), ModUtils.getVecFromVec3i((Vec3i)this.pos.offset(5, 5, 5)));
        this.slot = new Inventory(this, this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                return stack.getItem() instanceof BlockItem && ((BlockItem)stack.getItem()).getBlock() instanceof SaplingBlock;
            }
        };
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.sapling_gardener;
    }

    public ContainerMenuSaplingGardener getGuiContainer(Player var1) {
        return new ContainerMenuSaplingGardener(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenSaplingGardener((ContainerMenuSaplingGardener)menu);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().getGameTime() % 40L == 0L) {
            this.plantSaplingsInRadius();
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.sapling_gardener.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    private void plantSaplingsInRadius() {
        for (int x = -4; x <= 4; x += 2) {
            for (int z = -4; z <= 4; z += 2) {
                ItemStack saplingStack;
                BlockPos targetPos = this.pos.offset(x, 0, z);
                if (!this.canPlantSaplingAt(targetPos) || !this.energy.canUseEnergy(25.0) || (saplingStack = this.slot.get(0)).isEmpty()) continue;
                this.energy.useEnergy(25.0);
                this.plantSapling(targetPos, saplingStack);
                if (!(this.energy.getEnergy() < 25.0)) continue;
                return;
            }
        }
    }

    private boolean canPlantSaplingAt(BlockPos pos) {
        BlockState stateAt = this.level.getBlockState(pos);
        if (!stateAt.isAir()) {
            return false;
        }
        BlockState below = this.level.getBlockState(pos.below());
        Block blockBelow = below.getBlock();
        return blockBelow == Blocks.DIRT || blockBelow == Blocks.GRASS_BLOCK;
    }

    private void plantSapling(BlockPos targetPos, ItemStack saplingStack) {
        BlockItem blockItem;
        Block block;
        Item item = saplingStack.getItem();
        if (item instanceof BlockItem && (block = (blockItem = (BlockItem)item).getBlock()) instanceof SaplingBlock) {
            BlockState stateToPlace = block.defaultBlockState();
            this.level.setBlock(targetPos, stateToPlace, 3);
            saplingStack.shrink(1);
        }
    }
}

