/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuRadioactiveOreHandler;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.recipe.IInputHandler;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenRadioactiveOreHandler;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityRadioactiveOreHandler
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InventoryUpgrade upgradeSlot;
    public final ComponentUpgradeSlots componentUpgrade;
    public final ComponentProgress componentProgress;
    public final ComponentProcess componentProcess;
    public final InventoryRecipes inputSlotA;
    public final ComponentBaseEnergy componentRadiation;
    public final InventoryOutput outputSlot1;
    public MachineRecipe output;

    public BlockEntityRadioactiveOreHandler(BlockPos pos, BlockState state) {
        super(200.0, 1, 1, BlockBaseMachine3Entity.radioactive_handler_ore, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.outputSlot1 = new InventoryOutput(this, 1);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this, this.upgradeSlot){

            @Override
            public void onLoaded() {
                super.onLoaded();
                this.componentProcess = ((BlockEntityRadioactiveOreHandler)this.getParent()).componentProcess;
                this.energy = this.getParent().getComp(Energy.class);
                this.setOverclockRates(this.invSlot);
            }
        });
        this.addComponent(new SoilPollutionComponent(this, 0.25));
        this.addComponent(new AirPollutionComponent(this, 0.25));
        this.componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, 100));
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "radioactive_handler", (IUpdateTick)this);
        this.componentProcess = this.addComponent(new ComponentProcess(this, 200, 1.0){

            @Override
            public boolean checkRecipe() {
                return BlockEntityRadioactiveOreHandler.this.componentRadiation.getEnergy() + 1.0 < BlockEntityRadioactiveOreHandler.this.componentRadiation.getCapacity();
            }

            @Override
            protected int getRadiationSize(int size) {
                return (int)Math.min((double)size, BlockEntityRadioactiveOreHandler.this.componentRadiation.getCapacity() - BlockEntityRadioactiveOreHandler.this.componentRadiation.getEnergy());
            }

            @Override
            public boolean canAddItemStack() {
                return this.outputSlot.canAdd(this.updateTick.getRecipeOutput().getRecipe().getOutput().items.get(0));
            }

            @Override
            public void operateWithMax(MachineRecipe output) {
                if (output.getRecipe() == null) {
                    return;
                }
                int size = 64;
                List<Integer> list = this.updateTick.getRecipeOutput().getList();
                if (this.invSlotRecipes.getRecipe().workbench()) {
                    size = 1;
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        size = Math.min(size, this.invSlotRecipes.get(i).getCount() / list.get(i));
                    }
                }
                int maxSize = size;
                int count = this.outputSlot.get(0).isEmpty() ? output.getRecipe().output.items.get(0).getMaxStackSize() : this.outputSlot.get(0).getMaxStackSize() - this.outputSlot.get(0).getCount();
                ItemStack outputStack = this.updateTick.getRecipeOutput().getRecipe().output.items.get(0);
                size = Math.min(size, count /= Math.max(outputStack.getCount(), 1));
                size = Math.min(size, this.updateTick.getRecipeOutput().getRecipe().output.items.get(0).getMaxStackSize());
                if (this.updateTick.getRecipeOutput().getRecipe().input.getFluid() != null) {
                    int size1 = this.invSlotRecipes.getTank().getFluidAmount() / this.updateTick.getRecipeOutput().getRecipe().input.getFluid().getAmount();
                    size = Math.min(size, size1);
                }
                size = Math.min(size, this.operationsPerTick);
                size = Math.min(this.getSESize(size), this.getRadiationSize(size));
                this.invSlotRecipes.consume(size, output);
                this.outputSlot.add(output.getRecipe().getOutput().items.get(0), size);
                for (int i = 0; i < size; ++i) {
                    if (WorldBaseGen.random.nextInt(100) >= output.getRecipe().output.metadata.getInt("random")) continue;
                    BlockEntityRadioactiveOreHandler.this.outputSlot1.add(output.getRecipe().getOutput().items.get(1));
                }
                this.consumeSE(size);
                this.consumeRadiation(size);
                if (maxSize == size) {
                    this.updateTick.setRecipeOutput(null);
                }
            }

            @Override
            protected void consumeRadiation(int size) {
                BlockEntityRadioactiveOreHandler.this.componentRadiation.addEnergy(size);
            }

            @Override
            public boolean checkRadiation(boolean consume) {
                return true;
            }
        });
        this.componentRadiation = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.RADIATION, this, 2000.0));
        this.componentProcess.setHasAudio(false);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
    }

    public static void addRecipe(ItemStack container, ItemStack output, int random, ItemStack itemStack) {
        IInputHandler input = Recipes.inputFactory;
        CompoundTag nbt = ModUtils.nbt();
        nbt.putInt("random", random);
        Recipes.recipes.addRecipe("radioactive_handler", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(nbt, output, itemStack)));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerMenuRadioactiveOreHandler getGuiContainer(Player var1) {
        return new ContainerMenuRadioactiveOreHandler(var1, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenRadioactiveOreHandler((ContainerMenuRadioactiveOreHandler)menu);
    }

    @Override
    public void init() {
        BlockEntityRadioactiveOreHandler.addRecipe(new ItemStack((ItemLike)IUItem.classic_ore.getItem(3), 1), new ItemStack((ItemLike)IUItem.nuclear_res.getStack(21), 2), 5, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(16), 1));
        BlockEntityRadioactiveOreHandler.addRecipe(new ItemStack((ItemLike)IUItem.toriyore.getItem(), 1), new ItemStack((ItemLike)IUItem.nuclear_res.getStack(19), 1), 10, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(14), 4));
        BlockEntityRadioactiveOreHandler.addRecipe(new ItemStack((ItemLike)IUItem.radiationore.getItem(1), 1), new ItemStack((ItemLike)IUItem.nuclear_res.getStack(18), 1), 10, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(13), 4));
        BlockEntityRadioactiveOreHandler.addRecipe(new ItemStack((ItemLike)IUItem.radiationore.getItem(), 1), new ItemStack((ItemLike)IUItem.nuclear_res.getStack(17), 1), 10, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(15), 4));
        BlockEntityRadioactiveOreHandler.addRecipe(new ItemStack((ItemLike)IUItem.radiationore.getItem(2), 1), new ItemStack((ItemLike)IUItem.nuclear_res.getStack(20), 1), 20, new ItemStack((ItemLike)IUItem.nuclear_res.getStack(16), 4));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.radioactive_handler_ore;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

