/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.widget.IType;
import com.denfop.blockentity.base.BlockEntityElectricLiquidTankInventory;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuPump;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenPump;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockEntityPump
extends BlockEntityElectricLiquidTankInventory
implements IUpgradableBlock,
IType {
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final InventoryFluid containerSlot = new InventoryFluid(this, Inventory.TypeItemSlot.INPUT, 1, InventoryFluid.TypeFluidSlot.OUTPUT);
    public final InventoryOutput outputSlot = new InventoryOutput(this, 1);
    public final InventoryUpgrade upgradeSlot = new InventoryUpgrade(this, 4);
    public double energyConsume = 1.0;
    public int operationsPerTick;
    public int operationLength;
    public ComponentProgress componentProgress;

    public BlockEntityPump(int size, int operationLength, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super(20.0, 1, size, block, pos, state);
        this.defaultEnergyConsume = 1.0;
        this.defaultOperationLength = this.operationLength = operationLength;
        this.defaultTier = 1;
        this.defaultEnergyStorage = this.operationLength;
        this.componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, (short)operationLength));
        this.fluidTank.setTypeItemSlot(Inventory.TypeItemSlot.OUTPUT);
    }

    private static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round(((double)base + (double)extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    private static double applyModifier(double base, double extra, double multiplier) {
        return Math.round((base + extra) * multiplier);
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public void updateEntityServer() {
        MutableObject output;
        super.updateEntityServer();
        if (this.energy.canUseEnergy(this.energyConsume)) {
            if (this.componentProgress.getProgress() < this.componentProgress.getMaxValue()) {
                this.componentProgress.addProgress(0);
                this.energy.useEnergy(this.energyConsume);
            } else if (this.canoperate()) {
                this.componentProgress.setProgress((short)0);
            }
        }
        if (this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)(output = new MutableObject()), true) && (output.getValue() == null || this.outputSlot.canAdd((ItemStack)output.getValue()))) {
            this.containerSlot.transferFromTank((IFluidTank)this.fluidTank, (MutableObject<ItemStack>)output, false);
            if (output.getValue() != null) {
                this.outputSlot.add((ItemStack)output.getValue());
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setUpgradestat();
        }
    }

    public boolean canoperate() {
        return this.operate(true);
    }

    public boolean operate(boolean sim) {
        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
            return false;
        }
        boolean canOperate = false;
        for (int i = this.pos.getX() - 5; i <= this.pos.getX() + 5; ++i) {
            for (int j = this.pos.getZ() - 5; j <= this.pos.getZ() + 5; ++j) {
                for (int k = this.pos.getY() - 5; k <= this.pos.getY() + 5; ++k) {
                    for (Direction dir : Direction.values()) {
                        if (this.fluidTank.getFluidAmount() >= this.fluidTank.getCapacity()) {
                            return false;
                        }
                        FluidStack liquid = this.pump(new BlockPos(i + dir.getStepX(), k + dir.getStepY(), j + dir.getStepZ()), false);
                        if (this.getFluidTank().fill(liquid, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                        this.getFluidTank().fill(liquid, IFluidHandler.FluidAction.EXECUTE);
                        canOperate = true;
                    }
                }
            }
        }
        return canOperate;
    }

    public FluidStack pump(BlockPos pos, boolean sim) {
        BlockState block;
        FluidStack ret = FluidStack.EMPTY;
        int freespace = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        if (freespace >= 1000 && (block = this.getWorld().getBlockState(pos)).liquid()) {
            FluidState fluidState = block.getFluidState();
            if (!fluidState.isSource()) {
                return FluidStack.EMPTY;
            }
            ret = new FluidStack(fluidState.getType(), 1000);
            if ((this.fluidTank.getFluid().isEmpty() || this.fluidTank.getFluid().getFluid() == ret.getFluid()) && !sim) {
                this.getWorld().setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        return ret;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.setUpgradestat();
        }
    }

    public void setUpgradestat() {
        double previousProgress = this.componentProgress.getBar();
        double stackOpLen = ((double)this.defaultOperationLength + (double)this.upgradeSlot.extraProcessTime) * 64.0 * this.upgradeSlot.processTimeMultiplier;
        this.operationsPerTick = (int)Math.min(Math.ceil(64.0 / stackOpLen), 2.147483647E9);
        this.operationLength = (int)Math.round(stackOpLen * (double)this.operationsPerTick / 64.0);
        this.energyConsume = BlockEntityPump.applyModifier(this.defaultEnergyConsume, this.upgradeSlot.extraEnergyDemand, 1.0);
        this.energy.setSinkTier(BlockEntityPump.applyModifier(this.defaultTier, this.upgradeSlot.extraTier, 1.0));
        this.energy.setCapacity(BlockEntityPump.applyModifier(this.defaultEnergyStorage, this.upgradeSlot.extraEnergyStorage + (double)this.operationLength * this.energyConsume, this.upgradeSlot.energyStorageMultiplier));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
        this.componentProgress.setMaxValue((short)this.operationLength);
        this.componentProgress.setProgress((short)Math.floor(previousProgress * (double)this.operationLength + 0.1));
    }

    @Override
    public double getEnergy() {
        return this.energy.getEnergy();
    }

    @Override
    public boolean useEnergy(double amount) {
        if (this.energy.canUseEnergy(amount)) {
            this.energy.useEnergy(amount);
            return true;
        }
        return false;
    }

    public ContainerMenuPump getGuiContainer(Player entityPlayer) {
        return new ContainerMenuPump(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player entityPlayer, ContainerMenuBase<? extends CustomWorldContainer> isAdmin) {
        return new ScreenPump((ContainerMenuPump)isAdmin);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.FluidExtract);
    }

    @Override
    public EnumTypeStyle getStyle() {
        return null;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.PumpOp.getSoundEvent();
    }
}

