/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.primitive.EnumPrimitive;
import com.denfop.api.primitive.PrimitiveHandler;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockPrimalLaserPolisherEntity;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class BlockEntityPrimalLaserPolisher
extends BlockEntityInventory
implements IUpdateTick,
IHasRecipe {
    public final InventoryRecipes inputSlotA;
    public final InventoryOutput outputSlot;
    public int progress = 0;
    public MachineRecipe output;
    public int tick = 0;
    public Map<UUID, Double> data;
    ItemStack prevInput = ItemStack.EMPTY;
    ItemStack prevOutput = ItemStack.EMPTY;

    public BlockEntityPrimalLaserPolisher(BlockPos pos, BlockState state) {
        super(BlockPrimalLaserPolisherEntity.primal_laser_polisher, pos, state);
        this.inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "primal_laser_polisher", (IUpdateTick)this);
        this.outputSlot = new InventoryOutput(this, 1);
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        tooltip.add(Localization.translate("iu.primal_repair3"));
        tooltip.add(Localization.translate("iu.primal_repair6"));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.primalPolisher.getBlock();
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockPrimalLaserPolisherEntity.primal_laser_polisher;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.data = PrimitiveHandler.getPlayersData(EnumPrimitive.LASER);
        if (!this.getWorld().isClientSide) {
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        this.output = this.inputSlotA.process();
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.inputSlotA.readFromNbt((HolderLookup.Provider)is.registryAccess(), ((Inventory)DecoderHandler.decode(is)).writeToNbt((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot1")) {
            try {
                this.outputSlot.readFromNbt((HolderLookup.Provider)is.registryAccess(), ((Inventory)DecoderHandler.decode(is)).writeToNbt((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.inputSlotA.set(0, ItemStack.EMPTY);
        }
        if (name.equals("slot2")) {
            this.outputSlot.set(0, ItemStack.EMPTY);
        }
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.inputSlotA.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            this.outputSlot.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.prevInput.isEmpty() && !this.inputSlotA.isEmpty()) {
            this.prevInput = this.inputSlotA.get(0);
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
        }
        if (!this.prevInput.isEmpty() && !this.inputSlotA.isEmpty() && this.prevInput.getCount() != this.inputSlotA.get(0).getCount()) {
            this.prevInput = this.inputSlotA.get(0);
            new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
        }
        if (!this.prevInput.isEmpty() && this.inputSlotA.isEmpty()) {
            this.prevInput = ItemStack.EMPTY;
            new PacketUpdateFieldTile(this, "slot3", false);
        }
        if (this.prevOutput.isEmpty() && !this.outputSlot.isEmpty()) {
            this.prevOutput = this.outputSlot.get(0);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        if (this.prevOutput.isEmpty() && !this.outputSlot.isEmpty() && this.prevOutput.getCount() != this.outputSlot.get(0).getCount()) {
            this.prevOutput = this.outputSlot.get(0);
            new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
        }
        if (!this.prevOutput.isEmpty() && this.outputSlot.isEmpty()) {
            this.prevOutput = ItemStack.EMPTY;
            new PacketUpdateFieldTile(this, "slot2", false);
        }
        this.setActive(!this.inputSlotA.isEmpty());
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.inputSlotA);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 hitX) {
        ItemStack stack = player.getItemInHand(hand);
        if (stack.getItem() == IUItem.laser.getItem() && this.output != null && this.outputSlot.isEmpty() && this.getWorld().isDay()) {
            this.progress += (short)(5 + (short)(this.data.getOrDefault(player.getUUID(), 0.0) / 10.0));
            this.getCooldownTracker().setTick(10);
            if (this.progress >= 100) {
                this.progress = 0;
                player.setItemInHand(hand, stack.getItem().getCraftingRemainingItem(stack));
                if (!this.getWorld().isClientSide) {
                    PrimitiveHandler.addExperience(EnumPrimitive.LASER, 0.5, player.getUUID());
                }
                this.outputSlot.add(this.output.getRecipe().output.items.get(0));
                this.inputSlotA.consume(0, this.output.getRecipe().input.getInputs().get(0).getAmount());
                if (this.inputSlotA.isEmpty() || this.outputSlot.get(0).getCount() >= 64) {
                    this.output = null;
                }
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                    new PacketUpdateFieldTile(this, "slot1", this.outputSlot);
                }
            }
            return true;
        }
        if (!stack.isEmpty()) {
            if (this.inputSlotA.get(0).isEmpty() && this.inputSlotA.canPlaceItem(0, stack)) {
                ItemStack stack1 = stack.copy();
                stack1.setCount(1);
                this.inputSlotA.set(0, stack1);
                this.output = this.inputSlotA.process();
                stack.shrink(1);
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot", this.inputSlotA);
                }
                return true;
            }
            if (!this.outputSlot.isEmpty()) {
                if (!this.level.isClientSide) {
                    ModUtils.dropAsEntity(this.level, this.pos, this.outputSlot.get(0));
                }
                this.outputSlot.set(0, ItemStack.EMPTY);
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
        } else {
            if (!this.outputSlot.isEmpty()) {
                if (!this.level.isClientSide) {
                    ModUtils.dropAsEntity(this.level, this.pos, this.outputSlot.get(0));
                }
                this.outputSlot.set(0, ItemStack.EMPTY);
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot2", false);
                }
                return true;
            }
            if (!this.inputSlotA.isEmpty()) {
                if (!this.level.isClientSide) {
                    ModUtils.dropAsEntity(this.level, this.pos, this.inputSlotA.get(0));
                }
                this.inputSlotA.set(0, ItemStack.EMPTY);
                this.output = null;
                if (!this.level.isClientSide) {
                    new PacketUpdateFieldTile(this, "slot3", false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void init() {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(493)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.crafting_elements.getStack(495)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(0)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(0)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(1)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(1)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(2)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(2)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(3)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(3)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(4)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(6)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(5)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(7)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(6)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(8)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(7)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(9)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(8)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(10)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(9)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(11)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(10)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(12)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(10)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(12)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(11)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(14)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(12)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(15)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(13)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(16)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(14)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(17)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(15)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(18)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(16)))), new RecipeOutput(null, new ItemStack((ItemLike)Items.COPPER_INGOT))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(17)))), new RecipeOutput(null, new ItemStack((ItemLike)Items.GOLD_INGOT, 1))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(18)))), new RecipeOutput(null, new ItemStack((ItemLike)Items.IRON_INGOT, 1))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(19)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(22)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(20)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(24)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(22)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(25)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(23)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(26)))));
        Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(24)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(27)))));
        for (int i = 25; i < 40; ++i) {
            Recipes.recipes.addRecipe("primal_laser_polisher", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.rawIngot.getStack(i)))), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.iuingot.getStack(i + 3)))));
        }
    }
}

