/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.crop.CropNetwork;
import com.denfop.api.crop.ICropItem;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blockentity.crop.TileEntityCrop;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.client.ComponentVisibleArea;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuPlantGardener;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenPlantGardener;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityPlantGardener
extends BlockEntityInventory
implements IUpgradableBlock {
    private static final int RADIUS = 8;
    public final Energy energy;
    public final Inventory output;
    public final InventoryUpgrade upgradeSlot;
    private final ComponentUpgradeSlots componentUpgrade;
    private final ComponentVisibleArea visible;
    AABB searchArea;
    List<List<TileEntityCrop>> list;
    List<ChunkPos> chunks;

    public BlockEntityPlantGardener(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.plant_gardener, pos, state);
        this.searchArea = new AABB(ModUtils.getVecFromVec3i((Vec3i)this.pos.offset(-8, -8, -8)), ModUtils.getVecFromVec3i((Vec3i)this.pos.offset(9, 9, 9)));
        this.list = new ArrayList<List<TileEntityCrop>>();
        this.output = new Inventory(this, this, Inventory.TypeItemSlot.INPUT, 9){

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                return stack.getItem() instanceof ICropItem;
            }
        };
        this.energy = this.addComponent(Energy.asBasicSink((BlockEntityInventory)this, 1024.0, 4));
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.2));
        this.visible = this.addComponent(new ComponentVisibleArea(this));
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemInput);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.plant_gardener;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.plant_gardener.info"));
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.visible.aabb = this.searchArea;
        if (!this.getWorld().isClientSide) {
            AABB aabb = this.searchArea;
            int j2 = Mth.floor((double)((aabb.minX - 2.0) / 16.0));
            int k2 = Mth.ceil((double)((aabb.maxX + 2.0) / 16.0));
            int l2 = Mth.floor((double)((aabb.minZ - 2.0) / 16.0));
            int i3 = Mth.ceil((double)((aabb.maxZ + 2.0) / 16.0));
            this.chunks = new ArrayList<ChunkPos>();
            for (int j3 = j2; j3 < k2; ++j3) {
                for (int k3 = l2; k3 < i3; ++k3) {
                    LevelChunk chunk = this.level.getChunk(j3, k3);
                    if (this.chunks.contains(chunk.getPos())) continue;
                    this.chunks.add(chunk.getPos());
                }
            }
            for (ChunkPos chunk : this.chunks) {
                this.list.add(CropNetwork.instance.getCropsFromChunk(this.level, chunk));
            }
        }
    }

    public ContainerMenuPlantGardener getGuiContainer(Player var1) {
        return new ContainerMenuPlantGardener(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenPlantGardener((ContainerMenuPlantGardener)menu);
    }

    public boolean contains(BlockPos vec) {
        if ((double)vec.getX() > this.searchArea.minX && (double)vec.getX() < this.searchArea.maxX) {
            if ((double)vec.getY() > this.searchArea.minY && (double)vec.getY() < this.searchArea.maxY) {
                return (double)vec.getZ() > this.searchArea.minZ && (double)vec.getZ() < this.searchArea.maxZ;
            }
            return false;
        }
        return false;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.getWorld().getGameTime() % 100L == 0L) {
            this.updateCrop();
        }
        if (this.getWorld().getGameTime() % 20L == 0L && this.energy.canUseEnergy(10.0)) {
            block0: for (List<TileEntityCrop> crops : this.list) {
                for (TileEntityCrop crop : crops) {
                    if (!(this.energy.getEnergy() > 10.0)) break block0;
                    if (!this.contains(crop.getPos())) continue;
                    for (ItemStack stack : this.output) {
                        if (stack.isEmpty() || crop.getCrop() != null || crop.isHasDouble() || !CropNetwork.instance.canPlantCrop(stack, this.level, this.pos, crop.getDownState(), crop.getBiome())) continue;
                        crop.plantNewCrop(stack);
                        this.energy.useEnergy(10.0);
                    }
                }
            }
        }
    }

    private void updateCrop() {
        this.list.clear();
        for (ChunkPos chunk : this.chunks) {
            this.list.add(CropNetwork.instance.getCropsFromChunk(this.level, chunk));
        }
    }
}

