/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.InventoryOutput;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockMiniSmelteryEntity;
import com.denfop.componets.Fluids;
import com.denfop.events.client.GlobalRenderManager;
import com.denfop.inventory.Inventory;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.render.mini_smeltery.RenderMiniSmeltery;
import com.denfop.utils.Localization;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class BlockEntityMiniSmeltery
extends BlockEntityInventory
implements IHasRecipe {
    public final FluidHandlerRecipe fluid_handler;
    public final Fluids.InternalFluidTank fluidTank1;
    public InventoryOutput outputSlot;
    protected short progress = 0;
    private int amount;

    public BlockEntityMiniSmeltery(BlockPos pos, BlockState blockState) {
        super(BlockMiniSmelteryEntity.mini_smeltery, pos, blockState);
        Fluids fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = fluids.addTankInsert("fluidTank1", 2304);
        this.outputSlot = new InventoryOutput(this, 1);
        this.fluid_handler = new FluidHandlerRecipe("mini_smeltery", fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(0)));
        Recipes.recipes.getRecipeFluid().addInitRecipes(this);
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        for (int i = 1; i < 4; ++i) {
            tooltip.add(Localization.translate("mini_smeltery.info" + i));
        }
    }

    @Override
    public List<AABB> getAabbs(boolean forCollision) {
        return Collections.singletonList(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    public void init() {
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenmikhail.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(0)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenaluminium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(1)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenvanadium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(2)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltentungsten.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(3)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltencobalt.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(4)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenmagnesium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(5)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltennickel.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(6)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenplatinum.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(7)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltentitanium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(8)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenchromium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(9)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenspinel.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(10)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltensilver.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(11)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenzinc.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(12)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenmanganese.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(13)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmolteniridium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(14)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltengermanium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(15)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltencopper.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(16)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltengold.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(17)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmolteniron.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(18)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenlead.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(19)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltentin.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(20)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenosmium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(22)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltentantalum.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(23)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltencadmium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(24)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenarsenic.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(25)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenbarium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(26)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenbismuth.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(27)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltengadolinium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(28)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltengallium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(29)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenhafnium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(30)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenyttrium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(31)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenmolybdenum.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(32)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenneodymium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(33)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenniobium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(34)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenpalladium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(35)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenpolonium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(36)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenstrontium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(37)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenthallium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(38)))));
        Recipes.recipes.getRecipeFluid().addRecipe("mini_smeltery", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmoltenzirconium.getInstance().get(), 144)), new RecipeOutput(null, new ItemStack((ItemLike)IUItem.rawIngot.getStack(39)))));
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.getShort("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putShort("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide()) {
            this.fluid_handler.load();
            new PacketUpdateFieldTile(this, "slot", this.outputSlot);
            new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
        }
        if (this.getWorld().isClientSide) {
            GlobalRenderManager.addRender(this.level, this.worldPosition, this.createFunction(this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public Function<RenderLevelStageEvent, Void> createFunction(BlockEntityMiniSmeltery te) {
        Function<RenderLevelStageEvent, Void> function = o -> {
            o.getPoseStack().pushPose();
            o.getPoseStack().translate((float)te.getPos().getX(), (float)te.getPos().getY(), (float)te.getPos().getZ());
            RenderMiniSmeltery.render(te, o);
            o.getPoseStack().popPose();
            return null;
        };
        return function;
    }

    @Override
    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = super.writePacket();
        try {
            EncoderHandler.encode(customPacketBuffer, this.outputSlot);
            EncoderHandler.encode(customPacketBuffer, (Object)this.fluidTank1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.level.isClientSide) {
            return true;
        }
        if (!this.getWorld().isClientSide && player.getItemInHand(hand).getCapability(Capabilities.FluidHandler.ITEM, null) != null && this.fluidTank1.getFluidAmount() + 1000 <= this.fluidTank1.getCapacity()) {
            ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.getComp(Fluids.class).getCapability(Capabilities.FluidHandler.BLOCK, side));
            if (!this.level.isClientSide) {
                new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
            }
            return true;
        }
        if (!this.outputSlot.isEmpty()) {
            if (!this.level.isClientSide) {
                ModUtils.dropAsEntity(this.level, this.pos, this.outputSlot.get(0));
            }
            this.outputSlot.set(0, ItemStack.EMPTY);
            if (!this.level.isClientSide) {
                new PacketUpdateFieldTile(this, "slot3", false);
            }
            return true;
        }
        return true;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer) {
        super.readPacket(customPacketBuffer);
        try {
            this.outputSlot.readFromNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), ((Inventory)DecoderHandler.decode(customPacketBuffer)).writeToNbt((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank1 != null) {
                this.fluidTank1.readFromNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), fluidTank1.writeToNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        if (this.getWorld().isClientSide) {
            GlobalRenderManager.removeRender(this.level, this.worldPosition);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.amount != this.fluidTank1.getFluidAmount()) {
            this.amount = this.fluidTank1.getFluidAmount();
            new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
        }
        if (this.fluid_handler.output() == null && this.fluidTank1.getFluidAmount() >= 1) {
            this.fluid_handler.getOutput();
        } else if (this.fluid_handler.output() != null && !this.fluid_handler.checkFluids()) {
            this.fluid_handler.setOutput(null);
        }
        if (this.fluid_handler.output() != null && this.outputSlot.isEmpty() && this.outputSlot.canAdd(this.fluid_handler.output().getOutput().items) && this.fluid_handler.canOperate()) {
            this.progress = (short)(this.progress + 2);
            double k = this.progress;
            if (this.progress >= 100) {
                this.operate();
                new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
                new PacketUpdateFieldTile(this, "slot", this.outputSlot);
                this.progress = 0;
            }
        } else if (this.fluid_handler.output() == null) {
            this.progress = 0;
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("slot")) {
            try {
                this.outputSlot.readFromNbt((HolderLookup.Provider)is.registryAccess(), ((Inventory)DecoderHandler.decode(is)).writeToNbt((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("fluidtank")) {
            try {
                FluidTank fluidTank1 = (FluidTank)DecoderHandler.decode(is);
                if (fluidTank1 != null) {
                    this.fluidTank1.readFromNBT((HolderLookup.Provider)is.registryAccess(), fluidTank1.writeToNBT((HolderLookup.Provider)is.registryAccess(), new CompoundTag()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        if (name.equals("slot3")) {
            this.outputSlot.set(0, ItemStack.EMPTY);
        }
    }

    public void operate() {
        for (int i = 0; i < 1; ++i) {
            this.operateOnce();
            this.fluid_handler.checkOutput();
            if (this.fluid_handler.output() == null) break;
        }
    }

    public void operateOnce() {
        this.fluid_handler.consume();
        this.outputSlot.add(this.fluid_handler.output().getOutput().items);
        new PacketUpdateFieldTile(this, "slot", this.outputSlot);
        new PacketUpdateFieldTile(this, "fluidtank", (Object)this.fluidTank1);
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockMiniSmelteryEntity.mini_smeltery;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.mini_smeltery.getBlock();
    }
}

