/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.bee.genetics.GeneticTraits;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.bee.genetics.GenomeItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.crop.ICropItem;
import com.denfop.api.crop.genetics.IGenomeItem;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.sound.AudioFixer;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuInoculator;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.items.bee.ItemJarBees;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.recipe.IInputHandler;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.screen.ScreenInoculator;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityInoculator
extends BlockEntityElectricMachine
implements IHasRecipe,
AudioFixer,
IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent {
    public final InventoryRecipes inputSlotA;
    public final InventoryUpgrade upgradeSlot;
    public ComponentUpgradeSlots componentUpgrade;
    public ComponentProgress componentProgress;
    public ComponentProcess componentProcess;
    public MachineRecipe output;

    public BlockEntityInoculator(BlockPos pos, BlockState state) {
        super(300.0, 1, 1, BlockBaseMachine3Entity.inoculator, pos, state);
        Recipes.recipes.addInitRecipes(this);
        this.inputSlotA = new InventoryRecipes(this, this, "inoculator", this){

            @Override
            public boolean canPlaceItem(int index, ItemStack itemStack) {
                return itemStack.getItem() instanceof ICropItem || itemStack.getItem() instanceof GenomeItem || itemStack.getItem() instanceof IGenomeItem || itemStack.getItem() == IUItem.jarBees.getStack(0);
            }
        };
        this.inputSlotA.setStackSizeLimit(1);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this, this.upgradeSlot){

            @Override
            public void onLoaded() {
                super.onLoaded();
                this.componentProcess = ((BlockEntityInoculator)this.getParent()).componentProcess;
            }
        });
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.25));
        this.componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, 300));
        this.componentProcess = this.addComponent(new ComponentProcess(this, 300, 1.0){

            @Override
            public void operateWithMax(MachineRecipe output, int size) {
                this.operateWithMax(output);
            }

            @Override
            public boolean checkRecipe() {
                ItemStack genome;
                if (BlockEntityInoculator.this.output == null) {
                    return false;
                }
                ItemStack stack1 = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(0) : this.invSlotRecipes.get(1);
                ItemStack itemStack = genome = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(1) : this.invSlotRecipes.get(0);
                if (this.isCrop(stack1)) {
                    com.denfop.api.crop.genetics.Genome genome1 = new com.denfop.api.crop.genetics.Genome(stack1);
                    IGenomeItem genomeItem = (IGenomeItem)genome.getItem();
                    com.denfop.api.crop.genetics.GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    return !genome1.hasGenome(genomeTraits.getGenetic());
                }
                if (this.isBee(stack1)) {
                    Genome genome1 = new Genome(stack1);
                    GenomeItem genomeItem = (GenomeItem)genome.getItem();
                    GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    return !genome1.hasGenome(genomeTraits.getGenetic());
                }
                return false;
            }

            public boolean isCrop(ItemStack stack) {
                return stack.getItem() instanceof ICropItem;
            }

            public boolean isBee(ItemStack stack) {
                return stack.getItem() instanceof ItemJarBees;
            }

            @Override
            public void operateWithMax(MachineRecipe output) {
                ItemStack stack1 = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(0) : this.invSlotRecipes.get(1);
                ItemStack genome = this.isCrop(this.invSlotRecipes.get(0)) || this.isBee(this.invSlotRecipes.get(0)) ? this.invSlotRecipes.get(1) : this.invSlotRecipes.get(0);
                stack1 = stack1.copy();
                stack1.setCount(1);
                if (this.isCrop(stack1)) {
                    IGenomeItem genomeItem = (IGenomeItem)genome.getItem();
                    com.denfop.api.crop.genetics.Genome genome1 = new com.denfop.api.crop.genetics.Genome(stack1);
                    com.denfop.api.crop.genetics.GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    genome1.addGenome(genomeTraits, stack1);
                    ItemStack outputStack = genome1.getStack().copy();
                    this.invSlotRecipes.consume();
                    this.outputSlot.add(outputStack);
                } else if (this.isBee(stack1)) {
                    GenomeItem genomeItem = (GenomeItem)genome.getItem();
                    Genome genome1 = new Genome(stack1);
                    GeneticTraits genomeTraits = genomeItem.getGenomeTraits(genome);
                    genome1.addGenome(genomeTraits);
                    ItemStack outputStack = genome1.getStack().copy();
                    this.invSlotRecipes.consume();
                    this.outputSlot.add(outputStack);
                }
            }
        });
        this.componentProcess.setHasAudio(true);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
    }

    public static void addRecipe(ItemStack container, ItemStack output) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("inoculator", new BaseMachineRecipe(new Input(input.getInput(container), input.getInput(output)), new RecipeOutput(null, container)));
    }

    @Override
    public void init() {
        ItemStack input;
        int i;
        for (i = 0; i < 82; ++i) {
            if (i == 3) continue;
            input = new ItemStack((ItemLike)IUItem.crops.getStack(0));
            input.set(DataComponentsInit.CROP, (Object)i);
            for (Enum enum_ : com.denfop.api.crop.genetics.GeneticTraits.values()) {
                BlockEntityInoculator.addRecipe(input, new ItemStack((ItemLike)IUItem.genome_crop.getStack(enum_.ordinal()), 1));
            }
        }
        for (i = 1; i < 6; ++i) {
            input = IUItem.jarBees.getStack(0).getStackFromId(i);
            for (Enum enum_ : GeneticTraits.values()) {
                BlockEntityInoculator.addRecipe(input, new ItemStack((ItemLike)IUItem.genome_bee.getStack(enum_.ordinal()), 1));
            }
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.inoculator;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenInoculator((ContainerMenuInoculator)menu);
    }

    public ContainerMenuInoculator getGuiContainer(Player var1) {
        return new ContainerMenuInoculator(var1, this);
    }

    public float getWrenchDropRate() {
        return 0.85f;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }
}

