/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.FluidHandlerRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.Fluids;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuGasCombiner;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryFluid;
import com.denfop.inventory.InventoryFluidByList;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenGasCombiner;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.sound.EnumSound;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockEntityGasCombiner
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IHasRecipe {
    public final FluidHandlerRecipe fluid_handler;
    public final Fluids.InternalFluidTank fluidTank2;
    public final Fluids.InternalFluidTank fluidTank1;
    public final InventoryFluidByList fluidSlot1;
    public final InventoryFluidByList fluidSlot2;
    public final Fluids.InternalFluidTank fluidTank3;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final InventoryUpgrade upgradeSlot;
    public final InventoryFluidByList fluidSlot3;
    public double energyConsume = 1.0;
    public int operationLength = 100;
    public int operationsPerTick;
    protected short progress = 0;
    protected double guiProgress;

    public BlockEntityGasCombiner(BlockPos pos, BlockState state) {
        super(100.0, 1, 3, BlockBaseMachine3Entity.gas_combiner, pos, state);
        this.defaultEnergyConsume = 1.0;
        this.defaultOperationLength = 100;
        this.defaultTier = 1;
        this.defaultEnergyStorage = 100.0;
        Fluids fluids = this.addComponent(new Fluids(this));
        this.fluidTank1 = fluids.addTankInsert("fluidTank1", 12000);
        this.fluidTank2 = fluids.addTankInsert("fluidTank2", 12000);
        this.fluidTank3 = fluids.addTank("fluidTank3", 12000, Inventory.TypeItemSlot.OUTPUT);
        this.fluid_handler = new FluidHandlerRecipe("gas_combiner", fluids);
        this.fluidTank1.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(0)));
        this.fluidTank2.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getFluids(1)));
        this.fluidTank3.setAcceptedFluids(Fluids.fluidPredicate(this.fluid_handler.getOutputFluids(0)));
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.fluidSlot1 = new InventoryFluidByList((BlockEntityInventory)this, 1, this.fluid_handler.getFluids(0));
        this.fluidSlot2 = new InventoryFluidByList((BlockEntityInventory)this, 1, this.fluid_handler.getFluids(1));
        this.fluidSlot3 = new InventoryFluidByList((BlockEntityInventory)this, 1, this.fluid_handler.getOutputFluids(0));
        this.fluidSlot3.setTypeFluidSlot(InventoryFluid.TypeFluidSlot.OUTPUT);
        Recipes.recipes.getRecipeFluid().addInitRecipes(this);
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.2));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.2));
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.air_collector.getSoundEvent();
    }

    @Override
    public void init() {
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidcreosote.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidpetroleum.getInstance().get(), 1000)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidindustrialoil.getInstance().get(), 1000))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidcreosote.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidsweet_medium_oil.getInstance().get(), 800)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidindustrialoil.getInstance().get(), 1000))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidcreosote.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidsweet_heavy_oil.getInstance().get(), 600)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidindustrialoil.getInstance().get(), 1000))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidcreosote.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidsour_light_oil.getInstance().get(), 1100)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidindustrialoil.getInstance().get(), 1000))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidcreosote.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidsour_medium_oil.getInstance().get(), 1300)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidindustrialoil.getInstance().get(), 1000))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidfluor.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 1000)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidfluorhyd.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidcreosote.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidsour_heavy_oil.getInstance().get(), 1500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidindustrialoil.getInstance().get(), 1000))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidbiomass.getInstance().get(), 500), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.WATER, 500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidglucose.getInstance().get(), 1000))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidpropane.getInstance().get(), 400), new FluidStack((Fluid)FluidName.fluidbromine.getInstance().get(), 800)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluiddibromopropane.getInstance().get(), 400))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidacetylene.getInstance().get(), 400), new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 1000)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidethylene.getInstance().get(), 400))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidhydrogensulfide.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), 300)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidsulfuroxide.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidsulfuroxide.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), 100)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidsulfurtrioxide.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidsulfurtrioxide.getInstance().get(), 500), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.WATER, 500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidsulfuricacid.getInstance().get(), 500))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidnitrogen.getInstance().get(), 100), new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 300)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidnitrogenhydride.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidnitrogenoxy.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidoxygen.getInstance().get(), 100)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidnitrogendioxide.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidnitrogendioxide.getInstance().get(), 400), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.WATER, 300)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidnitricacid.getInstance().get(), 400))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidtoluene.getInstance().get(), 400), new FluidStack((Fluid)FluidName.fluidnitricacid.getInstance().get(), 600)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidtrinitrotoluene.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidethylene.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 200)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidethane.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidethylene.getInstance().get(), 200), new FluidStack((Fluid)net.minecraft.world.level.material.Fluids.WATER, 200)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidethanol.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidpolybutadiene.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidpolyacrylonitrile.getInstance().get(), 200)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidbutadiene_nitrile.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidethylene.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidhydrogenchloride.getInstance().get(), 200)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidchloroethane.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidchlorum.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 200)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidhydrogenchloride.getInstance().get(), 400))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidgasoline.getInstance().get(), 500), new FluidStack((Fluid)FluidName.fluidtetraethyllead.getInstance().get(), 500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidpetrol90.getInstance().get(), 500))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidpetrol90.getInstance().get(), 500), new FluidStack((Fluid)FluidName.fluidtetraethyllead.getInstance().get(), 500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidpetrol95.getInstance().get(), 500))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidcarbonmonoxide.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 400)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidmethanol.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidbutadiene.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 200)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidbutene.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidbutene.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidsulfuricacid.getInstance().get(), 200)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidtertbutylsulfuricacid.getInstance().get(), 200))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidisobutylene.getInstance().get(), 200), new FluidStack((Fluid)FluidName.fluidmethanol.getInstance().get(), 100)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidtertbutylmethylether.getInstance().get(), 100))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidpetrol95.getInstance().get(), 500), new FluidStack((Fluid)FluidName.fluidtertbutylmethylether.getInstance().get(), 500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidpetrol100.getInstance().get(), 500))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidpetrol100.getInstance().get(), 500), new FluidStack((Fluid)FluidName.fluidtertbutylmethylether.getInstance().get(), 500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidpetrol105.getInstance().get(), 500))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmethylpentanal.getInstance().get(), 500), new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 1000)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidethylhexanol.getInstance().get(), 500))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmethylcyclohexylnitrate.getInstance().get(), 500), new FluidStack((Fluid)FluidName.fluiddiesel.getInstance().get(), 500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluida_diesel.getInstance().get(), 500))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidmethylcyclohexylnitrate.getInstance().get(), 500), new FluidStack((Fluid)FluidName.fluida_diesel.getInstance().get(), 500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidaa_diesel.getInstance().get(), 500))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidbenzene.getInstance().get(), 300), new FluidStack((Fluid)FluidName.fluidhydrogen.getInstance().get(), 900)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidcyclohexane.getInstance().get(), 300))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidcyclohexane.getInstance().get(), 300), new FluidStack((Fluid)FluidName.fluidnitricacid.getInstance().get(), 300)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidmethylcyclohexylnitrate.getInstance().get(), 300))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidethylhexylnitrate.getInstance().get(), 500), new FluidStack((Fluid)FluidName.fluidaa_diesel.getInstance().get(), 500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidaaa_diesel.getInstance().get(), 500))));
        Recipes.recipes.getRecipeFluid().addRecipe("gas_combiner", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(new FluidStack((Fluid)FluidName.fluidethylhexylnitrate.getInstance().get(), 500), new FluidStack((Fluid)FluidName.fluidaaa_diesel.getInstance().get(), 500)), Collections.singletonList(new FluidStack((Fluid)FluidName.fluidaaaa_diesel.getInstance().get(), 500))));
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.getShort("progress");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putShort("progress", this.progress);
        return nbttagcompound;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip);
    }

    public double getProgress() {
        return this.guiProgress;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide) {
            this.setOverclockRates();
            this.fluid_handler.load();
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MutableObject output1 = new MutableObject();
        boolean check = false;
        if (this.fluidTank1.getFluidAmount() + 1000 <= this.fluidTank1.getCapacity() && this.fluidSlot1.transferToTank((IFluidTank)this.fluidTank1, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot1.transferToTank((IFluidTank)this.fluidTank1, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
            check = true;
        }
        if (this.fluidTank2.getFluidAmount() + 1000 <= this.fluidTank2.getCapacity() && this.fluidSlot2.transferToTank((IFluidTank)this.fluidTank2, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot2.transferToTank((IFluidTank)this.fluidTank2, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
            check = true;
        }
        if (this.fluidTank3.getFluidAmount() - 1000 >= 0 && this.fluidSlot3.transferFromTank((IFluidTank)this.fluidTank3, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.outputSlot.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot3.transferFromTank((IFluidTank)this.fluidTank3, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.outputSlot.add((ItemStack)output1.getValue());
            }
        }
        if (check || this.fluid_handler.output() == null && this.fluidTank2.getFluidAmount() >= 1 && this.fluidTank1.getFluidAmount() >= 1) {
            this.fluid_handler.getOutput();
        } else if (this.fluid_handler.output() != null && !this.fluid_handler.checkFluids()) {
            this.fluid_handler.setOutput(null);
        }
        if (this.fluid_handler.output() != null && this.fluid_handler.canOperate() && this.fluid_handler.canFillFluid() && this.energy.canUseEnergy(this.energyConsume)) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            if (this.progress == 0) {
                this.initiate(0);
            }
            this.progress = (short)(this.progress + 1);
            this.energy.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate();
                this.progress = 0;
                this.initiate(2);
            }
        } else {
            if (this.progress != 0 && this.getActive()) {
                this.initiate(0);
            }
            if (this.fluid_handler.output() == null) {
                this.progress = 0;
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
        int tier = this.upgradeSlot.getTier(this.defaultTier);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(this.defaultEnergyStorage));
        if (this.operationLength < 1) {
            this.operationLength = 1;
        }
    }

    public void operate() {
        for (int i = 0; i < this.operationsPerTick; ++i) {
            this.operateOnce();
            this.fluid_handler.checkOutput();
            if (this.fluid_handler.output() == null) break;
        }
    }

    public void operateOnce() {
        this.fluid_handler.consume();
        this.fluid_handler.fillFluid();
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.gas_combiner;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public ContainerMenuGasCombiner getGuiContainer(Player entityPlayer) {
        return new ContainerMenuGasCombiner(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenGasCombiner((ContainerMenuGasCombiner)menu);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.FluidExtract, UpgradableProperty.FluidInput);
    }
}

