/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.widget.EnumTypeSlot;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.componets.TypeUpgrade;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuCentrifuge;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputHandler;
import com.denfop.screen.ScreenCentrifuge;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityCentrifuge
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent,
IHasRecipe {
    public final InventoryUpgrade upgradeSlot = new InventoryUpgrade(this, 4);
    public final ComponentUpgradeSlots componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this, this.upgradeSlot){

        @Override
        public void onLoaded() {
            super.onLoaded();
            this.componentProcess = ((BlockEntityCentrifuge)this.parent).componentProcess;
        }
    });
    public final ComponentProgress componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, 100));
    public final ComponentProcess componentProcess;
    public final InventoryRecipes inputSlotA = new InventoryRecipes((BlockEntityInventory)this, "genetic_centrifuge", (IUpdateTick)this);
    public final ComponentUpgrade componentUpgrades;
    public final Inventory input_slot;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public MachineRecipe output;
    public short rpm = 0;

    public BlockEntityCentrifuge(BlockPos pos, BlockState state) {
        super(200.0, 1, 1, BlockBaseMachine3Entity.centrifuge, pos, state);
        this.componentProcess = this.addComponent(new ComponentProcess(this, 200, 1.0){

            @Override
            public boolean checkRecipe() {
                if (BlockEntityCentrifuge.this.rpm < 120) {
                    BlockEntityCentrifuge.this.rpm = (short)(BlockEntityCentrifuge.this.rpm + 1);
                }
                return BlockEntityCentrifuge.this.rpm == 120;
            }

            @Override
            public void onFailedProcess() {
                super.onFailedProcess();
                if (BlockEntityCentrifuge.this.rpm > 0 && BlockEntityCentrifuge.this.output == null) {
                    BlockEntityCentrifuge.this.rpm = (short)(BlockEntityCentrifuge.this.rpm - 1);
                }
            }
        });
        this.componentProcess.setHasAudio(false);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.1));
        this.input_slot = new Inventory(this, this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (this.get(0).isEmpty()) {
                    ((BlockEntityCentrifuge)this.base).inputSlotA.changeAccepts(ItemStack.EMPTY);
                } else {
                    ((BlockEntityCentrifuge)this.base).inputSlotA.changeAccepts(this.get(0));
                }
                return content;
            }

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                return stack.getItem() == IUItem.recipe_schedule.getItem();
            }

            @Override
            public EnumTypeSlot getTypeSlot() {
                return EnumTypeSlot.RECIPE_SCHEDULE;
            }
        };
        Recipes.recipes.addInitRecipes(this);
    }

    public static void addRecipe(int container, ItemStack output) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("genetic_centrifuge", new BaseMachineRecipe(new Input(input.getInput(new ItemStack((ItemLike)IUItem.crafting_elements.getStack(container), 4))), new RecipeOutput(null, output)));
    }

    public static void addRecipe(ItemStack container, ItemStack output) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("genetic_centrifuge", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(null, output)));
    }

    public static void addRecipe(String container, ItemStack output) {
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("genetic_centrifuge", new BaseMachineRecipe(new Input(input.getInput(container)), new RecipeOutput(null, output)));
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.rpm = customPacketBuffer.readShort();
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeShort(this.rpm);
        return customPacketBuffer;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerMenuCentrifuge getGuiContainer(Player var1) {
        return new ContainerMenuCentrifuge(var1, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenCentrifuge((ContainerMenuCentrifuge)menu);
    }

    @Override
    public void init() {
        BlockEntityCentrifuge.addRecipe(new ItemStack((ItemLike)IUItem.honeycomb.getItem()), new ItemStack((ItemLike)IUItem.honey_drop.getItem()));
        BlockEntityCentrifuge.addRecipe(new ItemStack((ItemLike)IUItem.beeswax.getItem()), new ItemStack((ItemLike)IUItem.bee_pollen.getItem()));
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.centrifuge;
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide) {
            this.inputSlotA.load();
            this.getOutput();
            if (this.input_slot.isEmpty()) {
                this.inputSlotA.changeAccepts(ItemStack.EMPTY);
            } else {
                this.inputSlotA.changeAccepts(this.input_slot.get(0));
            }
        }
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

