/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InventoryRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.containermenu.ContainerMenuAdditionGenStone;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenAdditionGenStone;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public abstract class BlockEntityBaseAdditionGenStone
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IUpdateTick,
IUpdatableTileEvent {
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    public final InventoryUpgrade upgradeSlot;
    public final ItemStack diorite;
    public final ItemStack andesite;
    public final ItemStack granite;
    public double energyConsume;
    public Mode mode;
    public int operationLength;
    public int operationsPerTick;
    public InventoryRecipes inputSlotA;
    public MachineRecipe output;
    protected short progress = 0;
    protected double guiProgress;

    public BlockEntityBaseAdditionGenStone(int energyPerTick, int length, int outputSlots, MultiBlockEntity block, BlockPos pos, BlockState state) {
        this(energyPerTick, length, outputSlots, 1, block, pos, state);
    }

    public BlockEntityBaseAdditionGenStone(int energyPerTick, int length, int outputSlots, int aDefaultTier, MultiBlockEntity block, BlockPos pos, BlockState state) {
        super((double)energyPerTick * (double)length, 1, outputSlots, block, pos, state);
        this.defaultEnergyConsume = this.energyConsume = (double)energyPerTick;
        this.defaultOperationLength = this.operationLength = length;
        this.defaultTier = aDefaultTier;
        this.defaultEnergyStorage = energyPerTick * length;
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.output = null;
        this.mode = Mode.GRANITE;
        this.granite = new ItemStack((ItemLike)Blocks.GRANITE, 1);
        this.diorite = new ItemStack((ItemLike)Blocks.DIORITE, 1);
        this.andesite = new ItemStack((ItemLike)Blocks.ANDESITE, 1);
    }

    public static int applyModifier(int base, int extra, double multiplier) {
        double ret = Math.round((double)(base + extra) * multiplier);
        return ret > 2.147483647E9 ? Integer.MAX_VALUE : (int)ret;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.progress = nbttagcompound.getShort("progress");
        this.mode = Mode.values()[nbttagcompound.getInt("mode")];
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.guiProgress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.mode = Mode.values()[(Integer)DecoderHandler.decode(customPacketBuffer)];
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.guiProgress);
            EncoderHandler.encode(packet, (Object)this.mode);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenAdditionGenStone((ContainerMenuAdditionGenStone)menu);
    }

    public String getStartSoundFile() {
        return "Machines/gen_cobblectone.ogg";
    }

    public String getInterruptSoundFile() {
        return "Machines/InterruptOne.ogg";
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract);
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.defaultEnergyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.defaultOperationLength);
        }
        super.addInformation(stack, tooltip);
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putShort("progress", this.progress);
        nbttagcompound.putInt("mode", this.mode.ordinal());
        return nbttagcompound;
    }

    public double getProgress() {
        return this.guiProgress;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide) {
            this.setOverclockRates();
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        MachineRecipe output = this.output;
        if (output != null && this.canAdd() && this.energy.getEnergy() >= this.energyConsume) {
            if (!this.getActive()) {
                this.setActive(true);
                if ((double)this.operationLength > (double)this.defaultOperationLength * 0.1) {
                    this.initiate(0);
                }
            }
            this.progress = (short)(this.progress + 1);
            this.energy.useEnergy(this.energyConsume);
            double k = this.progress;
            this.guiProgress = k / (double)this.operationLength;
            if (this.progress >= this.operationLength) {
                this.guiProgress = 0.0;
                this.operate(output);
                this.progress = 0;
                if ((double)this.operationLength > (double)this.defaultOperationLength * 0.1 || this.getTypeAudio() != this.valuesAudio[2 % this.valuesAudio.length]) {
                    this.initiate(2);
                }
            }
        } else {
            if (output == null && this.getActive()) {
                this.progress = 0;
                if ((double)this.operationLength > (double)this.defaultOperationLength * 0.1 || this.getTypeAudio() != this.valuesAudio[1 % this.valuesAudio.length]) {
                    this.initiate(1);
                }
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
    }

    private boolean canAdd() {
        switch (this.getMode().ordinal()) {
            default: {
                return this.outputSlot.canAdd(this.output.getRecipe().output.items);
            }
            case 1: {
                return this.outputSlot.canAdd(this.diorite);
            }
            case 2: 
        }
        return this.outputSlot.canAdd(this.andesite);
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.operationLength = this.upgradeSlot.getOperationLength(this.defaultOperationLength);
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
        int tier = this.upgradeSlot.getTier(this.defaultTier);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(this.defaultEnergyStorage));
        this.operationsPerTick = Math.min(1, this.operationsPerTick);
        this.dischargeSlot.setTier(tier);
    }

    public void operate(MachineRecipe output) {
        List<ItemStack> processResult = output.getRecipe().output.items;
        this.operateOnce(output, processResult);
    }

    public void operateOnce(MachineRecipe output, List<ItemStack> processResult) {
        switch (this.getMode().ordinal()) {
            default: {
                this.outputSlot.add(processResult);
                break;
            }
            case 1: {
                this.outputSlot.add(this.diorite);
                break;
            }
            case 2: {
                this.outputSlot.add(this.andesite);
            }
        }
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        if (i == 10.0) {
            super.updateTileServer(entityPlayer, i);
        } else {
            this.mode = Mode.values()[(this.mode.ordinal() + 1) % Mode.values().length];
        }
    }

    public ContainerMenuAdditionGenStone getGuiContainer(Player entityPlayer) {
        return new ContainerMenuAdditionGenStone(entityPlayer, this);
    }

    public static enum Mode {
        GRANITE,
        DIORITE,
        ANDESITE;

    }
}

