/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.otherenergies.common.EnergyType;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.componets.Redstone;
import com.denfop.componets.RedstoneHandler;
import com.denfop.containermenu.ContainerMenuAutoFuse;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.screen.ScreenAutoFuse;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Localization;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityAutoFuse
extends BlockEntityInventory {
    public final Inventory slotBomb = new Inventory(this, this, Inventory.TypeItemSlot.INPUT, 1){

        @Override
        public boolean canPlaceItem(int index, ItemStack stack) {
            return stack.getItem() == IUItem.nuclear_bomb.getItem();
        }
    };
    public final ComponentBaseEnergy rad_energy = this.addComponent(ComponentBaseEnergy.asBasicSource(EnergyType.RADIATION, this, 100000.0));
    private final Redstone redstone = this.addComponent(new Redstone(this));
    public boolean fuse = false;
    public int timer = 60;
    private boolean boom = false;

    public BlockEntityAutoFuse(BlockPos pos, BlockState state) {
        super(BlockBaseMachine3Entity.autofuse, pos, state);
        this.redstone.subscribe(new RedstoneHandler(){

            @Override
            public void action(int input) {
                BlockEntityAutoFuse.this.fuse = !BlockEntityAutoFuse.this.fuse;
                new PacketUpdateFieldTile(BlockEntityAutoFuse.this.getParent(), "fuse", BlockEntityAutoFuse.this.fuse);
            }
        });
    }

    public BlockEntityInventory getParent() {
        return this;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.autofuse.info"));
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.autofuse;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.fuse = customPacketBuffer.readBoolean();
        this.timer = customPacketBuffer.readInt();
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.fuse);
        customPacketBuffer.writeInt(this.timer);
        return customPacketBuffer;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenAutoFuse((ContainerMenuAutoFuse)menu);
    }

    public ContainerMenuAutoFuse getGuiContainer(Player var1) {
        return new ContainerMenuAutoFuse(this, var1);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        super.updateField(name, is);
        if (name.equals("timer")) {
            is.readUnsignedByte();
            this.timer = is.readInt();
            if (this.timer == 0) {
                this.boom = true;
            }
        }
        if (name.equals("fuse")) {
            is.readUnsignedByte();
            this.fuse = is.readBoolean();
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        CompoundTag nbtTagCompound = super.writeToNBT(nbt);
        nbtTagCompound.putBoolean("fuse", this.fuse);
        return nbtTagCompound;
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.fuse = nbtTagCompound.getBoolean("fuse");
    }

    @Override
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.fuse && !this.slotBomb.isEmpty() && this.timer > 0) {
            --this.timer;
            if (this.timer == 0) {
                if (this.boom) {
                    this.boom = false;
                    this.level.addParticle((ParticleOptions)ParticleTypes.EXPLOSION, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5, 0.0, 0.0, 0.0);
                }
                this.timer = 60;
            } else {
                this.level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, 0.0, 0.0, 0.0);
                this.level.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        this.setActive(this.fuse);
        if (this.fuse && !this.slotBomb.isEmpty() && this.timer >= 0) {
            if (this.timer != 0) {
                --this.timer;
            }
            if (this.timer % 10 == 0) {
                new PacketUpdateFieldTile(this, "timer", this.timer);
            }
            if (this.timer == 0) {
                this.rad_energy.addEnergy(900.0);
                this.slotBomb.get(0).shrink(1);
                this.timer = 60;
            }
        }
    }
}

