/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.BlockEntityInventory;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuAutoCrafter;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryAutoCrafter;
import com.denfop.inventory.InventoryAutoCrafting;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputItemStack;
import com.denfop.screen.ScreenAutoCrafter;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.Keyboard;
import com.denfop.utils.Localization;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityAutoCrafter
extends BlockEntityElectricMachine
implements IUpgradableBlock {
    public final InventoryUpgrade upgradeSlot;
    public final double defaultEnergyConsume;
    public final int defaultOperationLength;
    public final int defaultTier;
    public final double defaultEnergyStorage;
    private final CraftingContainer crafingTable;
    private final Inventory slot = new Inventory(this, this, Inventory.TypeItemSlot.INPUT, 18){

        @Override
        public ItemStack set(int index, ItemStack content) {
            super.set(index, content);
            ((BlockEntityAutoCrafter)this.base).checkRecipe();
            return content;
        }
    };
    private final InventoryAutoCrafter autoCrafter;
    public int operationsPerTick;
    public double energyConsume;
    public ComponentProgress componentProgress;
    BaseMachineRecipe recipe;
    private boolean canRecipe = false;

    public BlockEntityAutoCrafter(BlockPos pos, BlockState state) {
        super(1000.0, 4, 1, BlockBaseMachine3Entity.autocrafter, pos, state);
        this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.addComponent(new AirPollutionComponent(this, 0.1));
        this.energyConsume = 1.0;
        this.defaultEnergyConsume = 1.0;
        this.operationsPerTick = 100;
        this.defaultOperationLength = 100;
        this.defaultTier = 4;
        this.defaultEnergyStorage = 200.0;
        this.autoCrafter = new InventoryAutoCrafter(this, null, 9);
        this.crafingTable = new InventoryAutoCrafting(this);
        this.upgradeSlot = new InventoryUpgrade(this, 4);
        this.componentProgress = this.addComponent(new ComponentProgress((BlockEntityInventory)this, 1, (short)this.defaultOperationLength));
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (!Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("press.lshift"));
        }
        if (Keyboard.isKeyDown(340)) {
            tooltip.add(Localization.translate("iu.machines_work_energy") + this.energyConsume + Localization.translate("iu.machines_work_energy_type_eu"));
            tooltip.add(Localization.translate("iu.machines_work_length") + this.operationsPerTick);
        }
        super.addInformation(stack, tooltip);
    }

    public ContainerMenuAutoCrafter getGuiContainer(Player var1) {
        return new ContainerMenuAutoCrafter(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenAutoCrafter((ContainerMenuAutoCrafter)menu);
    }

    public BaseMachineRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        boolean hasRecipe = customPacketBuffer.readBoolean();
        if (hasRecipe) {
            try {
                this.recipe = (BaseMachineRecipe)DecoderHandler.decode(customPacketBuffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.recipe = null;
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.recipe != null);
        if (this.recipe != null) {
            try {
                EncoderHandler.encode(customPacketBuffer, this.recipe);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return customPacketBuffer;
    }

    private void checkRecipe() {
        if (this.recipe == null) {
            this.canRecipe = false;
        } else {
            this.canRecipe = false;
            List<ItemStack> list = this.slot.stream().filter(itemStack -> !itemStack.isEmpty()).toList();
            List<IInputItemStack> input = this.recipe.input.getInputs();
            for (IInputItemStack needed : input) {
                int totalFound = 0;
                for (ItemStack stack : list) {
                    if (needed.matches(stack) && (totalFound += stack.getCount()) >= needed.getAmount()) break;
                }
                if (totalFound >= needed.getAmount()) continue;
                return;
            }
            this.canRecipe = true;
        }
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.level.isClientSide) {
            this.setOverclockRates();
            this.updateCraft();
            this.checkRecipe();
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.recipe != null && this.energy.getEnergy() >= this.energyConsume && this.outputSlot.canAdd(this.recipe.getOutput().items) && this.canRecipe) {
            if (!this.getActive()) {
                this.setActive(true);
            }
            this.componentProgress.addProgress(0);
            this.energy.useEnergy(this.energyConsume);
            if (this.componentProgress.getProgress() >= this.componentProgress.getMaxValue()) {
                this.operate(this.recipe);
                this.componentProgress.setProgress((short)0);
            }
        } else {
            if (this.recipe == null && this.getActive()) {
                this.componentProgress.setProgress((short)0);
            }
            if (this.getActive()) {
                this.setActive(false);
            }
        }
        if (this.upgradeSlot.tickNoMark()) {
            this.setOverclockRates();
        }
        if (this.getWorld().getGameTime() % 40L == 0L) {
            this.checkRecipe();
        }
    }

    public void setOverclockRates() {
        this.operationsPerTick = this.upgradeSlot.getOperationsPerTick(this.defaultOperationLength);
        this.componentProgress.setMaxValue((short)this.upgradeSlot.getOperationLength(this.defaultOperationLength));
        this.energyConsume = this.upgradeSlot.getEnergyDemand(this.defaultEnergyConsume);
        int tier = this.upgradeSlot.getTier(this.defaultTier);
        this.energy.setSinkTier(tier);
        this.energy.setCapacity(this.upgradeSlot.getEnergyStorage(this.defaultEnergyStorage));
        this.operationsPerTick = Math.max(1, Math.min(64, this.operationsPerTick));
    }

    public void operate(BaseMachineRecipe output) {
        for (int i = 0; i < this.operationsPerTick && this.canRecipe; ++i) {
            List<ItemStack> processResult = output.output.items;
            this.operateOnce(processResult);
            this.checkRecipe();
            if (!this.outputSlot.canAdd(this.recipe.getOutput().items)) break;
        }
    }

    private void operateOnce(List<ItemStack> processResult) {
        List<IInputItemStack> input = this.recipe.input.getInputs();
        List list = this.slot.stream().filter(itemStack -> !itemStack.isEmpty()).collect(Collectors.toList());
        for (IInputItemStack needed : input) {
            int remaining = needed.getAmount();
            for (ItemStack stack : list) {
                if (!needed.matches(stack) || remaining <= 0) continue;
                int available = stack.getCount();
                if (available >= remaining) {
                    stack.shrink(remaining);
                    remaining = 0;
                    break;
                }
                stack.shrink(available);
                remaining -= available;
            }
            if (remaining <= 0) continue;
            return;
        }
        this.outputSlot.add(processResult);
    }

    public InventoryAutoCrafter getAutoCrafter() {
        return this.autoCrafter;
    }

    public Inventory getSlot() {
        return this.slot;
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.autocrafter;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    public void updateCraft() {
        if (!(this.level instanceof ServerLevel)) {
            return;
        }
        RecipeManager recipeManager = ((ServerLevel)this.level).getRecipeManager();
        List recipes = recipeManager.getAllRecipesFor(RecipeType.CRAFTING);
        if (this.autoCrafter.isEmpty()) {
            this.recipe = null;
            return;
        }
        this.recipe = null;
        for (RecipeHolder recipe2 : recipes) {
            CraftingRecipe recipe1 = (CraftingRecipe)recipe2.value();
            if (!recipe1.matches((RecipeInput)this.crafingTable.asCraftInput(), this.level)) continue;
            ItemStack output = recipe1.assemble((RecipeInput)this.crafingTable.asCraftInput(), (HolderLookup.Provider)this.getLevel().registryAccess());
            ArrayList<IInputItemStack> list = new ArrayList<IInputItemStack>();
            for (ItemStack stack : this.autoCrafter) {
                if (stack.isEmpty()) continue;
                boolean find = false;
                for (IInputItemStack iInputItemStack : list) {
                    if (!iInputItemStack.matches(stack)) continue;
                    find = true;
                    iInputItemStack.growAmount(stack.getCount());
                }
                if (find) continue;
                IInputItemStack input = Recipes.inputFactory.getInput(stack.copy());
                list.add(input);
            }
            this.recipe = new BaseMachineRecipe(new Input(list), new RecipeOutput(null, output.copy()));
            break;
        }
        this.checkRecipe();
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

