/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.mechanism;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blockentity.base.BlockEntityElectricMachine;
import com.denfop.blockentity.base.IManufacturerBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockBaseMachine3Entity;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.ComponentTimer;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.containermenu.ContainerMenuAlkalineEarthQuarry;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.inventory.Inventory;
import com.denfop.inventory.InventoryUpgrade;
import com.denfop.items.ItemMesh;
import com.denfop.screen.ScreenAlkalineEarthQuarry;
import com.denfop.screen.ScreenIndustrialUpgrade;
import com.denfop.utils.ModUtils;
import com.denfop.utils.Timer;
import com.denfop.world.WorldBaseGen;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityAlkalineEarthQuarry
extends BlockEntityElectricMachine
implements IUpgradableBlock,
IManufacturerBlock {
    public static ItemStack lithium;
    public static ItemStack beryllium;
    public static ItemStack boron;
    public final ComponentTimer timer;
    public final Inventory inputSlotA;
    public final Inventory inputSlotB;
    public final InventoryUpgrade upgradeSlot;
    public int levelBlock;
    public int level_mesh;
    public int type_block;

    public BlockEntityAlkalineEarthQuarry(BlockPos pos, BlockState state) {
        super(100.0, 14, 1, BlockBaseMachine3Entity.alkalineearthquarry, pos, state);
        this.addComponent(new SoilPollutionComponent(this, 0.1));
        this.addComponent(new AirPollutionComponent(this, 0.1));
        this.inputSlotA = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                Item item = stack.getItem();
                if (!(item instanceof BlockItem)) {
                    return false;
                }
                BlockItem itemBlock = (BlockItem)item;
                return itemBlock.getBlock() == Blocks.DIRT || itemBlock.getBlock() == Blocks.GRAVEL || itemBlock.getBlock() == Blocks.SAND;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (content.isEmpty()) {
                    BlockEntityAlkalineEarthQuarry.this.type_block = -1;
                } else {
                    Item item = content.getItem();
                    BlockItem itemBlock = (BlockItem)item;
                    if (itemBlock.getBlock() == Blocks.DIRT) {
                        BlockEntityAlkalineEarthQuarry.this.type_block = 1;
                    }
                    if (itemBlock.getBlock() == Blocks.GRAVEL) {
                        BlockEntityAlkalineEarthQuarry.this.type_block = 2;
                    }
                    if (itemBlock.getBlock() == Blocks.SAND) {
                        BlockEntityAlkalineEarthQuarry.this.type_block = 3;
                    }
                }
                return content;
            }
        };
        this.inputSlotB = new Inventory(this, Inventory.TypeItemSlot.INPUT, 1){

            @Override
            public boolean canPlaceItem(int index, ItemStack stack) {
                return stack.getItem() instanceof ItemMesh;
            }

            @Override
            public ItemStack set(int index, ItemStack content) {
                super.set(index, content);
                if (content.isEmpty()) {
                    BlockEntityAlkalineEarthQuarry.this.level_mesh = -1;
                } else {
                    ItemMesh itemMesh = (ItemMesh)content.getItem();
                    BlockEntityAlkalineEarthQuarry.this.level_mesh = itemMesh.getLevel();
                }
                return content;
            }
        };
        this.timer = this.addComponent(new ComponentTimer(this, this, new Timer[]{new Timer(0, 0, 15)}){

            @Override
            public int getTickFromSecond() {
                return (int)Math.max(1.0, 20.0 - (double)((BlockEntityAlkalineEarthQuarry)this.parent).getLevelMechanism() * 1.9);
            }
        });
        this.upgradeSlot = new InventoryUpgrade(this, 2);
        this.levelBlock = 0;
    }

    public static void addRecipe(int container) {
    }

    @Override
    public int getLevelMechanism() {
        return this.levelBlock;
    }

    @Override
    public void setLevelMech(int level) {
        this.levelBlock = level;
    }

    @Override
    public void removeLevel(int level) {
        this.levelBlock -= level;
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.levelBlock < 10) {
            ItemStack stack = player.getItemInHand(hand);
            if (!stack.getItem().equals(IUItem.upgrade_speed_creation.getItem())) {
                return super.onActivated(player, hand, side, vec3);
            }
            stack.shrink(1);
            ++this.levelBlock;
            return true;
        }
        return super.onActivated(player, hand, side, vec3);
    }

    @Override
    public List<ItemStack> getWrenchDrops(Player player, int fortune) {
        List<ItemStack> ret = super.getWrenchDrops(player, fortune);
        if (this.levelBlock != 0) {
            ret.add(new ItemStack((ItemLike)IUItem.upgrade_speed_creation.getItem(), this.levelBlock));
            this.levelBlock = 0;
        }
        return ret;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.levelBlock = nbttagcompound.getInt("level");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putInt("level", this.levelBlock);
        return nbttagcompound;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.basemachine2.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockBaseMachine3Entity.alkalineearthquarry;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        lithium = new ItemStack((ItemLike)IUItem.ore2.getItem());
        beryllium = new ItemStack((ItemLike)IUItem.ore2.getItem(1));
        boron = new ItemStack((ItemLike)IUItem.ore2.getItem(2));
        if (this.inputSlotB.isEmpty()) {
            this.level_mesh = -1;
        } else {
            ItemMesh itemMesh = (ItemMesh)this.inputSlotB.get(0).getItem();
            this.level_mesh = itemMesh.getLevel();
        }
        if (this.inputSlotA.isEmpty()) {
            this.type_block = -1;
        } else {
            Item item = this.inputSlotA.get(0).getItem();
            BlockItem itemBlock = (BlockItem)item;
            if (itemBlock.getBlock() == Blocks.DIRT) {
                this.type_block = 1;
            }
            if (itemBlock.getBlock() == Blocks.GRAVEL) {
                this.type_block = 2;
            }
            if (itemBlock.getBlock() == Blocks.SAND) {
                this.type_block = 3;
            }
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.inputSlotA.get(0).isEmpty() && !this.inputSlotB.isEmpty() && this.energy.canUseEnergy(1.0) && this.canOperate() && this.outputSlot.canAdd(this.getItemStack())) {
            this.setActive(true);
            if (!this.timer.isCanWork()) {
                this.timer.setCanWork(true);
            }
            this.energy.useEnergy(1.0);
            if (this.timer.getTimers().get(0).getTime() <= 0) {
                this.inputSlotA.get(0).shrink(1);
                if (this.getChance()) {
                    this.outputSlot.add(this.getItemStack());
                }
                ItemMesh itemMesh = (ItemMesh)this.inputSlotB.get(0).getItem();
                ModUtils.nbt(this.inputSlotB.get(0));
                itemMesh.applyCustomDamage(this.inputSlotB.get(0), 1, null);
                if (itemMesh.getMaxCustomDamage(this.inputSlotB.get(0)) - itemMesh.getCustomDamage(this.inputSlotB.get(0)) == 0) {
                    this.inputSlotB.get(0).shrink(1);
                }
                this.timer.resetTime();
            }
        } else {
            this.timer.setCanWork(false);
            this.setActive(false);
            return;
        }
        this.upgradeSlot.tickNoMark();
    }

    private boolean getChance() {
        if (this.level_mesh == 1 && this.type_block == 3) {
            return WorldBaseGen.random.nextInt(100) < 2;
        }
        if (this.level_mesh == 2) {
            if (this.type_block == 3) {
                return WorldBaseGen.random.nextInt(100) < 5;
            }
            if (this.type_block == 1) {
                return WorldBaseGen.random.nextInt(100) < 2;
            }
            if (this.type_block == 2) {
                return WorldBaseGen.random.nextInt(100) == 0;
            }
        }
        if (this.level_mesh == 3) {
            if (this.type_block == 3) {
                return WorldBaseGen.random.nextInt(100) < 10;
            }
            if (this.type_block == 1) {
                return WorldBaseGen.random.nextInt(100) < 5;
            }
            if (this.type_block == 2) {
                return WorldBaseGen.random.nextInt(100) < 3;
            }
        }
        if (this.level_mesh == 4) {
            if (this.type_block == 3) {
                return WorldBaseGen.random.nextInt(100) < 15;
            }
            if (this.type_block == 1) {
                return WorldBaseGen.random.nextInt(100) < 10;
            }
            if (this.type_block == 2) {
                return WorldBaseGen.random.nextInt(100) < 7;
            }
        }
        if (this.level_mesh == 5) {
            if (this.type_block == 3) {
                return WorldBaseGen.random.nextInt(100) < 20;
            }
            if (this.type_block == 1) {
                return WorldBaseGen.random.nextInt(100) < 15;
            }
            if (this.type_block == 2) {
                return WorldBaseGen.random.nextInt(100) < 11;
            }
        }
        return false;
    }

    private ItemStack getItemStack() {
        switch (this.type_block) {
            case 1: {
                return beryllium;
            }
            case 2: {
                return boron;
            }
            case 3: {
                return lithium;
            }
        }
        return ItemStack.EMPTY;
    }

    private boolean canOperate() {
        if (this.level_mesh == 1 && this.type_block == 3) {
            return true;
        }
        if (this.level_mesh == 2 && (this.type_block == 3 || this.type_block == 2 || this.type_block == 1)) {
            return true;
        }
        return this.level_mesh >= 3 && (this.type_block == 3 || this.type_block == 1 || this.type_block == 2);
    }

    public ContainerMenuAlkalineEarthQuarry getGuiContainer(Player var1) {
        return new ContainerMenuAlkalineEarthQuarry(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenAlkalineEarthQuarry((ContainerMenuAlkalineEarthQuarry)menu);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }
}

