/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.gaswell;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.vein.gas.GasVeinBase;
import com.denfop.api.vein.gas.GasVeinSystem;
import com.denfop.api.vein.gas.TypeGas;
import com.denfop.blockentity.gaswell.IController;
import com.denfop.blockentity.gaswell.ISocket;
import com.denfop.blockentity.gaswell.ITank;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockBase;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockGasWellEntity;
import com.denfop.componets.Energy;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuGasWellController;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.screen.ScreenGasWellController;
import com.denfop.screen.ScreenIndustrialUpgrade;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class BlockEntityGasWellController
extends BlockEntityMultiBlockBase
implements IController,
IUpdatableTileEvent {
    public boolean work;
    public ITank tank;
    public ISocket socket;
    public GasVeinBase vein;

    public BlockEntityGasWellController(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.GasWellMultiBlock, BlockGasWellEntity.gas_well_controller, pos, state);
    }

    public ContainerMenuGasWellController getGuiContainer(Player var1) {
        return new ContainerMenuGasWellController(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenGasWellController((ContainerMenuGasWellController)menu);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.level.isClientSide) {
            return;
        }
        if (this.getWorld().dimension() != Level.OVERWORLD) {
            this.vein = GasVeinSystem.system.getEMPTY();
        } else {
            LevelChunk chunk = this.getWorld().getChunkAt(this.pos);
            ChunkPos chunkpos = chunk.getPos();
            if (!GasVeinSystem.system.getChunkPos().contains(chunkpos)) {
                GasVeinSystem.system.addVein((ChunkAccess)chunk);
            }
            this.vein = GasVeinSystem.system.getVein(chunkpos);
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.full && this.work && this.vein != null && this.vein.isFind() && this.getEnergy().canUseEnergy(2.0)) {
            int amount = this.vein.getCol();
            amount = Math.min(Math.min(5, amount), this.tank.getTank().getCapacity() - this.tank.getTank().getFluidAmount());
            Fluid fluid = null;
            if (this.vein.getType() == TypeGas.IODINE) {
                fluid = (Fluid)FluidName.fluidiodine.getInstance().get();
            }
            if (this.vein.getType() == TypeGas.BROMIDE) {
                fluid = (Fluid)FluidName.fluidbromine.getInstance().get();
            }
            if (this.vein.getType() == TypeGas.CHLORINE) {
                fluid = (Fluid)FluidName.fluidchlorum.getInstance().get();
            }
            if (this.vein.getType() == TypeGas.FLORINE) {
                fluid = (Fluid)FluidName.fluidfluor.getInstance().get();
            }
            if (fluid == null) {
                return;
            }
            this.getEnergy().useEnergy(2.0);
            this.vein.removeCol(amount);
            this.tank.getTank().fill(new FluidStack(fluid, amount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.gas_well.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockGasWellEntity.gas_well_controller;
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        this.work = !this.work;
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBytes((ByteBuf)this.socket.getEnergy().updateComponent());
        customPacketBuffer.writeBytes((ByteBuf)this.tank.getTank().writePacket());
        customPacketBuffer.writeBoolean(this.vein != null);
        customPacketBuffer.writeBytes((ByteBuf)this.vein.writePacket(customPacketBuffer.registryAccess()));
        customPacketBuffer.writeBoolean(this.work);
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.socket.getEnergy().onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.tank.getTank().readPacket(customPacketBuffer);
        boolean hasVein = customPacketBuffer.readBoolean();
        if (hasVein) {
            this.vein = new GasVeinBase(customPacketBuffer);
        }
        this.work = customPacketBuffer.readBoolean();
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.socket = null;
            this.tank = null;
        }
    }

    @Override
    public Energy getEnergy() {
        return this.socket.getEnergy();
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ISocket.class);
        this.socket = (ISocket)this.getWorld().getBlockEntity(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ITank.class);
        this.tank = (ITank)this.getWorld().getBlockEntity(pos1.get(0));
    }

    @Override
    public void usingBeforeGUI() {
    }
}

