/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.gaswell;

import com.denfop.IUItem;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.api.container.CustomWorldContainer;
import com.denfop.api.vein.gas.GasVeinBase;
import com.denfop.api.vein.gas.GasVeinSystem;
import com.denfop.blockentity.gaswell.IAnalyzer;
import com.denfop.blockentity.gaswell.IController;
import com.denfop.blockentity.mechanism.multiblocks.base.BlockEntityMultiBlockElement;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.mechanism.BlockGasWellEntity;
import com.denfop.containermenu.ContainerMenuBase;
import com.denfop.containermenu.ContainerMenuGasWellAnalyzer;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.screen.ScreenGasWellAnalyzer;
import com.denfop.screen.ScreenIndustrialUpgrade;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockEntityGasWellAnalyzer
extends BlockEntityMultiBlockElement
implements IAnalyzer,
IUpdatableTileEvent {
    public int progress;
    public GasVeinBase vein;
    public int col;
    public boolean work;

    public BlockEntityGasWellAnalyzer(BlockPos pos, BlockState state) {
        super(BlockGasWellEntity.gas_well_analyzer, pos, state);
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.gas_well.getBlock(this.getTeBlock());
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return BlockGasWellEntity.gas_well_analyzer;
    }

    public ContainerMenuGasWellAnalyzer getGuiContainer(Player var1) {
        return new ContainerMenuGasWellAnalyzer(this, var1);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ScreenIndustrialUpgrade<ContainerMenuBase<? extends CustomWorldContainer>> getGui(Player var1, ContainerMenuBase<? extends CustomWorldContainer> menu) {
        return new ScreenGasWellAnalyzer((ContainerMenuGasWellAnalyzer)menu);
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeInt(this.progress);
        customPacketBuffer.writeBoolean(this.vein != null);
        customPacketBuffer.writeBytes((ByteBuf)this.vein.writePacket(customPacketBuffer.registryAccess()));
        return customPacketBuffer;
    }

    @Override
    public boolean hasOwnInventory() {
        return this.getMain() != null;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        this.progress = customPacketBuffer.readInt();
        boolean hasVein = customPacketBuffer.readBoolean();
        if (hasVein) {
            this.vein = new GasVeinBase(customPacketBuffer);
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.putBoolean("work", this.work);
        nbt.putInt("progress", this.progress);
        return super.writeToNBT(nbt);
    }

    @Override
    public void readFromNBT(CompoundTag nbtTagCompound) {
        super.readFromNBT(nbtTagCompound);
        this.work = nbtTagCompound.getBoolean("analyzer");
        this.progress = nbtTagCompound.getInt("progress");
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (this.level.isClientSide) {
            return;
        }
        if (this.getWorld().dimension() != Level.OVERWORLD) {
            this.vein = GasVeinSystem.system.getEMPTY();
        } else {
            LevelChunk chunk = this.getWorld().getChunkAt(this.pos);
            ChunkPos chunkpos = chunk.getPos();
            if (!GasVeinSystem.system.getChunkPos().contains(chunkpos)) {
                GasVeinSystem.system.addVein((ChunkAccess)chunk);
            }
            this.vein = GasVeinSystem.system.getVein(chunkpos);
            if (this.vein.isFind()) {
                this.progress = 1200;
            }
            if (this.progress >= 1200) {
                this.vein.setFind(true);
            }
        }
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.vein == null) {
            return;
        }
        if (this.work && this.progress < 1200 && ((IController)this.getMain()).getEnergy().getEnergy() >= 5.0 && !this.vein.isFind()) {
            ++this.progress;
            ((IController)this.getMain()).getEnergy().useEnergy(5.0);
            if (this.progress >= 1200) {
                this.progress = 1200;
                this.vein.setFind(true);
            }
        } else if (this.work) {
            this.work = false;
        }
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        if (var2 == 0.0 && this.getMain() != null && !this.vein.isFind() && this.progress < 1200) {
            this.work = !this.work;
        }
    }
}

