/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blockentity.bee;

import com.denfop.IUItem;
import com.denfop.api.bee.Bee;
import com.denfop.api.blockentity.MultiBlockEntity;
import com.denfop.blockentity.base.BlockEntityBase;
import com.denfop.blockentity.bee.BlockEntityApiary;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.datagen.DamageTypes;
import com.denfop.items.energy.ItemNet;
import com.denfop.world.WorldBaseGen;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityHive
extends BlockEntityBase {
    private final Bee bee;

    public TileEntityHive(Bee bee, MultiBlockEntity tileBlock, BlockPos pos, BlockState state) {
        super(tileBlock, pos, state);
        this.bee = bee;
    }

    @Override
    public boolean canEntityDestroy(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getMainHandItem().getItem() instanceof ItemNet;
        }
        return false;
    }

    @Override
    public List<ItemStack> getSelfDrops(int fortune, boolean wrench) {
        ItemStack stack = new ItemStack((ItemLike)IUItem.jarBees.getStack(0));
        stack.set(DataComponentsInit.BEE, (Object)this.bee.getId());
        stack.set(DataComponentsInit.SWARM, (Object)(WorldBaseGen.random.nextInt(this.bee.getMaxSwarm() / 2) + 15));
        return Collections.singletonList(stack);
    }

    @Override
    public List<ItemStack> getAuxDrops(int fortune) {
        return super.getAuxDrops(fortune);
    }

    @Override
    public void onClicked(Player player) {
        if (BlockEntityApiary.hasDamagePlayer) {
            player.hurt(player.damageSources().source(DamageTypes.beeObject), 5.0f);
        }
    }

    @Override
    public MultiBlockEntity getTeBlock() {
        return null;
    }

    @Override
    public BlockTileEntity getBlock() {
        return null;
    }
}

